/*
 * Decompiled with CFR 0.152.
 */
package org.saxpath.helpers;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.saxpath.SAXPathException;
import org.saxpath.XPathReader;
import org.saxpath.helpers.XPathReaderFactory;

public class XPathReaderFactoryTest
extends TestCase {
    static /* synthetic */ Class class$org$saxpath$helpers$MockXPathReader;

    public XPathReaderFactoryTest(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testDefault() {
        System.setProperty("org.saxpath.driver", "");
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            Assert.assertNotNull((Object)reader);
        }
        catch (SAXPathException e2) {
            Assert.fail((String)e2.getMessage());
        }
    }

    public void testInvalidByProperty() {
        System.setProperty("org.saxpath.driver", "java.lang.String");
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            Assert.fail((String)"Should have thrown SAXPathException");
        }
        catch (SAXPathException sAXPathException) {}
    }

    public void testInvalidExplicit() {
        try {
            XPathReader reader = XPathReaderFactory.createReader("java.lang.String");
            Assert.fail((String)"Should have thrown SAXPathException");
        }
        catch (SAXPathException sAXPathException) {}
    }

    public void testNonExistantByProperty() {
        System.setProperty("org.saxpath.driver", "i.am.a.class.that.does.not.Exist");
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            Assert.fail((String)"Should have thrown SAXPathException");
        }
        catch (SAXPathException sAXPathException) {}
    }

    public void testNonExistantExplicit() {
        try {
            XPathReader reader = XPathReaderFactory.createReader("i.am.a.class.that.does.not.Exist");
            Assert.fail((String)"Should havfe thrown SAXPathException");
        }
        catch (SAXPathException sAXPathException) {}
    }

    public void testValidByProperty() {
        System.setProperty("org.saxpath.driver", "org.saxpath.helpers.MockXPathReader");
        try {
            XPathReader reader = XPathReaderFactory.createReader();
            Assert.assertNotNull((Object)reader);
            Assert.assertSame((Object)(class$org$saxpath$helpers$MockXPathReader != null ? class$org$saxpath$helpers$MockXPathReader : (class$org$saxpath$helpers$MockXPathReader = XPathReaderFactoryTest.class$("org.saxpath.helpers.MockXPathReader"))), reader.getClass());
        }
        catch (SAXPathException e2) {
            Assert.fail((String)e2.getMessage());
        }
    }

    public void testValidExplicit() {
        try {
            XPathReader reader = XPathReaderFactory.createReader("org.saxpath.helpers.MockXPathReader");
            Assert.assertNotNull((Object)reader);
            Assert.assertSame((Object)(class$org$saxpath$helpers$MockXPathReader != null ? class$org$saxpath$helpers$MockXPathReader : (class$org$saxpath$helpers$MockXPathReader = XPathReaderFactoryTest.class$("org.saxpath.helpers.MockXPathReader"))), reader.getClass());
        }
        catch (SAXPathException e2) {
            Assert.fail((String)e2.getMessage());
        }
    }
}

