/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();
    private static final long serialVersionUID = 362498820763181265L;

    public IdentityHashMap() {
        this(11, 0.75f);
    }

    public IdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IdentityHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    int capacity() {
        return this.table.length;
    }

    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            IdentityHashMap t = (IdentityHashMap)super.clone();
            t.table = new Entry[this.table.length];
            int i2 = this.table.length;
            while (i2-- > 0) {
                Entry entry = t.table[i2] = this.table[i2] != null ? (Entry)this.table[i2].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean containsKey(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    return true;
                }
                e2 = e2.next;
            }
        } else {
            Entry e3 = tab[0];
            while (e3 != null) {
                if (e3.key == null) {
                    return true;
                }
                e3 = e3.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Entry[] tab = this.table;
        if (value == null) {
            int i2 = tab.length;
            while (i2-- > 0) {
                Entry e2 = tab[i2];
                while (e2 != null) {
                    if (e2.value == null) {
                        return true;
                    }
                    e2 = e2.next;
                }
            }
        } else {
            int i3 = tab.length;
            while (i3-- > 0) {
                Entry e3 = tab[i3];
                while (e3 != null) {
                    if (value.equals(e3.value)) {
                        return true;
                    }
                    e3 = e3.next;
                }
            }
        }
        return false;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityHashMap.this.table;
                    int hash = key == null ? 0 : System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e2 = tab[index];
                    while (e2 != null) {
                        if (e2.hash == hash && e2.equals(entry)) {
                            return true;
                        }
                        e2 = e2.next;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(2);
                }

                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityHashMap.this.table;
                    int hash = key == null ? 0 : System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e2 = tab[index];
                    Entry prev = null;
                    while (e2 != null) {
                        if (e2.hash == hash && e2.equals(entry)) {
                            IdentityHashMap identityHashMap = IdentityHashMap.this;
                            identityHashMap.modCount = identityHashMap.modCount + 1;
                            if (prev != null) {
                                prev.next = e2.next;
                            } else {
                                tab[index] = e2.next;
                            }
                            IdentityHashMap identityHashMap2 = IdentityHashMap.this;
                            identityHashMap2.count = identityHashMap2.count - 1;
                            e2.value = null;
                            return true;
                        }
                        prev = e2;
                        e2 = e2.next;
                    }
                    return false;
                }

                public int size() {
                    return IdentityHashMap.this.count;
                }
            };
        }
        return this.entrySet;
    }

    public Object get(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    return e2.value;
                }
                e2 = e2.next;
            }
        } else {
            Entry e3 = tab[0];
            while (e3 != null) {
                if (e3.key == null) {
                    return e3.value;
                }
                e3 = e3.next;
            }
        }
        return null;
    }

    private Iterator getHashIterator(int type) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(type);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object o2) {
                    return IdentityHashMap.this.containsKey(o2);
                }

                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(0);
                }

                public boolean remove(Object o2) {
                    int oldSize = IdentityHashMap.this.count;
                    IdentityHashMap.this.remove(o2);
                    return IdentityHashMap.this.count != oldSize;
                }

                public int size() {
                    return IdentityHashMap.this.count;
                }
            };
        }
        return this.keySet;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public Object put(Object key, Object value) {
        Entry e2;
        Entry[] tab = this.table;
        int hash = 0;
        int index = 0;
        if (key != null) {
            hash = System.identityHashCode(key);
            index = (hash & Integer.MAX_VALUE) % tab.length;
            e2 = tab[index];
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    Object old = e2.value;
                    e2.value = value;
                    return old;
                }
                e2 = e2.next;
            }
        } else {
            e2 = tab[0];
            while (e2 != null) {
                if (e2.key == null) {
                    Object old = e2.value;
                    e2.value = value;
                    return old;
                }
                e2 = e2.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e2 = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public void putAll(Map t) {
        Iterator i2 = t.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry e2 = i2.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        int size = s.readInt();
        int i2 = 0;
        while (i2 < size) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            ++i2;
        }
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry old = oldMap[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = (e2.hash & Integer.MAX_VALUE) % newCapacity;
                e2.next = newMap[index];
                newMap[index] = e2;
            }
        }
    }

    public Object remove(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            Entry prev = null;
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e2.next;
                    } else {
                        tab[index] = e2.next;
                    }
                    --this.count;
                    Object oldValue = e2.value;
                    e2.value = null;
                    return oldValue;
                }
                prev = e2;
                e2 = e2.next;
            }
        } else {
            Entry e3 = tab[0];
            Entry prev = null;
            while (e3 != null) {
                if (e3.key == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e3.next;
                    } else {
                        tab[0] = e3.next;
                    }
                    --this.count;
                    Object oldValue = e3.value;
                    e3.value = null;
                    return oldValue;
                }
                prev = e3;
                e3 = e3.next;
            }
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object o2) {
                    return IdentityHashMap.this.containsValue(o2);
                }

                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(1);
                }

                public int size() {
                    return IdentityHashMap.this.count;
                }
            };
        }
        return this.values;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        int index = this.table.length - 1;
        while (index >= 0) {
            Entry entry = this.table[index];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
            --index;
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            if (this.key == null) {
                if (e2.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl = this.key.equals(e2.getKey());
                if (!bl) return false;
            }
            if (this.value == null) {
                if (e2.getValue() == null) return true;
                return false;
            }
            boolean bl = this.value.equals(e2.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.key)) + "=" + this.value;
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int type) {
            this.table = IdentityHashMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.type = type;
        }

        public boolean hasNext() {
            Entry e2 = this.entry;
            int i2 = this.index;
            Entry[] t = this.table;
            while (e2 == null && i2 > 0) {
                e2 = t[--i2];
            }
            this.entry = e2;
            this.index = i2;
            return e2 != null;
        }

        public Object next() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.entry;
            int i2 = this.index;
            Entry[] t = this.table;
            while (et == null && i2 > 0) {
                et = t[--i2];
            }
            this.entry = et;
            this.index = i2;
            if (et != null) {
                Entry e2 = this.lastReturned = this.entry;
                this.entry = e2.next;
                return this.type == 0 ? e2.key : (this.type == 1 ? e2.value : e2);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IdentityHashMap.this.table;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            Entry prev = null;
            while (e2 != null) {
                if (e2 == this.lastReturned) {
                    IdentityHashMap identityHashMap = IdentityHashMap.this;
                    identityHashMap.modCount = identityHashMap.modCount + 1;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e2.next;
                    } else {
                        prev.next = e2.next;
                    }
                    IdentityHashMap identityHashMap2 = IdentityHashMap.this;
                    identityHashMap2.count = identityHashMap2.count - 1;
                    this.lastReturned = null;
                    return;
                }
                prev = e2;
                e2 = e2.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

