/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.HashMap;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class TranslateFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 3) {
            return TranslateFunction.evaluate(args.get(0), args.get(1), args.get(2), context.getNavigator());
        }
        throw new FunctionCallException("translate() requires three arguments.");
    }

    public static String evaluate(Object strArg, Object fromArg, Object toArg, Navigator nav) {
        String inStr = StringFunction.evaluate(strArg, nav);
        String fromStr = StringFunction.evaluate(fromArg, nav);
        String toStr = StringFunction.evaluate(toArg, nav);
        HashMap<String, Character> charMap = new HashMap<String, Character>();
        int fromLen = fromStr.length();
        int toLen = toStr.length();
        int i2 = 0;
        while (i2 < fromLen) {
            String cFrom = fromStr.substring(i2, i2 + 1).intern();
            if (!charMap.containsKey(cFrom)) {
                if (i2 < toLen) {
                    Character cTo = new Character(toStr.charAt(i2));
                    charMap.put(cFrom, cTo);
                } else {
                    charMap.put(cFrom, null);
                }
            }
            ++i2;
        }
        StringBuffer outStr = new StringBuffer(inStr.length());
        int inLen = inStr.length();
        int i3 = 0;
        while (i3 < inLen) {
            String cIn = inStr.substring(i3, i3 + 1);
            if (charMap.containsKey(cIn)) {
                Character cTo = (Character)charMap.get(cIn);
                if (cTo != null) {
                    outStr.append(cTo.charValue());
                }
            } else {
                outStr.append(cIn);
            }
            ++i3;
        }
        return new String(outStr);
    }
}

