/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.expr.Predicate;
import org.jaxen.function.BooleanFunction;

class PredicateSet
implements Serializable {
    private List predicates = Collections.EMPTY_LIST;

    public void addPredicate(Predicate predicate) {
        if (this.predicates == Collections.EMPTY_LIST) {
            this.predicates = new ArrayList();
        }
        this.predicates.add(predicate);
    }

    protected boolean evaluateAsBoolean(List contextNodeSet, ContextSupport support) throws JaxenException {
        List result = this.evaluatePredicates(contextNodeSet, support);
        return result.isEmpty() ^ true;
    }

    protected List evaluatePredicates(List contextNodeSet, ContextSupport support) throws JaxenException {
        if (this.predicates.size() == 0) {
            return contextNodeSet;
        }
        ArrayList newNodeSet = new ArrayList();
        ArrayList filterSet = contextNodeSet;
        List predicates = this.getPredicates();
        Iterator predIter = predicates.iterator();
        Predicate eachPred = null;
        Object contextNode = null;
        Object predResult = null;
        Context predContext = new Context(support);
        if (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            int filterSize = filterSet.size();
            int i2 = 0;
            while (i2 < filterSize) {
                contextNode = filterSet.get(i2);
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(contextNode);
                predContext.setNodeSet(list);
                predContext.setPosition(i2 + 1);
                predContext.setSize(filterSize);
                predResult = eachPred.evaluate(predContext);
                if (predResult instanceof Number) {
                    int proximity = ((Number)predResult).intValue();
                    if (proximity == i2 + 1) {
                        newNodeSet.add(contextNode);
                    }
                } else {
                    Boolean includes = BooleanFunction.evaluate(predResult, predContext.getNavigator());
                    if (includes.booleanValue()) {
                        newNodeSet.add(contextNode);
                    }
                }
                ++i2;
            }
        }
        boolean nodesFiltered = false;
        filterSet = newNodeSet;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            int filterSize = filterSet.size();
            int i3 = 0;
            while (i3 < filterSize) {
                contextNode = filterSet.get(i3);
                if (contextNode != null) {
                    ArrayList<Object> list = new ArrayList<Object>(1);
                    list.add(contextNode);
                    predContext.setNodeSet(list);
                    predContext.setPosition(i3 + 1);
                    predContext.setSize(filterSize);
                    predResult = eachPred.evaluate(predContext);
                    if (predResult instanceof Number) {
                        int proximity = ((Number)predResult).intValue();
                        if (proximity != i3 + 1) {
                            filterSet.set(i3, null);
                            nodesFiltered = true;
                        }
                    } else {
                        Boolean includes = BooleanFunction.evaluate(predResult, predContext.getNavigator());
                        if (!includes.booleanValue()) {
                            filterSet.set(i3, null);
                            nodesFiltered = true;
                        }
                    }
                }
                ++i3;
            }
        }
        if (nodesFiltered) {
            Iterator iter = filterSet.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj != null) continue;
                iter.remove();
            }
        }
        return filterSet;
    }

    public List getPredicates() {
        return this.predicates;
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            buf.append(eachPred.getText());
        }
        return buf.toString();
    }

    public void simplify() {
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            eachPred.simplify();
        }
    }
}

