/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.exml;

import electric.xml.Attribute;
import electric.xml.Child;
import electric.xml.Children;
import electric.xml.Comment;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Instruction;
import electric.xml.Parent;
import electric.xml.ParseException;
import electric.xml.Text;
import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.XPath;
import org.jaxen.exml.AttributesIterator;
import org.jaxen.exml.ChildrenIterator;
import org.jaxen.exml.ElectricXPath;
import org.jaxen.exml.Namespace;
import org.jaxen.util.SingleObjectIterator;
import org.saxpath.SAXPathException;

public class DocumentNavigator
extends DefaultNavigator {
    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (!(contextNode instanceof Element)) {
            return null;
        }
        Element elem = (Element)contextNode;
        return new AttributesIterator(elem.getAttributes());
    }

    public String getAttributeName(Object obj) {
        Attribute attr = (Attribute)obj;
        return attr.getName();
    }

    public String getAttributeNamespaceUri(Object obj) {
        Attribute attr = (Attribute)obj;
        return attr.getNamespace();
    }

    public String getAttributeQName(Object obj) {
        Attribute attr = (Attribute)obj;
        return attr.getQName();
    }

    public String getAttributeStringValue(Object obj) {
        Attribute attr = (Attribute)obj;
        return attr.getValue();
    }

    public Iterator getChildAxisIterator(Object contextNode) {
        if (contextNode instanceof Parent) {
            return new ChildrenIterator(((Parent)contextNode).getChildren());
        }
        return null;
    }

    public String getCommentStringValue(Object obj) {
        Comment cmt = (Comment)obj;
        return cmt.getString();
    }

    public Object getDocument(String url) throws FunctionCallException {
        try {
            return new Document(new File(url));
        }
        catch (ParseException e2) {
            throw new FunctionCallException(e2.getMessage());
        }
    }

    public Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof Document) {
            return contextNode;
        }
        Element elem = (Element)contextNode;
        return elem.getDocument();
    }

    public String getElementName(Object obj) {
        Element elem = (Element)obj;
        return elem.getName();
    }

    public String getElementNamespaceUri(Object obj) {
        Element elem = (Element)obj;
        return elem.getNamespace();
    }

    public String getElementQName(Object obj) {
        Element elem = (Element)obj;
        return elem.getQName();
    }

    public String getElementStringValue(Object obj) {
        Element elem = (Element)obj;
        return this.getStringValue(elem);
    }

    public static DocumentNavigator getInstance() {
        return Singleton.instance;
    }

    public Iterator getNamespaceAxisIterator(Object contextNode) {
        if (contextNode instanceof Element) {
            Element elem = (Element)contextNode;
            HashMap<String, Namespace> nsMap = new HashMap<String, Namespace>();
            Element current = elem;
            while (current != null) {
                Parent parent;
                Dictionary namespaces = current.getNamespaces();
                if (namespaces != null) {
                    Enumeration keys = namespaces.keys();
                    while (keys.hasMoreElements()) {
                        String prefix = (String)keys.nextElement();
                        if (nsMap.containsKey(prefix)) continue;
                        String uri = (String)namespaces.get(prefix);
                        nsMap.put(prefix, new Namespace(elem, prefix, uri));
                    }
                }
                if (!((parent = current.getParent()) instanceof Element)) break;
                current = (Element)parent;
            }
            Namespace xml = new Namespace(elem, "xml", "http://www.w3.org/XML/1998/namespace");
            nsMap.put("xml", xml);
            return nsMap.values().iterator();
        }
        return null;
    }

    public String getNamespacePrefix(Object obj) {
        Namespace ns = (Namespace)obj;
        return ns.getPrefix();
    }

    public String getNamespaceStringValue(Object obj) {
        Namespace ns = (Namespace)obj;
        return ns.getURI();
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        Object parent = null;
        if (contextNode instanceof Document) {
            parent = contextNode;
        } else if (contextNode instanceof Element) {
            parent = ((Element)contextNode).getParent();
            if (parent == null) {
                parent = ((Element)contextNode).getDocument();
            }
        } else if (contextNode instanceof Attribute) {
            parent = ((Attribute)contextNode).getElement();
        } else if (contextNode instanceof Instruction) {
            parent = ((Instruction)contextNode).getParent();
        } else if (contextNode instanceof Text) {
            parent = ((Text)contextNode).getParent();
        } else if (contextNode instanceof Comment) {
            parent = ((Text)contextNode).getParent();
        } else if (contextNode instanceof Namespace) {
            parent = ((Namespace)contextNode).getElement();
        }
        if (parent != null) {
            return new SingleObjectIterator(parent);
        }
        return null;
    }

    public String getProcessingInstructionData(Object obj) {
        Instruction pi = (Instruction)obj;
        return pi.getContent();
    }

    public String getProcessingInstructionTarget(Object obj) {
        Instruction pi = (Instruction)obj;
        return pi.getTarget();
    }

    private String getStringValue(Element e2) {
        StringBuffer buf = new StringBuffer();
        Children children = e2.getChildren();
        Child eachChild = null;
        while ((eachChild = children.next()) != null) {
            if (eachChild instanceof Element) {
                buf.append(this.getStringValue((Element)eachChild));
                continue;
            }
            if (!(eachChild instanceof Text)) continue;
            buf.append(((Text)eachChild).getString());
        }
        return buf.toString();
    }

    public String getTextStringValue(Object obj) {
        Text txt = (Text)obj;
        return txt.getString();
    }

    public boolean isAttribute(Object obj) {
        return obj instanceof Attribute;
    }

    public boolean isComment(Object obj) {
        return obj instanceof Comment;
    }

    public boolean isDocument(Object obj) {
        return obj instanceof Document;
    }

    public boolean isElement(Object obj) {
        return obj instanceof Element;
    }

    public boolean isNamespace(Object obj) {
        return obj instanceof Namespace;
    }

    public boolean isProcessingInstruction(Object obj) {
        return obj instanceof Instruction;
    }

    public boolean isText(Object obj) {
        return obj instanceof Text;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new ElectricXPath(xpath);
    }

    public String translateNamespacePrefixToUri(String prefix, Object context) {
        Element element = null;
        if (context instanceof Element) {
            element = (Element)context;
        }
        if (element != null) {
            return element.getNamespace(prefix);
        }
        return null;
    }

    private static class Singleton {
        private static DocumentNavigator instance = new DocumentNavigator();

        Singleton() {
        }
    }
}

