/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom.NamespaceNode;
import org.saxpath.SAXPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DocumentNavigator
extends DefaultNavigator {
    private static final Iterator EMPTY_ITERATOR = new HashMap().values().iterator();
    private static final DocumentNavigator SINGLETON = new DocumentNavigator();

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (this.isElement(contextNode)) {
            return new AttributeIterator((Node)contextNode);
        }
        return EMPTY_ITERATOR;
    }

    public String getAttributeName(Object object) {
        String name = ((Node)object).getLocalName();
        if (name == null) {
            name = ((Node)object).getNodeName();
        }
        return name;
    }

    public String getAttributeNamespaceUri(Object object) {
        String uri = ((Node)object).getNamespaceURI();
        return uri;
    }

    public String getAttributeQName(Object object) {
        String qname = ((Node)object).getNodeName();
        if (qname == null) {
            qname = ((Node)object).getLocalName();
        }
        return qname;
    }

    public String getAttributeStringValue(Object object) {
        if (this.isAttribute(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public Iterator getChildAxisIterator(Object contextNode) {
        return new NodeIterator(this, (Node)contextNode){

            protected Node getFirstNode(Node node) {
                return node.getFirstChild();
            }

            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    public String getCommentStringValue(Object object) {
        if (this.isComment(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public Object getDocument(String uri) throws FunctionCallException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(uri);
        }
        catch (Exception e2) {
            throw new FunctionCallException("Failed to parse doucment for URI: " + uri, e2);
        }
    }

    public Object getDocumentNode(Object contextNode) {
        if (this.isDocument(contextNode)) {
            return contextNode;
        }
        return ((Node)contextNode).getOwnerDocument();
    }

    public Object getElementById(Object object, String elementId) {
        Document doc = (Document)this.getDocumentNode(object);
        if (doc != null) {
            return doc.getElementById(elementId);
        }
        return null;
    }

    public String getElementName(Object object) {
        String name = ((Node)object).getLocalName();
        if (name == null) {
            name = ((Node)object).getNodeName();
        }
        return name;
    }

    public String getElementNamespaceUri(Object object) {
        String uri = ((Node)object).getNamespaceURI();
        return uri;
    }

    public String getElementQName(Object object) {
        String qname = ((Node)object).getNodeName();
        if (qname == null) {
            qname = ((Node)object).getLocalName();
        }
        return qname;
    }

    public String getElementStringValue(Object object) {
        if (this.isElement(object)) {
            return this.getStringValue((Node)object, new StringBuffer()).toString();
        }
        return null;
    }

    public Iterator getFollowingAxisIterator(Object contextNode) {
        return new NodeIterator(this, (Node)contextNode){

            protected Node getFirstNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node sibling = node.getNextSibling();
                if (sibling == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return sibling;
            }

            protected Node getNextNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node n2 = node.getFirstChild();
                if (n2 == null) {
                    n2 = node.getNextSibling();
                }
                if (n2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return n2;
            }
        };
    }

    public Iterator getFollowingSiblingAxisIterator(Object contextNode) {
        return new NodeIterator(this, (Node)contextNode){

            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            protected Node getNextNode(Node node) {
                return node.getNextSibling();
            }
        };
    }

    public static DocumentNavigator getInstance() {
        return SINGLETON;
    }

    public Iterator getNamespaceAxisIterator(Object contextNode) {
        if (this.isElement(contextNode)) {
            HashMap<String, NamespaceNode> nsMap = new HashMap<String, NamespaceNode>();
            Node n2 = (Node)contextNode;
            while (n2 != null) {
                if (n2.hasAttributes()) {
                    NamedNodeMap atts = n2.getAttributes();
                    int length = atts.getLength();
                    int i2 = 0;
                    while (i2 < length) {
                        NamespaceNode ns;
                        String name;
                        Node att = atts.item(i2);
                        if (att.getNodeName().startsWith("xmlns") && !nsMap.containsKey(name = (ns = new NamespaceNode((Node)contextNode, att)).getNodeName())) {
                            nsMap.put(name, ns);
                        }
                        ++i2;
                    }
                }
                n2 = n2.getParentNode();
            }
            nsMap.put("xml", new NamespaceNode((Node)contextNode, "xml", "http://www.w3.org/XML/1998/namespace"));
            NamespaceNode defaultNS = (NamespaceNode)nsMap.get("");
            if (defaultNS != null && defaultNS.getNodeValue().equals("")) {
                nsMap.remove("");
            }
            return nsMap.values().iterator();
        }
        return EMPTY_ITERATOR;
    }

    public String getNamespacePrefix(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getLocalName();
        }
        return null;
    }

    public String getNamespaceStringValue(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getNodeValue();
        }
        return null;
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        Node node = (Node)contextNode;
        if (node.getNodeType() == 2) {
            return new NodeIterator(this, node){

                protected Node getFirstNode(Node n2) {
                    return ((Attr)n2).getOwnerElement();
                }

                protected Node getNextNode(Node n2) {
                    return null;
                }
            };
        }
        return new NodeIterator(this, node){

            protected Node getFirstNode(Node n2) {
                return n2.getParentNode();
            }

            protected Node getNextNode(Node n2) {
                return null;
            }
        };
    }

    public Iterator getPrecedingAxisIterator(Object contextNode) {
        return new NodeIterator(this, (Node)contextNode){

            protected Node getFirstNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node sibling = node.getPreviousSibling();
                if (sibling == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return sibling;
            }

            protected Node getNextNode(Node node) {
                if (node == null) {
                    return null;
                }
                Node n2 = node.getLastChild();
                if (n2 == null) {
                    n2 = node.getPreviousSibling();
                }
                if (n2 == null) {
                    return this.getFirstNode(node.getParentNode());
                }
                return n2;
            }
        };
    }

    public Iterator getPrecedingSiblingAxisIterator(Object contextNode) {
        return new NodeIterator(this, (Node)contextNode){

            protected Node getFirstNode(Node node) {
                return this.getNextNode(node);
            }

            protected Node getNextNode(Node node) {
                return node.getPreviousSibling();
            }
        };
    }

    public String getProcessingInstructionData(Object obj) {
        ProcessingInstruction pi = (ProcessingInstruction)obj;
        return pi.getData();
    }

    public String getProcessingInstructionTarget(Object obj) {
        ProcessingInstruction pi = (ProcessingInstruction)obj;
        return pi.getTarget();
    }

    private StringBuffer getStringValue(Node node, StringBuffer buffer) {
        if (this.isText(node)) {
            buffer.append(node.getNodeValue());
        } else {
            NodeList children = node.getChildNodes();
            int length = children.getLength();
            int i2 = 0;
            while (i2 < length) {
                this.getStringValue(children.item(i2), buffer);
                ++i2;
            }
        }
        return buffer;
    }

    public String getTextStringValue(Object object) {
        if (this.isText(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public boolean isAttribute(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 2;
    }

    public boolean isComment(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 8;
    }

    public boolean isDocument(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 9;
    }

    public boolean isElement(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 1;
    }

    public boolean isNamespace(Object object) {
        return object instanceof NamespaceNode;
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 7;
    }

    public boolean isText(Object object) {
        if (object instanceof Node) {
            switch (((Node)object).getNodeType()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new DOMXPath(xpath);
    }

    public String translateNamespacePrefixToUri(String prefix, Object element) {
        Iterator it = this.getNamespaceAxisIterator(element);
        while (it.hasNext()) {
            NamespaceNode ns = (NamespaceNode)it.next();
            if (!prefix.equals(ns.getNodeName())) continue;
            return ns.getNodeValue();
        }
        return null;
    }

    abstract class NodeIterator
    implements Iterator {
        private Node node;

        public NodeIterator(Node contextNode) {
            this.node = this.getFirstNode(contextNode);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
        }

        protected abstract Node getFirstNode(Node var1);

        protected abstract Node getNextNode(Node var1);

        public boolean hasNext() {
            return this.node != null;
        }

        private boolean isXPathNode(Node node) {
            if (node == null) {
                return true;
            }
            switch (node.getNodeType()) {
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    return false;
                }
            }
            return true;
        }

        public Object next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            Node ret = this.node;
            this.node = this.getNextNode(this.node);
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class AttributeIterator
    implements Iterator {
        private Node parent;
        private NamedNodeMap map;
        private int pos;

        AttributeIterator(Node parent) {
            this.parent = parent;
            this.map = parent.getAttributes();
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos < this.map.getLength();
        }

        public Object next() {
            Node attr;
            if ((attr = this.map.item(this.pos++)) == null) {
                throw new NoSuchElementException();
            }
            return attr;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

