/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class NamespaceStack {
    private DocumentFactory documentFactory;
    private ArrayList namespaceStack = new ArrayList();
    private ArrayList namespaceCacheList = new ArrayList();
    private Map currentNamespaceCache;
    private Map rootNamespaceCache = new HashMap();
    private Namespace defaultNamespace;

    public NamespaceStack() {
        this.documentFactory = DocumentFactory.getInstance();
    }

    public NamespaceStack(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public Namespace addNamespace(String prefix, String uri) {
        Namespace namespace = this.createNamespace(prefix, uri);
        this.push(namespace);
        return namespace;
    }

    public void clear() {
        this.namespaceStack.clear();
        this.namespaceCacheList.clear();
        this.rootNamespaceCache.clear();
        this.currentNamespaceCache = null;
    }

    public boolean contains(Namespace namespace) {
        String prefix = namespace.getPrefix();
        Namespace current = null;
        current = prefix == null || prefix.length() == 0 ? this.getDefaultNamespace() : this.getNamespaceForPrefix(prefix);
        if (current == null) {
            return false;
        }
        if (current == namespace) {
            return true;
        }
        return namespace.getURI().equals(current.getURI());
    }

    protected Namespace createNamespace(String prefix, String namespaceURI) {
        return this.documentFactory.createNamespace(prefix, namespaceURI);
    }

    protected QName createQName(String localName, String qualifiedName, Namespace namespace) {
        return this.documentFactory.createQName(localName, namespace);
    }

    protected Namespace findDefaultNamespace() {
        int i2 = this.namespaceStack.size() - 1;
        while (i2 >= 0) {
            String prefix;
            Namespace namespace = (Namespace)this.namespaceStack.get(i2);
            if (namespace != null && ((prefix = namespace.getPrefix()) == null || namespace.getPrefix().length() == 0)) {
                return namespace;
            }
            --i2;
        }
        return null;
    }

    public QName getAttributeQName(String namespaceURI, String localName, String qualifiedName) {
        Map map;
        QName answer;
        if (qualifiedName == null) {
            qualifiedName = localName;
        }
        if ((answer = (QName)(map = this.getNamespaceCache()).get(qualifiedName)) != null) {
            return answer;
        }
        if (localName == null) {
            localName = qualifiedName;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        Namespace namespace = null;
        String prefix = "";
        int index = qualifiedName.indexOf(":");
        if (index > 0) {
            prefix = qualifiedName.substring(0, index);
            namespace = this.createNamespace(prefix, namespaceURI);
            if (localName.trim().length() == 0) {
                localName = qualifiedName.substring(index + 1);
            }
        } else {
            namespace = Namespace.NO_NAMESPACE;
            if (localName.trim().length() == 0) {
                localName = qualifiedName;
            }
        }
        answer = this.pushQName(localName, qualifiedName, namespace, prefix);
        map.put(qualifiedName, answer);
        return answer;
    }

    public Namespace getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = this.findDefaultNamespace();
        }
        return this.defaultNamespace;
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public Namespace getNamespace(int index) {
        return (Namespace)this.namespaceStack.get(index);
    }

    protected Map getNamespaceCache() {
        if (this.currentNamespaceCache == null) {
            int index = this.namespaceStack.size() - 1;
            if (index < 0) {
                this.currentNamespaceCache = this.rootNamespaceCache;
            } else {
                this.currentNamespaceCache = (Map)this.namespaceCacheList.get(index);
                if (this.currentNamespaceCache == null) {
                    this.currentNamespaceCache = new HashMap();
                    this.namespaceCacheList.set(index, this.currentNamespaceCache);
                }
            }
        }
        return this.currentNamespaceCache;
    }

    public Namespace getNamespaceForPrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        int i2 = this.namespaceStack.size() - 1;
        while (i2 >= 0) {
            Namespace namespace = (Namespace)this.namespaceStack.get(i2);
            if (prefix.equals(namespace.getPrefix())) {
                return namespace;
            }
            --i2;
        }
        return null;
    }

    public QName getQName(String namespaceURI, String localName, String qualifiedName) {
        if (localName == null) {
            localName = qualifiedName;
        } else if (qualifiedName == null) {
            qualifiedName = localName;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String prefix = "";
        int index = qualifiedName.indexOf(":");
        if (index > 0) {
            prefix = qualifiedName.substring(0, index);
            if (localName.trim().length() == 0) {
                localName = qualifiedName.substring(index + 1);
            }
        } else if (localName.trim().length() == 0) {
            localName = qualifiedName;
        }
        Namespace namespace = this.createNamespace(prefix, namespaceURI);
        return this.pushQName(localName, qualifiedName, namespace, prefix);
    }

    public String getURI(String prefix) {
        Namespace namespace = this.getNamespaceForPrefix(prefix);
        return namespace != null ? namespace.getURI() : null;
    }

    public Namespace pop() {
        return this.remove(this.namespaceStack.size() - 1);
    }

    public Namespace pop(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Namespace namespace = null;
        int i2 = this.namespaceStack.size() - 1;
        while (i2 >= 0) {
            Namespace ns = (Namespace)this.namespaceStack.get(i2);
            if (prefix.equals(ns.getPrefix())) {
                this.remove(i2);
                namespace = ns;
                break;
            }
            --i2;
        }
        if (namespace == null) {
            System.out.println("Warning: missing namespace prefix ignored: " + prefix);
        }
        return namespace;
    }

    public void push(String prefix, String uri) {
        if (uri == null) {
            uri = "";
        }
        Namespace namespace = this.createNamespace(prefix, uri);
        this.push(namespace);
    }

    public void push(Namespace namespace) {
        this.namespaceStack.add(namespace);
        this.namespaceCacheList.add(null);
        this.currentNamespaceCache = null;
        String prefix = namespace.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.defaultNamespace = namespace;
        }
    }

    protected QName pushQName(String localName, String qualifiedName, Namespace namespace, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.defaultNamespace = null;
        }
        return this.createQName(localName, qualifiedName, namespace);
    }

    protected Namespace remove(int index) {
        Namespace namespace = (Namespace)this.namespaceStack.remove(index);
        this.namespaceCacheList.remove(index);
        this.defaultNamespace = null;
        this.currentNamespaceCache = null;
        return namespace;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public int size() {
        return this.namespaceStack.size();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " Stack: " + this.namespaceStack.toString();
    }
}

