/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import org.dom4j.Node;
import org.dom4j.rule.Rule;

public class RuleSet {
    private ArrayList rules = new ArrayList();
    private Rule[] ruleArray;

    public void addAll(RuleSet that) {
        this.rules.addAll(that.rules);
        this.ruleArray = null;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
        this.ruleArray = null;
    }

    public Rule getMatchingRule(Node node) {
        Rule[] rules = this.getRuleArray();
        int i2 = rules.length - 1;
        while (i2 >= 0) {
            Rule rule = rules[i2];
            if (rule.matches(node)) {
                return rule;
            }
            --i2;
        }
        return null;
    }

    protected Rule[] getRuleArray() {
        if (this.ruleArray == null) {
            Collections.sort(this.rules);
            int size = this.rules.size();
            this.ruleArray = new Rule[size];
            this.rules.toArray(this.ruleArray);
        }
        return this.ruleArray;
    }

    public void removeRule(Rule rule) {
        ((AbstractCollection)this.rules).remove(rule);
        this.ruleArray = null;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [RuleSet: " + this.rules + " ]";
    }
}

