/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Mode;
import org.dom4j.rule.Pattern;
import org.dom4j.rule.Rule;
import org.dom4j.rule.pattern.NodeTypePattern;

public class RuleManager {
    private HashMap modes = new HashMap();
    private int appearenceCount;
    private Action valueOfAction;

    protected void addDefaultRule(Mode mode, Pattern pattern, Action action) {
        Rule rule = this.createDefaultRule(pattern, action);
        mode.addRule(rule);
    }

    protected void addDefaultRules(final Mode mode) {
        Action applyTemplates = new Action(){

            public void run(Node node) throws Exception {
                if (node instanceof Element) {
                    mode.applyTemplates((Element)node);
                } else if (node instanceof Document) {
                    mode.applyTemplates((Document)node);
                }
            }
        };
        Action valueOfAction = this.getValueOfAction();
        this.addDefaultRule(mode, NodeTypePattern.ANY_DOCUMENT, applyTemplates);
        this.addDefaultRule(mode, NodeTypePattern.ANY_ELEMENT, applyTemplates);
        if (valueOfAction != null) {
            this.addDefaultRule(mode, NodeTypePattern.ANY_ATTRIBUTE, valueOfAction);
            this.addDefaultRule(mode, NodeTypePattern.ANY_TEXT, valueOfAction);
        }
    }

    public void addRule(Rule rule) {
        rule.setAppearenceCount(++this.appearenceCount);
        Mode mode = this.getMode(rule.getMode());
        Rule[] childRules = rule.getUnionRules();
        if (childRules != null) {
            int i2 = 0;
            int size = childRules.length;
            while (i2 < size) {
                mode.addRule(childRules[i2]);
                ++i2;
            }
        } else {
            mode.addRule(rule);
        }
    }

    public void clear() {
        this.modes.clear();
        this.appearenceCount = 0;
    }

    protected Rule createDefaultRule(Pattern pattern, Action action) {
        Rule rule = new Rule(pattern, action);
        rule.setImportPrecedence(-1);
        return rule;
    }

    protected Mode createMode() {
        Mode mode = new Mode();
        this.addDefaultRules(mode);
        return mode;
    }

    public Rule getMatchingRule(String modeName, Node node) {
        Mode mode = (Mode)this.modes.get(modeName);
        if (mode != null) {
            return mode.getMatchingRule(node);
        }
        System.out.println("Warning: No Mode for mode: " + mode);
        return null;
    }

    public Mode getMode(String modeName) {
        Mode mode = (Mode)this.modes.get(modeName);
        if (mode == null) {
            mode = this.createMode();
            this.modes.put(modeName, mode);
        }
        return mode;
    }

    public Action getValueOfAction() {
        return this.valueOfAction;
    }

    public void removeRule(Rule rule) {
        Mode mode = this.getMode(rule.getMode());
        Rule[] childRules = rule.getUnionRules();
        if (childRules != null) {
            int i2 = 0;
            int size = childRules.length;
            while (i2 < size) {
                mode.removeRule(childRules[i2]);
                ++i2;
            }
        } else {
            mode.removeRule(rule);
        }
    }

    public void setValueOfAction(Action valueOfAction) {
        this.valueOfAction = valueOfAction;
    }
}

