/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.HashMap;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Rule;
import org.dom4j.rule.RuleSet;

public class Mode {
    private RuleSet[] ruleSets = new RuleSet[14];
    private Map elementNameRuleSets;
    private Map attributeNameRuleSets;

    public void addRule(Rule rule) {
        short matchType = rule.getMatchType();
        String name = rule.getMatchesNodeName();
        if (name != null) {
            if (matchType == 1) {
                this.elementNameRuleSets = this.addToNameMap(this.elementNameRuleSets, name, rule);
            } else if (matchType == 2) {
                this.attributeNameRuleSets = this.addToNameMap(this.attributeNameRuleSets, name, rule);
            }
        }
        if (matchType >= 14) {
            matchType = 0;
        }
        if (matchType == 0) {
            int i2 = 1;
            int size = this.ruleSets.length;
            while (i2 < size) {
                RuleSet ruleSet = this.ruleSets[i2];
                if (ruleSet != null) {
                    ruleSet.addRule(rule);
                }
                ++i2;
            }
        }
        this.getRuleSet(matchType).addRule(rule);
    }

    protected Map addToNameMap(Map map, String name, Rule rule) {
        RuleSet ruleSet;
        if (map == null) {
            map = new HashMap<String, RuleSet>();
        }
        if ((ruleSet = (RuleSet)map.get(name)) == null) {
            ruleSet = new RuleSet();
            map.put(name, ruleSet);
        }
        ruleSet.addRule(rule);
        return map;
    }

    public void applyTemplates(Document document) throws Exception {
        int i2 = 0;
        int size = document.nodeCount();
        while (i2 < size) {
            Node node = document.node(i2);
            this.fireRule(node);
            ++i2;
        }
    }

    public void applyTemplates(Element element) throws Exception {
        int i2 = 0;
        int size = element.attributeCount();
        while (i2 < size) {
            Attribute attribute = element.attribute(i2);
            this.fireRule(attribute);
            ++i2;
        }
        int i3 = 0;
        int size2 = element.nodeCount();
        while (i3 < size2) {
            Node node = element.node(i3);
            this.fireRule(node);
            ++i3;
        }
    }

    public void fireRule(Node node) throws Exception {
        Action action;
        Rule rule;
        if (node != null && (rule = this.getMatchingRule(node)) != null && (action = rule.getAction()) != null) {
            action.run(node);
        }
    }

    public Rule getMatchingRule(Node node) {
        Rule answer;
        String name;
        RuleSet ruleSet;
        short matchType = node.getNodeType();
        if (matchType == 1) {
            Rule answer2;
            if (this.elementNameRuleSets != null && (ruleSet = (RuleSet)this.elementNameRuleSets.get(name = node.getName())) != null && (answer2 = ruleSet.getMatchingRule(node)) != null) {
                return answer2;
            }
        } else if (matchType == 2 && this.attributeNameRuleSets != null && (ruleSet = (RuleSet)this.attributeNameRuleSets.get(name = node.getName())) != null && (answer = ruleSet.getMatchingRule(node)) != null) {
            return answer;
        }
        if (matchType < 0 || matchType >= this.ruleSets.length) {
            matchType = 0;
        }
        Rule answer3 = null;
        ruleSet = this.ruleSets[matchType];
        if (ruleSet != null) {
            answer3 = ruleSet.getMatchingRule(node);
        }
        if (answer3 == null && matchType != 0 && (ruleSet = this.ruleSets[0]) != null) {
            answer3 = ruleSet.getMatchingRule(node);
        }
        return answer3;
    }

    protected RuleSet getRuleSet(int matchType) {
        RuleSet ruleSet = this.ruleSets[matchType];
        if (ruleSet == null) {
            RuleSet allRules;
            this.ruleSets[matchType] = ruleSet = new RuleSet();
            if (matchType != 0 && (allRules = this.ruleSets[0]) != null) {
                ruleSet.addAll(allRules);
            }
        }
        return ruleSet;
    }

    protected void removeFromNameMap(Map map, String name, Rule rule) {
        RuleSet ruleSet;
        if (map != null && (ruleSet = (RuleSet)map.get(name)) != null) {
            ruleSet.removeRule(rule);
        }
    }

    public void removeRule(Rule rule) {
        short matchType = rule.getMatchType();
        String name = rule.getMatchesNodeName();
        if (name != null) {
            if (matchType == 1) {
                this.removeFromNameMap(this.elementNameRuleSets, name, rule);
            } else if (matchType == 2) {
                this.removeFromNameMap(this.attributeNameRuleSets, name, rule);
            }
        }
        if (matchType >= 14) {
            matchType = 0;
        }
        this.getRuleSet(matchType).removeRule(rule);
        if (matchType != 0) {
            this.getRuleSet(0).removeRule(rule);
        }
    }
}

