/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    private static final boolean SUPPORT_PAD_TEXT = false;
    protected static final OutputFormat DEFAULT_FORMAT = new OutputFormat();
    private boolean resolveEntityRefs = true;
    protected int lastOutputNodeType;
    protected Writer writer;
    private NamespaceStack namespaceStack = new NamespaceStack();
    private OutputFormat format;
    private boolean escapeText = true;
    private int indentLevel = 0;
    private StringBuffer buffer = new StringBuffer();
    private boolean autoFlush;
    private LexicalHandler lexicalHandler;
    private boolean showCommentsInDTDs;
    private boolean inDTD;
    private Map namespacesMap;
    private int maximumAllowedCharacter;

    public XMLWriter() {
        this.format = DEFAULT_FORMAT;
        this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream out) throws UnsupportedEncodingException {
        this.format = DEFAULT_FORMAT;
        this.writer = this.createWriter(out, this.format.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
        this.format = format;
        this.writer = this.createWriter(out, format.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(Writer writer) {
        this(writer, DEFAULT_FORMAT);
    }

    public XMLWriter(Writer writer, OutputFormat format) {
        this.writer = writer;
        this.format = format;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputFormat format) throws UnsupportedEncodingException {
        this.format = format;
        this.writer = this.createWriter(System.out, format.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.write(new String(ch, start, length));
            super.characters(ch, start, length);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.showCommentsInDTDs || !this.inDTD) {
            try {
                this.writeComment(new String(ch, start, length));
            }
            catch (IOException e2) {
                this.handleException(e2);
            }
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    protected Writer createWriter(OutputStream outStream, String encoding) throws UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter(outStream, encoding));
    }

    protected int defaultMaximumAllowedCharacter() {
        String encoding = this.format.getEncoding();
        if (encoding != null && encoding.equals("US-ASCII")) {
            return 127;
        }
        return -1;
    }

    public void endCDATA() throws SAXException {
        try {
            this.writer.write("]]>");
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        block2: {
            super.endDocument();
            if (!this.autoFlush) break block2;
            try {
                this.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            boolean hadContent;
            --this.indentLevel;
            if (this.lastOutputNodeType == 1) {
                this.writePrintln();
                this.indent();
            }
            if (hadContent = true) {
                this.writeClose(qName);
            } else {
                this.writeEmptyElementClose(qName);
            }
            this.lastOutputNodeType = 1;
            super.endElement(namespaceURI, localName, qName);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    protected String escapeAttributeEntities(String text) {
        char[] block = null;
        int last = 0;
        int size = text.length();
        int i2 = 0;
        while (i2 < size) {
            String entity = null;
            char c2 = text.charAt(i2);
            switch (c2) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                default: {
                    if (c2 >= ' ' && !this.shouldEncodeChar(c2)) break;
                    entity = "&#" + c2 + ";";
                }
                case '\t': 
                case '\n': 
                case '\r': 
            }
            if (entity != null) {
                if (block == null) {
                    block = text.toCharArray();
                }
                this.buffer.append(block, last, i2 - last);
                this.buffer.append(entity);
                last = i2 + 1;
            }
            ++i2;
        }
        if (last == 0) {
            return text;
        }
        if (last < size) {
            if (block == null) {
                block = text.toCharArray();
            }
            this.buffer.append(block, last, i2 - last);
        }
        String answer = this.buffer.toString();
        this.buffer.setLength(0);
        return answer;
    }

    protected String escapeElementEntities(String text) {
        char[] block = null;
        int last = 0;
        int size = text.length();
        int i2 = 0;
        while (i2 < size) {
            String entity = null;
            char c2 = text.charAt(i2);
            switch (c2) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                default: {
                    if (c2 >= ' ' && !this.shouldEncodeChar(c2)) break;
                    entity = "&#" + c2 + ";";
                }
                case '\t': 
                case '\n': 
                case '\r': 
            }
            if (entity != null) {
                if (block == null) {
                    block = text.toCharArray();
                }
                this.buffer.append(block, last, i2 - last);
                this.buffer.append(entity);
                last = i2 + 1;
            }
            ++i2;
        }
        if (last == 0) {
            return text;
        }
        if (last < size) {
            if (block == null) {
                block = text.toCharArray();
            }
            this.buffer.append(block, last, i2 - last);
        }
        String answer = this.buffer.toString();
        this.buffer.setLength(0);
        return answer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public int getMaximumAllowedCharacter() {
        if (this.maximumAllowedCharacter == 0) {
            this.maximumAllowedCharacter = this.defaultMaximumAllowedCharacter();
        }
        return this.maximumAllowedCharacter;
    }

    protected OutputFormat getOutputFormat() {
        return this.format;
    }

    protected String getPadText() {
        return null;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        int i2 = 0;
        while (i2 < LEXICAL_HANDLER_NAMES.length) {
            if (LEXICAL_HANDLER_NAMES[i2].equals(name)) {
                return this.getLexicalHandler();
            }
            ++i2;
        }
        return super.getProperty(name);
    }

    protected void handleException(IOException e2) throws SAXException {
        throw new SAXException(e2);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    protected void indent() throws IOException {
        String indent = this.format.getIndent();
        if (indent != null && indent.length() > 0) {
            int i2 = 0;
            while (i2 < this.indentLevel) {
                this.writer.write(indent);
                ++i2;
            }
        }
    }

    protected void installLexicalHandler() {
        XMLReader parent = this.getParent();
        if (parent == null) {
            throw new NullPointerException("No parent for filter");
        }
        int i2 = 0;
        while (i2 < LEXICAL_HANDLER_NAMES.length) {
            try {
                parent.setProperty(LEXICAL_HANDLER_NAMES[i2], this);
                break;
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            ++i2;
        }
    }

    public boolean isEscapeText() {
        return this.escapeText;
    }

    protected boolean isExpandEmptyElements() {
        return this.format.isExpandEmptyElements();
    }

    protected boolean isNamespaceDeclaration(Namespace ns) {
        String uri;
        return ns != null && ns != Namespace.XML_NAMESPACE && (uri = ns.getURI()) != null && !this.namespaceStack.contains(ns);
    }

    public void notationDecl(String name, String publicID, String systemID) throws SAXException {
        super.notationDecl(name, publicID, systemID);
    }

    public void parse(InputSource source) throws IOException, SAXException {
        this.installLexicalHandler();
        super.parse(source);
    }

    public void println() throws IOException {
        this.writer.write(this.format.getLineSeparator());
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.indent();
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(" ");
            this.writer.write(data);
            this.writer.write("?>");
            this.writePrintln();
            this.lastOutputNodeType = 7;
            super.processingInstruction(target, data);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public boolean resolveEntityRefs() {
        return this.resolveEntityRefs;
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    public void setEscapeText(boolean escapeText) {
        this.escapeText = escapeText;
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null lexical handler");
        }
        this.lexicalHandler = handler;
    }

    public void setMaximumAllowedCharacter(int maximumAllowedCharacter) {
        this.maximumAllowedCharacter = maximumAllowedCharacter;
    }

    public void setOutputStream(OutputStream out) throws UnsupportedEncodingException {
        this.writer = this.createWriter(out, this.format.getEncoding());
        this.autoFlush = true;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        int i2 = 0;
        while (i2 < LEXICAL_HANDLER_NAMES.length) {
            if (LEXICAL_HANDLER_NAMES[i2].equals(name)) {
                this.setLexicalHandler((LexicalHandler)value);
                return;
            }
            ++i2;
        }
        super.setProperty(name, value);
    }

    public void setResolveEntityRefs(boolean resolve) {
        this.resolveEntityRefs = resolve;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        this.autoFlush = false;
    }

    protected boolean shouldEncodeChar(char c2) {
        int max = this.getMaximumAllowedCharacter();
        return max > 0 && c2 > max;
    }

    public void startCDATA() throws SAXException {
        try {
            this.writer.write("<![CDATA[");
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        this.inDTD = true;
        try {
            this.writeDocType(name, publicID, systemID);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicID, systemID);
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.writeDeclaration();
            super.startDocument();
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.writePrintln();
            this.indent();
            this.writer.write("<");
            this.writer.write(qName);
            this.writeNamespaces();
            this.writeAttributes(attributes);
            this.writer.write(">");
            ++this.indentLevel;
            this.lastOutputNodeType = 1;
            super.startElement(namespaceURI, localName, qName, attributes);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void startEntity(String name) throws SAXException {
        try {
            this.writeEntityRef(name);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.namespacesMap == null) {
            this.namespacesMap = new HashMap();
        }
        this.namespacesMap.put(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) throws SAXException {
        super.unparsedEntityDecl(name, publicID, systemID, notationName);
    }

    public void write(Object object) throws IOException {
        if (object instanceof Node) {
            this.write((Node)object);
        } else if (object instanceof String) {
            this.write((String)object);
        } else if (object instanceof List) {
            List list = (List)object;
            int i2 = 0;
            int size = list.size();
            while (i2 < size) {
                this.write(list.get(i2));
                ++i2;
            }
        } else if (object != null) {
            throw new IOException("Invalid object: " + object);
        }
    }

    public void write(String text) throws IOException {
        this.writeString(text);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Attribute attribute) throws IOException {
        this.writeAttribute(attribute);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(CDATA cdata) throws IOException {
        this.writeCDATA(cdata.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Comment comment) throws IOException {
        this.writeComment(comment.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Document doc) throws IOException {
        this.writeDeclaration();
        if (doc.getDocType() != null) {
            this.indent();
            this.writeDocType(doc.getDocType());
        }
        int i2 = 0;
        int size = doc.nodeCount();
        while (i2 < size) {
            Node node = doc.node(i2);
            this.writeNode(node);
            ++i2;
        }
        this.writePrintln();
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(DocumentType docType) throws IOException {
        this.writeDocType(docType);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Element element) throws IOException {
        this.writeElement(element);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Entity entity) throws IOException {
        this.writeEntity(entity);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Namespace namespace) throws IOException {
        this.writeNamespace(namespace);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Node node) throws IOException {
        this.writeNode(node);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(ProcessingInstruction processingInstruction) throws IOException {
        this.writeProcessingInstruction(processingInstruction);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void write(Text text) throws IOException {
        this.writeString(text.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    protected void writeAttribute(Attribute attribute) throws IOException {
        this.writer.write(" ");
        this.writer.write(attribute.getQualifiedName());
        this.writer.write("=");
        this.writer.write("\"");
        this.writeEscapeAttributeEntities(attribute.getValue());
        this.writer.write("\"");
        this.lastOutputNodeType = 2;
    }

    protected void writeAttribute(Attributes attributes, int index) throws IOException {
        this.writer.write(" ");
        this.writer.write(attributes.getQName(index));
        this.writer.write("=\"");
        this.writeEscapeAttributeEntities(attributes.getValue(index));
        this.writer.write("\"");
    }

    protected void writeAttributes(Element element) throws IOException {
        int i2 = 0;
        int size = element.attributeCount();
        while (i2 < size) {
            Attribute attribute = element.attribute(i2);
            Namespace ns = attribute.getNamespace();
            if (ns != null && ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                String prefix = ns.getPrefix();
                String uri = this.namespaceStack.getURI(prefix);
                if (!ns.getURI().equals(uri)) {
                    this.writeNamespace(ns);
                    this.namespaceStack.push(ns);
                }
            }
            this.writer.write(" ");
            this.writer.write(attribute.getQualifiedName());
            this.writer.write("=\"");
            this.writeEscapeAttributeEntities(attribute.getValue());
            this.writer.write("\"");
            ++i2;
        }
    }

    protected void writeAttributes(Attributes attributes) throws IOException {
        int i2 = 0;
        int size = attributes.getLength();
        while (i2 < size) {
            this.writeAttribute(attributes, i2);
            ++i2;
        }
    }

    protected void writeCDATA(String text) throws IOException {
        this.writer.write("<![CDATA[");
        this.writer.write(text);
        this.writer.write("]]>");
        this.lastOutputNodeType = 4;
    }

    protected void writeClose(String qualifiedName) throws IOException {
        this.writer.write("</");
        this.writer.write(qualifiedName);
        this.writer.write(">");
    }

    public void writeClose(Element element) throws IOException {
        this.writeClose(element.getQualifiedName());
    }

    protected void writeComment(String text) throws IOException {
        if (this.format.isNewlines()) {
            this.println();
            this.indent();
        }
        this.writer.write("<!--");
        this.writer.write(text);
        this.writer.write("-->");
        this.lastOutputNodeType = 8;
    }

    protected void writeDeclaration() throws IOException {
        String encoding = this.format.getEncoding();
        if (!this.format.isSuppressDeclaration()) {
            if (encoding.equals("UTF8")) {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"UTF-8\"");
                }
                this.writer.write("?>");
            } else {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"" + encoding + "\"");
                }
                this.writer.write("?>");
            }
            this.println();
        }
    }

    protected void writeDocType(String name, String publicID, String systemID) throws IOException {
        boolean hasPublic = false;
        this.writer.write("<!DOCTYPE ");
        this.writer.write(name);
        if (publicID != null && !publicID.equals("")) {
            this.writer.write(" PUBLIC \"");
            this.writer.write(publicID);
            this.writer.write("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                this.writer.write(" SYSTEM");
            }
            this.writer.write(" \"");
            this.writer.write(systemID);
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writePrintln();
    }

    protected void writeDocType(DocumentType docType) throws IOException {
        if (docType != null) {
            docType.write(this.writer);
            this.writePrintln();
        }
    }

    protected void writeElement(Element element) throws IOException {
        int size = element.nodeCount();
        String qualifiedName = element.getQualifiedName();
        this.writePrintln();
        this.indent();
        this.writer.write("<");
        this.writer.write(qualifiedName);
        int previouslyDeclaredNamespaces = this.namespaceStack.size();
        Namespace ns = element.getNamespace();
        if (this.isNamespaceDeclaration(ns)) {
            this.namespaceStack.push(ns);
            this.writeNamespace(ns);
        }
        boolean textOnly = true;
        int i2 = 0;
        while (i2 < size) {
            Node node = element.node(i2);
            if (node instanceof Namespace) {
                Namespace additional = (Namespace)node;
                if (this.isNamespaceDeclaration(additional)) {
                    this.namespaceStack.push(additional);
                    this.writeNamespace(additional);
                }
            } else if (node instanceof Element) {
                textOnly = false;
            } else if (node instanceof Comment) {
                textOnly = false;
            }
            ++i2;
        }
        this.writeAttributes(element);
        this.lastOutputNodeType = 1;
        if (size <= 0) {
            this.writeEmptyElementClose(qualifiedName);
        } else {
            this.writer.write(">");
            if (textOnly) {
                this.writeElementContent(element);
            } else {
                ++this.indentLevel;
                this.writeElementContent(element);
                --this.indentLevel;
                this.writePrintln();
                this.indent();
            }
            this.writer.write("</");
            this.writer.write(qualifiedName);
            this.writer.write(">");
        }
        while (this.namespaceStack.size() > previouslyDeclaredNamespaces) {
            this.namespaceStack.pop();
        }
        this.lastOutputNodeType = 1;
    }

    protected void writeElementContent(Element element) throws IOException {
        if (this.format.isTrimText()) {
            Node lastTextNode = null;
            StringBuffer buffer = null;
            int i2 = 0;
            int size = element.nodeCount();
            while (i2 < size) {
                Node node = element.node(i2);
                if (node instanceof Text) {
                    if (lastTextNode == null) {
                        lastTextNode = (Text)node;
                    } else {
                        if (buffer == null) {
                            buffer = new StringBuffer(lastTextNode.getText());
                        }
                        buffer.append(((Text)node).getText());
                    }
                } else {
                    if (lastTextNode != null) {
                        if (buffer != null) {
                            this.writeString(buffer.toString());
                            buffer = null;
                        } else {
                            this.writeString(lastTextNode.getText());
                        }
                        lastTextNode = null;
                    }
                    this.writeNode(node);
                }
                ++i2;
            }
            if (lastTextNode != null) {
                if (buffer != null) {
                    this.writeString(buffer.toString());
                    buffer = null;
                } else {
                    this.writeString(lastTextNode.getText());
                }
                lastTextNode = null;
            }
        } else {
            int i3 = 0;
            int size = element.nodeCount();
            while (i3 < size) {
                Node node = element.node(i3);
                this.writeNode(node);
                ++i3;
            }
        }
    }

    protected void writeEmptyElementClose(String qualifiedName) throws IOException {
        if (!this.format.isExpandEmptyElements()) {
            this.writer.write("/>");
        } else {
            this.writer.write("></");
            this.writer.write(qualifiedName);
            this.writer.write(">");
        }
    }

    protected void writeEntity(Entity entity) throws IOException {
        if (!this.resolveEntityRefs()) {
            this.writeEntityRef(entity.getName());
        } else {
            this.writer.write(entity.getText());
        }
    }

    protected void writeEntityRef(String name) throws IOException {
        this.writer.write("&");
        this.writer.write(name);
        this.writer.write(";");
        this.lastOutputNodeType = 5;
    }

    protected void writeEscapeAttributeEntities(String text) throws IOException {
        if (text != null) {
            String escapedText = this.escapeAttributeEntities(text);
            this.writer.write(escapedText);
        }
    }

    protected void writeNamespace(String prefix, String uri) throws IOException {
        if (prefix != null && prefix.length() > 0) {
            this.writer.write(" xmlns:");
            this.writer.write(prefix);
            this.writer.write("=\"");
        } else {
            this.writer.write(" xmlns=\"");
        }
        this.writer.write(uri);
        this.writer.write("\"");
    }

    protected void writeNamespace(Namespace namespace) throws IOException {
        if (namespace != null) {
            this.writeNamespace(namespace.getPrefix(), namespace.getURI());
        }
    }

    protected void writeNamespaces() throws IOException {
        if (this.namespacesMap != null) {
            Iterator iter = this.namespacesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String prefix = (String)entry.getKey();
                String uri = (String)entry.getValue();
                this.writeNamespace(prefix, uri);
            }
            this.namespacesMap = null;
        }
    }

    protected void writeNode(Node node) throws IOException {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                this.writeElement((Element)node);
                break;
            }
            case 2: {
                this.writeAttribute((Attribute)node);
                break;
            }
            case 3: {
                this.writeString(node.getText());
                break;
            }
            case 4: {
                this.writeCDATA(node.getText());
                break;
            }
            case 5: {
                this.writeEntity((Entity)node);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.writeComment(node.getText());
                break;
            }
            case 9: {
                this.write((Document)node);
                break;
            }
            case 10: {
                this.writeDocType((DocumentType)node);
                break;
            }
            default: {
                throw new IOException("Invalid node type: " + node);
            }
            case 13: 
        }
    }

    public void writeOpen(Element element) throws IOException {
        this.writer.write("<");
        this.writer.write(element.getQualifiedName());
        this.writeAttributes(element);
        this.writer.write(">");
    }

    protected void writePrintln() throws IOException {
        if (this.format.isNewlines()) {
            this.writer.write(this.format.getLineSeparator());
        }
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        this.writer.write("<?");
        this.writer.write(processingInstruction.getName());
        this.writer.write(" ");
        this.writer.write(processingInstruction.getText());
        this.writer.write("?>");
        this.writePrintln();
        this.lastOutputNodeType = 7;
    }

    protected void writeString(String text) throws IOException {
        if (text != null && text.length() > 0) {
            if (this.escapeText) {
                text = this.escapeElementEntities(text);
            }
            if (this.format.isTrimText()) {
                boolean first = true;
                StringTokenizer tokenizer = new StringTokenizer(text);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (first) {
                        first = false;
                        if (this.lastOutputNodeType == 3) {
                            this.writer.write(" ");
                        }
                    } else {
                        this.writer.write(" ");
                    }
                    this.writer.write(token);
                    this.lastOutputNodeType = 3;
                }
            } else {
                this.lastOutputNodeType = 3;
                this.writer.write(text);
            }
        }
    }
}

