/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.io.JAXPHelper;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class SAXHelper {
    private static boolean loggedWarning = true;
    static /* synthetic */ Class class$org$dom4j$io$SAXHelper;

    SAXHelper() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected static boolean classNameAvailable(String className) {
        try {
            Class.forName(className, true, (class$org$dom4j$io$SAXHelper != null ? class$org$dom4j$io$SAXHelper : (class$org$dom4j$io$SAXHelper = SAXHelper.class$("org.dom4j.io.SAXHelper"))).getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static XMLReader createXMLReader(boolean validating) throws SAXException {
        XMLReader reader = null;
        if (SAXHelper.classNameAvailable("javax.xml.parsers.SAXParserFactory")) {
            reader = SAXHelper.createXMLReaderViaJAXP(validating, true);
        }
        if (reader == null) {
            if (reader == null) {
                reader = SAXHelper.createXMLReaderViaJAXP(validating, true);
            }
            if (reader == null) {
                try {
                    reader = XMLReaderFactory.createXMLReader();
                }
                catch (Exception e2) {
                    if (SAXHelper.isVerboseErrorReporting()) {
                        System.out.println("Warning: Caught exception attempting to use SAX to load a SAX XMLReader ");
                        System.out.println("Warning: Exception was: " + e2);
                        System.out.println("Warning: I will print the stack trace then carry on using the default SAX parser");
                        e2.printStackTrace();
                    }
                    System.out.println("Warning: Error occurred using SAX to load a SAXParser. Will use Aelfred instead");
                }
            }
            if (reader == null) {
                throw new SAXException("Could not initialize a SAX Parser. Please add a SAX parser to your classpath along with preferably jaxp.jar");
            }
        }
        return reader;
    }

    protected static XMLReader createXMLReaderViaJAXP(boolean validating, boolean namespaceAware) {
        try {
            return JAXPHelper.createXMLReader(validating, namespaceAware);
        }
        catch (Throwable e2) {
            if (!loggedWarning) {
                loggedWarning = true;
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use JAXP to load a SAX XMLReader ");
                    System.out.println("Warning: Exception was: " + e2);
                    System.out.println("Warning: I will print the stack trace then carry on using the default SAX parser");
                    e2.printStackTrace();
                } else {
                    System.out.println("Warning: Error occurred using JAXP to load a SAXParser. Will use Aelfred instead");
                }
            }
            return null;
        }
    }

    protected static boolean isVerboseErrorReporting() {
        try {
            String flag = System.getProperty("org.dom4j.verbose");
            if (flag != null && flag.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return true;
    }

    public static boolean setParserFeature(XMLReader reader, String featureName, boolean value) {
        try {
            reader.setFeature(featureName, value);
            return true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        return false;
    }

    public static boolean setParserProperty(XMLReader reader, String propertyName, Object value) {
        try {
            reader.setProperty(propertyName, value);
            return true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        return false;
    }
}

