/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

public class OutputFormat
implements Cloneable {
    protected static final String STANDARD_INDENT = "  ";
    private boolean suppressDeclaration = false;
    private String encoding = "UTF-8";
    private boolean omitEncoding = false;
    private String indent = null;
    private boolean expandEmptyElements = false;
    private boolean newlines = false;
    private String lineSeparator = "\n";
    private boolean trimText = false;
    private boolean padText = false;
    private boolean doXHTML = false;
    private int newLineAfterNTags = 0;

    public OutputFormat() {
    }

    public OutputFormat(String indent) {
        this.indent = indent;
    }

    public OutputFormat(String indent, boolean newlines) {
        this.indent = indent;
        this.newlines = newlines;
    }

    public OutputFormat(String indent, boolean newlines, String encoding) {
        this.indent = indent;
        this.newlines = newlines;
        this.encoding = encoding;
    }

    public static OutputFormat createCompactFormat() {
        OutputFormat format = new OutputFormat();
        format.setIndent(false);
        format.setNewlines(false);
        format.setTrimText(true);
        return format;
    }

    public static OutputFormat createPrettyPrint() {
        OutputFormat format = new OutputFormat();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        return format;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getIndent() {
        return this.indent;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public int getNewLineAfterNTags() {
        return this.newLineAfterNTags;
    }

    public boolean isExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public boolean isNewlines() {
        return this.newlines;
    }

    public boolean isOmitEncoding() {
        return this.omitEncoding;
    }

    public boolean isPadText() {
        return this.padText;
    }

    public boolean isSuppressDeclaration() {
        return this.suppressDeclaration;
    }

    public boolean isTrimText() {
        return this.trimText;
    }

    public boolean isXHTML() {
        return this.doXHTML;
    }

    public int parseOptions(String[] args, int i2) {
        int size = args.length;
        while (i2 < size) {
            if (args[i2].equals("-suppressDeclaration")) {
                this.setSuppressDeclaration(true);
            } else if (args[i2].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (args[i2].equals("-indent")) {
                this.setIndent(args[++i2]);
            } else if (args[i2].equals("-indentSize")) {
                this.setIndentSize(Integer.parseInt(args[++i2]));
            } else if (args[i2].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (args[i2].equals("-encoding")) {
                this.setEncoding(args[++i2]);
            } else if (args[i2].equals("-newlines")) {
                this.setNewlines(true);
            } else if (args[i2].equals("-lineSeparator")) {
                this.setLineSeparator(args[++i2]);
            } else if (args[i2].equals("-trimText")) {
                this.setTrimText(true);
            } else if (args[i2].equals("-padText")) {
                this.setPadText(true);
            } else if (args[i2].startsWith("-xhtml")) {
                this.setXHTML(true);
            } else {
                return i2;
            }
            ++i2;
        }
        return i2;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExpandEmptyElements(boolean expandEmptyElements) {
        this.expandEmptyElements = expandEmptyElements;
    }

    public void setIndent(String indent) {
        if (indent != null && indent.length() <= 0) {
            indent = null;
        }
        this.indent = indent;
    }

    public void setIndent(boolean doIndent) {
        this.indent = doIndent ? STANDARD_INDENT : null;
    }

    public void setIndentSize(int indentSize) {
        StringBuffer indentBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < indentSize) {
            indentBuffer.append(" ");
            ++i2;
        }
        this.indent = indentBuffer.toString();
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public void setNewLineAfterNTags(int tagCount) {
        this.newLineAfterNTags = tagCount;
    }

    public void setNewlines(boolean newlines) {
        this.newlines = newlines;
    }

    public void setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
    }

    public void setPadText(boolean padText) {
        this.padText = padText;
    }

    public void setSuppressDeclaration(boolean suppressDeclaration) {
        this.suppressDeclaration = suppressDeclaration;
    }

    public void setTrimText(boolean trimText) {
        this.trimText = trimText;
    }

    public void setXHTML(boolean xhtml) {
        this.doXHTML = xhtml;
    }
}

