/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class HTMLWriter
extends XMLWriter {
    private Stack m_formatStack = new Stack();
    private static String m_lineSeparator = System.getProperty("line.separator");
    private String m_lastText = "";
    private int m_tagsOuput = 0;
    private int m_newLineAfterNTags = -1;
    protected static final HashSet defaultPreformattedTags = new HashSet();
    private HashSet preformattedTags = defaultPreformattedTags;
    protected static final OutputFormat defaultHtmlFormat;
    private HashSet omitElementCloseSet;

    static {
        defaultPreformattedTags.add("PRE");
        defaultPreformattedTags.add("SCRIPT");
        defaultPreformattedTags.add("STYLE");
        defaultPreformattedTags.add("TEXTAREA");
        defaultHtmlFormat = new OutputFormat("  ", true);
        defaultHtmlFormat.setTrimText(true);
        defaultHtmlFormat.setSuppressDeclaration(true);
    }

    public HTMLWriter() throws UnsupportedEncodingException {
        super(defaultHtmlFormat);
    }

    public HTMLWriter(OutputStream out) throws UnsupportedEncodingException {
        super(out, defaultHtmlFormat);
    }

    public HTMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
        super(out, format);
    }

    public HTMLWriter(Writer writer) {
        super(writer, defaultHtmlFormat);
    }

    public HTMLWriter(Writer writer, OutputFormat format) {
        super(writer, format);
    }

    public HTMLWriter(OutputFormat format) throws UnsupportedEncodingException {
        super(format);
    }

    public void endCDATA() throws SAXException {
    }

    public Set getOmitElementCloseSet() {
        return (Set)this.internalGetOmitElementCloseSet().clone();
    }

    protected String getPadText() {
        return " ";
    }

    public Set getPreformattedTags() {
        return (Set)this.preformattedTags.clone();
    }

    private HashSet internalGetOmitElementCloseSet() {
        if (this.omitElementCloseSet == null) {
            this.omitElementCloseSet = new HashSet();
            this.loadOmitElementCloseSet(this.omitElementCloseSet);
        }
        return this.omitElementCloseSet;
    }

    public boolean isPreformattedTag(String qualifiedName) {
        return this.preformattedTags != null && this.preformattedTags.contains(qualifiedName.toUpperCase());
    }

    private String justSpaces(String text) {
        int size = text.length();
        StringBuffer res = new StringBuffer(size);
        int i2 = 0;
        while (i2 < size) {
            char c2 = text.charAt(i2);
            switch (c2) {
                default: {
                    res.append(c2);
                }
                case '\n': 
                case '\r': 
            }
            ++i2;
        }
        return res.toString();
    }

    private void lazyInitNewLinesAfterNTags() {
        this.m_newLineAfterNTags = this.getOutputFormat().isNewlines() ? 0 : this.getOutputFormat().getNewLineAfterNTags();
    }

    protected void loadOmitElementCloseSet(Set set) {
        set.add("AREA");
        set.add("BASE");
        set.add("BR");
        set.add("COL");
        set.add("HR");
        set.add("IMG");
        set.add("INPUT");
        set.add("LINK");
        set.add("META");
        set.add("P");
        set.add("PARAM");
    }

    protected boolean omitElementClose(String qualifiedName) {
        return this.internalGetOmitElementCloseSet().contains(qualifiedName.toUpperCase());
    }

    public static String prettyPrintHTML(String html) throws IOException, UnsupportedEncodingException, DocumentException {
        return HTMLWriter.prettyPrintHTML(html, true, true, false, true);
    }

    public static String prettyPrintHTML(String html, boolean newlines, boolean trim, boolean isXHTML, boolean expandEmpty) throws IOException, UnsupportedEncodingException, DocumentException {
        StringWriter sw = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewlines(newlines);
        format.setTrimText(trim);
        format.setXHTML(isXHTML);
        format.setExpandEmptyElements(expandEmpty);
        HTMLWriter writer = new HTMLWriter(sw, format);
        Document document = DocumentHelper.parseText(html);
        writer.write(document);
        writer.flush();
        return sw.toString();
    }

    public static String prettyPrintXHTML(String html) throws IOException, UnsupportedEncodingException, DocumentException {
        return HTMLWriter.prettyPrintHTML(html, true, true, true, false);
    }

    public void setOmitElementCloseSet(Set newSet) {
        this.omitElementCloseSet = new HashSet();
        if (newSet != null) {
            this.omitElementCloseSet = new HashSet();
            Iterator iter = newSet.iterator();
            while (iter.hasNext()) {
                Object aTag = iter.next();
                if (aTag == null) continue;
                this.omitElementCloseSet.add(aTag.toString().toUpperCase());
            }
        }
    }

    public void setPreformattedTags(Set newSet) {
        this.preformattedTags = new HashSet();
        if (newSet != null) {
            Iterator iter = newSet.iterator();
            while (iter.hasNext()) {
                Object aTag = iter.next();
                if (aTag == null) continue;
                this.preformattedTags.add(aTag.toString().toUpperCase());
            }
        }
    }

    public void startCDATA() throws SAXException {
    }

    protected void writeCDATA(String text) throws IOException {
        if (this.getOutputFormat().isXHTML()) {
            super.writeCDATA(text);
        } else {
            this.writer.write(text);
        }
        this.lastOutputNodeType = 4;
    }

    protected void writeClose(String qualifiedName) throws IOException {
        if (!this.omitElementClose(qualifiedName)) {
            super.writeClose(qualifiedName);
        }
    }

    protected void writeDeclaration() throws IOException {
    }

    protected void writeElement(Element element) throws IOException {
        if (this.m_newLineAfterNTags == -1) {
            this.lazyInitNewLinesAfterNTags();
        }
        if (this.m_newLineAfterNTags > 0 && this.m_tagsOuput > 0 && this.m_tagsOuput % this.m_newLineAfterNTags == 0) {
            this.writer.write(m_lineSeparator);
        }
        ++this.m_tagsOuput;
        String qualifiedName = element.getQualifiedName();
        String saveLastText = this.m_lastText;
        int size = element.nodeCount();
        if (this.isPreformattedTag(qualifiedName)) {
            OutputFormat currentFormat = this.getOutputFormat();
            boolean saveNewlines = currentFormat.isNewlines();
            boolean saveTrimText = currentFormat.isTrimText();
            String currentIndent = currentFormat.getIndent();
            this.m_formatStack.push(new FormatState(saveNewlines, saveTrimText, currentIndent));
            try {
                super.writePrintln();
                if (saveLastText.trim().length() == 0 && currentIndent != null && currentIndent.length() > 0) {
                    this.writer.write(this.justSpaces(saveLastText));
                }
                currentFormat.setNewlines(false);
                currentFormat.setTrimText(false);
                currentFormat.setIndent("");
                super.writeElement(element);
            }
            finally {
                Object var10_9 = null;
                FormatState state = (FormatState)this.m_formatStack.pop();
                currentFormat.setNewlines(state.isNewlines());
                currentFormat.setTrimText(state.isTrimText());
                currentFormat.setIndent(state.getIndent());
            }
        } else {
            super.writeElement(element);
        }
    }

    protected void writeEmptyElementClose(String qualifiedName) throws IOException {
        if (this.getOutputFormat().isXHTML()) {
            if (this.omitElementClose(qualifiedName)) {
                this.writer.write(" />");
            } else {
                super.writeEmptyElementClose(qualifiedName);
            }
        } else if (this.omitElementClose(qualifiedName)) {
            this.writer.write(">");
        } else {
            super.writeEmptyElementClose(qualifiedName);
        }
    }

    protected void writeEntity(Entity entity) throws IOException {
        this.writer.write(entity.getText());
        this.lastOutputNodeType = 5;
    }

    protected void writeString(String text) throws IOException {
        if (text.equals("\n")) {
            if (!this.m_formatStack.empty()) {
                super.writeString(m_lineSeparator);
            }
            return;
        }
        this.m_lastText = text;
        if (this.m_formatStack.empty()) {
            super.writeString(text.trim());
        } else {
            super.writeString(text);
        }
    }

    private class FormatState {
        private boolean m_Newlines = false;
        private boolean m_TrimText = false;
        private String m_indent = "";

        public FormatState(boolean newLines, boolean trimText, String indent) {
            this.m_Newlines = newLines;
            this.m_TrimText = trimText;
            this.m_indent = indent;
        }

        public String getIndent() {
            return this.m_indent;
        }

        public boolean isNewlines() {
            return this.m_Newlines;
        }

        public boolean isTrimText() {
            return this.m_TrimText;
        }
    }
}

