/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.NamespaceStack;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMReader {
    private DocumentFactory factory;
    private NamespaceStack namespaceStack;

    public DOMReader() {
        this.factory = DocumentFactory.getInstance();
        this.namespaceStack = new NamespaceStack(this.factory);
    }

    public DOMReader(DocumentFactory factory) {
        this.factory = factory;
        this.namespaceStack = new NamespaceStack(factory);
    }

    protected void clearNamespaceStack() {
        this.namespaceStack.clear();
        if (!this.namespaceStack.contains(Namespace.XML_NAMESPACE)) {
            this.namespaceStack.push(Namespace.XML_NAMESPACE);
        }
    }

    protected Document createDocument() {
        return this.getDocumentFactory().createDocument();
    }

    public DocumentFactory getDocumentFactory() {
        return this.factory;
    }

    protected Namespace getNamespace(String prefix, String uri) {
        return this.getDocumentFactory().createNamespace(prefix, uri);
    }

    public Document read(org.w3c.dom.Document domDocument) {
        if (domDocument instanceof Document) {
            return (Document)((Object)domDocument);
        }
        Document document = this.createDocument();
        this.clearNamespaceStack();
        NodeList nodeList = domDocument.getChildNodes();
        int i2 = 0;
        int size = nodeList.getLength();
        while (i2 < size) {
            this.readTree(nodeList.item(i2), document);
            ++i2;
        }
        return document;
    }

    protected void readElement(Node node, Branch current) {
        Node attribute;
        int previouslyDeclaredNamespaces = this.namespaceStack.size();
        String namespaceUri = node.getNamespaceURI();
        NamedNodeMap attributeList = node.getAttributes();
        if (namespaceUri == null && (attribute = attributeList.getNamedItem("xmlns")) != null) {
            namespaceUri = attribute.getNodeValue();
        }
        QName qName = this.namespaceStack.getQName(namespaceUri, node.getLocalName(), node.getNodeName());
        Element element = current.addElement(qName);
        if (attributeList != null) {
            int size = attributeList.getLength();
            ArrayList<Node> attributes = new ArrayList<Node>(size);
            int i2 = 0;
            while (i2 < size) {
                Node attribute2 = attributeList.item(i2);
                String name = attribute2.getNodeName();
                if (name.startsWith("xmlns")) {
                    int index = name.indexOf(58, 5);
                    String uri = attribute2.getNodeValue();
                    if (namespaceUri == null || !namespaceUri.equals(uri)) {
                        Namespace namespace = null;
                        if (index > 0) {
                            String prefix = name.substring(index + 1);
                            namespace = this.namespaceStack.addNamespace(prefix, uri);
                        } else {
                            namespace = this.namespaceStack.addNamespace("", uri);
                        }
                        element.add(namespace);
                    }
                } else {
                    attributes.add(attribute2);
                }
                ++i2;
            }
            size = attributes.size();
            int i3 = 0;
            while (i3 < size) {
                Node attribute3 = (Node)attributes.get(i3);
                QName attributeQName = this.namespaceStack.getQName(attribute3.getNamespaceURI(), attribute3.getLocalName(), attribute3.getNodeName());
                element.addAttribute(attributeQName, attribute3.getNodeValue());
                ++i3;
            }
        }
        NodeList children = node.getChildNodes();
        int i4 = 0;
        int size = children.getLength();
        while (i4 < size) {
            Node child = children.item(i4);
            this.readTree(child, element);
            ++i4;
        }
        while (this.namespaceStack.size() > previouslyDeclaredNamespaces) {
            this.namespaceStack.pop();
        }
    }

    protected void readTree(Node node, Branch current) {
        Element element = null;
        Document document = null;
        if (current instanceof Element) {
            element = (Element)current;
        } else {
            document = (Document)current;
        }
        switch (node.getNodeType()) {
            case 1: {
                this.readElement(node, current);
                break;
            }
            case 7: {
                if (current instanceof Element) {
                    ((Element)current).addProcessingInstruction(node.getNodeName(), node.getNodeValue());
                    break;
                }
                ((Document)current).addProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                if (current instanceof Element) {
                    ((Element)current).addComment(node.getNodeValue());
                    break;
                }
                ((Document)current).addComment(node.getNodeValue());
                break;
            }
            case 10: {
                DocumentType domDocType = (DocumentType)node;
                document.addDocType(domDocType.getName(), domDocType.getPublicId(), domDocType.getSystemId());
                break;
            }
            case 3: {
                element.addText(node.getNodeValue());
                break;
            }
            case 4: {
                element.addCDATA(node.getNodeValue());
                break;
            }
            case 5: {
                Node firstChild = node.getFirstChild();
                if (firstChild != null) {
                    element.addEntity(node.getNodeName(), firstChild.getNodeValue());
                    break;
                }
                element.addEntity(node.getNodeName(), "");
                break;
            }
            case 6: {
                element.addEntity(node.getNodeName(), node.getNodeValue());
                break;
            }
            default: {
                System.out.println("WARNING: Unknown DOM node type: " + node.getNodeType());
            }
        }
    }

    public void setDocumentFactory(DocumentFactory factory) {
        this.factory = factory;
        this.namespaceStack.setDocumentFactory(factory);
    }
}

