/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeElementFactory;
import org.dom4j.datatype.InvalidSchemaException;
import org.dom4j.datatype.SchemaParser;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DatatypeDocumentFactory
extends DocumentFactory {
    private static final boolean DO_INTERN_QNAME = false;
    static transient DatatypeDocumentFactory singleton = new DatatypeDocumentFactory();
    private static final Namespace XSI_NAMESPACE = Namespace.get("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final QName XSI_SCHEMA_LOCATION = QName.get("schemaLocation", XSI_NAMESPACE);
    private static final QName XSI_NO_SCHEMA_LOCATION = QName.get("noNamespaceSchemaLocation", XSI_NAMESPACE);
    private SchemaParser schemaBuilder;
    private SAXReader xmlSchemaReader = new SAXReader();
    private boolean autoLoadSchema = true;

    public DatatypeDocumentFactory() {
        this.schemaBuilder = new SchemaParser(this);
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        if (this.autoLoadSchema && qname.equals(XSI_NO_SCHEMA_LOCATION)) {
            Document document = owner != null ? owner.getDocument() : null;
            this.loadSchema(document, value);
        }
        return super.createAttribute(owner, qname, value);
    }

    public DatatypeElementFactory getElementFactory(QName elementQName) {
        DocumentFactory factory = elementQName.getDocumentFactory();
        return factory instanceof DatatypeElementFactory ? (DatatypeElementFactory)factory : null;
    }

    public static DocumentFactory getInstance() {
        return singleton;
    }

    public void loadSchema(Document schemaDocument) {
        this.schemaBuilder.build(schemaDocument);
    }

    protected void loadSchema(Document document, String schemaInstanceURI) {
        try {
            EntityResolver resolver = document.getEntityResolver();
            if (resolver == null) {
                throw new InvalidSchemaException("No EntityResolver available so could not resolve the schema URI: " + schemaInstanceURI);
            }
            InputSource inputSource = resolver.resolveEntity(null, schemaInstanceURI);
            if (resolver == null) {
                throw new InvalidSchemaException("Could not resolve the schema URI: " + schemaInstanceURI);
            }
            Document schemaDocument = this.xmlSchemaReader.read(inputSource);
            this.loadSchema(schemaDocument);
        }
        catch (Exception e2) {
            System.out.println("Failed to load schema: " + schemaInstanceURI);
            System.out.println("Caught: " + e2);
            e2.printStackTrace();
            throw new InvalidSchemaException("Failed to load schema: " + schemaInstanceURI);
        }
    }
}

