/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.AbstractAttribute;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class DatatypeAttribute
extends AbstractAttribute
implements SerializationContext,
ValidationContext {
    private Element parent;
    private QName qname;
    private XSDatatype datatype;
    private Object data;
    private String text;

    public DatatypeAttribute(QName qname, XSDatatype datatype) {
        this.qname = qname;
        this.datatype = datatype;
    }

    public DatatypeAttribute(QName qname, XSDatatype datatype, String text) {
        this.qname = qname;
        this.datatype = datatype;
        this.text = text;
        this.data = this.convertToValue(text);
    }

    protected Object convertToValue(String text) {
        if (this.datatype instanceof DatabindableDatatype) {
            XSDatatype bindable = this.datatype;
            return bindable.createJavaObject(text, (ValidationContext)this);
        }
        return this.datatype.createValue(text, (ValidationContext)this);
    }

    public String getBaseUri() {
        return null;
    }

    public Object getData() {
        return this.data;
    }

    public String getNamespacePrefix(String uri) {
        Namespace namespace;
        Element parent = this.getParent();
        if (parent != null && (namespace = parent.getNamespaceForURI(uri)) != null) {
            return namespace.getPrefix();
        }
        return null;
    }

    public Element getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.qname;
    }

    public String getValue() {
        return this.text;
    }

    public XSDatatype getXSDatatype() {
        return this.datatype;
    }

    public boolean isNotation(String notationName) {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isUnparsedEntity(String entityName) {
        return true;
    }

    public String resolveNamespacePrefix(String prefix) {
        Namespace namespace;
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespaceURI();
        }
        Element parent = this.getParent();
        if (parent != null && (namespace = parent.getNamespaceForPrefix(prefix)) != null) {
            return namespace.getURI();
        }
        return null;
    }

    public void setData(Object data) {
        String s = this.datatype.convertToLexicalValue(data, (SerializationContext)this);
        this.validate(s);
        this.text = s;
        this.data = data;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    public void setValue(String text) {
        this.validate(text);
        this.text = text;
        this.data = this.convertToValue(text);
    }

    public boolean supportsParent() {
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + this.hashCode() + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\" data: " + this.getData() + "]";
    }

    protected void validate(String text) throws IllegalArgumentException {
        try {
            this.datatype.checkValid(text, (ValidationContext)this);
        }
        catch (DatatypeException e2) {
            throw new IllegalArgumentException(e2.getMessage());
        }
    }
}

