/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.util.AbstractList;
import org.dom4j.Attribute;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttribute;
import org.dom4j.bean.BeanElement;
import org.dom4j.bean.BeanMetaData;

public class BeanAttributeList
extends AbstractList {
    private BeanElement parent;
    private BeanMetaData beanMetaData;
    private BeanAttribute[] attributes;

    public BeanAttributeList(BeanElement parent) {
        this.parent = parent;
        Object data = parent.getData();
        Class<?> beanClass = data != null ? data.getClass() : null;
        this.beanMetaData = BeanMetaData.get(beanClass);
        this.attributes = new BeanAttribute[this.beanMetaData.attributeCount()];
    }

    public BeanAttributeList(BeanElement parent, BeanMetaData beanMetaData) {
        this.parent = parent;
        this.beanMetaData = beanMetaData;
        this.attributes = new BeanAttribute[beanMetaData.attributeCount()];
    }

    public void add(int index, Object object) {
        throw new UnsupportedOperationException("add(int, Object) is not supported");
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException("add(int, Object) is not supported");
    }

    public BeanAttribute attribute(int index) {
        if (index >= 0 && index <= this.attributes.length) {
            BeanAttribute attribute = this.attributes[index];
            if (attribute == null) {
                this.attributes[index] = attribute = this.createAttribute(this.parent, index);
            }
            return attribute;
        }
        return null;
    }

    public Attribute attribute(String name) {
        int index = this.beanMetaData.getIndex(name);
        return this.attribute(index);
    }

    public Attribute attribute(QName qname) {
        int index = this.beanMetaData.getIndex(qname);
        return this.attribute(index);
    }

    public void clear() {
        int i2 = 0;
        int size = this.attributes.length;
        while (i2 < size) {
            BeanAttribute attribute = this.attributes[i2];
            if (attribute != null) {
                attribute.setValue(null);
            }
            ++i2;
        }
    }

    protected BeanAttribute createAttribute(BeanElement parent, int index) {
        return new BeanAttribute(this, index);
    }

    public Object get(int index) {
        BeanAttribute attribute = this.attributes[index];
        if (attribute == null) {
            this.attributes[index] = attribute = this.createAttribute(this.parent, index);
        }
        return attribute;
    }

    public Object getData(int index) {
        return this.beanMetaData.getData(index, this.parent.getData());
    }

    public BeanElement getParent() {
        return this.parent;
    }

    public QName getQName(int index) {
        return this.beanMetaData.getQName(index);
    }

    public Object remove(int index) {
        BeanAttribute attribute = (BeanAttribute)this.get(index);
        String oldValue = attribute.getValue();
        attribute.setValue(null);
        return oldValue;
    }

    public boolean remove(Object object) {
        return false;
    }

    public Object set(int index, Object object) {
        throw new UnsupportedOperationException("set(int, Object) is not supported");
    }

    public void setData(int index, Object data) {
        this.beanMetaData.setData(index, this.parent.getData(), data);
    }

    public int size() {
        return this.attributes.length;
    }
}

