/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Map;
import org.apache.velocity.util.introspection.MethodMap;

public class ClassMap {
    private static final CacheMiss CACHE_MISS = new CacheMiss();
    private static final Object OBJECT = new Object();
    private Class clazz;
    private Map methodCache = new Hashtable();
    private MethodMap methodMap = new MethodMap();

    public ClassMap(Class clazz) {
        this.clazz = clazz;
        this.populateMethodCache();
    }

    private ClassMap() {
    }

    Class getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String name, Object[] params) throws MethodMap.AmbiguousException {
        String methodKey = ClassMap.makeMethodKey(name, params);
        Object cacheEntry = this.methodCache.get(methodKey);
        if (cacheEntry == CACHE_MISS) {
            return null;
        }
        if (cacheEntry == null) {
            try {
                cacheEntry = this.methodMap.find(name, params);
            }
            catch (MethodMap.AmbiguousException ae) {
                this.methodCache.put(methodKey, CACHE_MISS);
                throw ae;
            }
            if (cacheEntry == null) {
                this.methodCache.put(methodKey, CACHE_MISS);
            } else {
                this.methodCache.put(methodKey, cacheEntry);
            }
        }
        return (Method)cacheEntry;
    }

    private void populateMethodCache() {
        Method[] methods = ClassMap.getAccessibleMethods(this.clazz);
        int i2 = 0;
        while (i2 < methods.length) {
            Method method = methods[i2];
            Method publicMethod = ClassMap.getPublicMethod(method);
            if (publicMethod != null) {
                this.methodMap.add(publicMethod);
                this.methodCache.put(this.makeMethodKey(publicMethod), publicMethod);
            }
            ++i2;
        }
    }

    private String makeMethodKey(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuffer methodKey = new StringBuffer(method.getName());
        int j2 = 0;
        while (j2 < parameterTypes.length) {
            if (parameterTypes[j2].isPrimitive()) {
                if (parameterTypes[j2].equals(Boolean.TYPE)) {
                    methodKey.append("java.lang.Boolean");
                } else if (parameterTypes[j2].equals(Byte.TYPE)) {
                    methodKey.append("java.lang.Byte");
                } else if (parameterTypes[j2].equals(Character.TYPE)) {
                    methodKey.append("java.lang.Character");
                } else if (parameterTypes[j2].equals(Double.TYPE)) {
                    methodKey.append("java.lang.Double");
                } else if (parameterTypes[j2].equals(Float.TYPE)) {
                    methodKey.append("java.lang.Float");
                } else if (parameterTypes[j2].equals(Integer.TYPE)) {
                    methodKey.append("java.lang.Integer");
                } else if (parameterTypes[j2].equals(Long.TYPE)) {
                    methodKey.append("java.lang.Long");
                } else if (parameterTypes[j2].equals(Short.TYPE)) {
                    methodKey.append("java.lang.Short");
                }
            } else {
                methodKey.append(parameterTypes[j2].getName());
            }
            ++j2;
        }
        return methodKey.toString();
    }

    private static String makeMethodKey(String method, Object[] params) {
        StringBuffer methodKey = new StringBuffer().append(method);
        int j2 = 0;
        while (j2 < params.length) {
            Object arg = params[j2];
            if (arg == null) {
                arg = OBJECT;
            }
            methodKey.append(arg.getClass().getName());
            ++j2;
        }
        return methodKey.toString();
    }

    private static Method[] getAccessibleMethods(Class clazz) {
        Method[] methods = clazz.getMethods();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return methods;
        }
        MethodInfo[] methodInfos = new MethodInfo[methods.length];
        int i2 = methods.length;
        while (i2-- > 0) {
            methodInfos[i2] = new MethodInfo(methods[i2]);
        }
        int upcastCount = ClassMap.getAccessibleMethods(clazz, methodInfos, 0);
        if (upcastCount < methods.length) {
            methods = new Method[upcastCount];
        }
        int j2 = 0;
        int i3 = 0;
        while (i3 < methodInfos.length) {
            MethodInfo methodInfo = methodInfos[i3];
            if (methodInfo.upcast) {
                methods[j2++] = methodInfo.method;
            }
            ++i3;
        }
        return methods;
    }

    private static int getAccessibleMethods(Class clazz, MethodInfo[] methodInfos, int upcastCount) {
        Class superclazz;
        int l2 = methodInfos.length;
        if (Modifier.isPublic(clazz.getModifiers())) {
            int i2 = 0;
            while (i2 < l2 && upcastCount < l2) {
                try {
                    MethodInfo methodInfo = methodInfos[i2];
                    if (!methodInfo.upcast) {
                        methodInfo.tryUpcasting(clazz);
                        ++upcastCount;
                    }
                }
                catch (NoSuchMethodException e2) {
                    // empty catch block
                }
                ++i2;
            }
            if (upcastCount == l2) {
                return upcastCount;
            }
        }
        if ((superclazz = clazz.getSuperclass()) != null && (upcastCount = ClassMap.getAccessibleMethods(superclazz, methodInfos, upcastCount)) == l2) {
            return upcastCount;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i3 = interfaces.length;
        while (i3-- > 0) {
            if ((upcastCount = ClassMap.getAccessibleMethods(interfaces[i3], methodInfos, upcastCount)) != l2) continue;
            return upcastCount;
        }
        return upcastCount;
    }

    public static Method getPublicMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz.getModifiers() & 1) != 0) {
            return method;
        }
        return ClassMap.getPublicMethod(clazz, method.getName(), method.getParameterTypes());
    }

    private static Method getPublicMethod(Class clazz, String name, Class[] paramTypes) {
        Method superclazzMethod;
        if ((clazz.getModifiers() & 1) != 0) {
            try {
                return clazz.getMethod(name, paramTypes);
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
        }
        Class superclazz = clazz.getSuperclass();
        if (superclazz != null && (superclazzMethod = ClassMap.getPublicMethod(superclazz, name, paramTypes)) != null) {
            return superclazzMethod;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            Method interfaceMethod = ClassMap.getPublicMethod(interfaces[i2], name, paramTypes);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            ++i2;
        }
        return null;
    }

    private static final class MethodInfo {
        Method method = null;
        String name;
        Class[] parameterTypes;
        boolean upcast;

        MethodInfo(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.upcast = false;
        }

        void tryUpcasting(Class clazz) throws NoSuchMethodException {
            this.method = clazz.getMethod(this.name, this.parameterTypes);
            this.name = null;
            this.parameterTypes = null;
            this.upcast = true;
        }
    }

    private static final class CacheMiss {
        private CacheMiss() {
        }
    }
}

