/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtils {
    private static final String EOL = System.getProperty("line.separator");
    private static final int EOL_LENGTH = EOL.length();

    public String concat(List list) {
        StringBuffer sb = new StringBuffer();
        int size = list.size();
        int i2 = 0;
        while (i2 < size) {
            sb.append(list.get(i2).toString());
            ++i2;
        }
        return sb.toString();
    }

    public static String getPackageAsPath(String pckge) {
        return pckge.replace('.', File.separator.charAt(0)) + File.separator;
    }

    public static String removeUnderScores(String data) {
        String temp = null;
        StringBuffer out = new StringBuffer();
        temp = data;
        StringTokenizer st = new StringTokenizer(temp, "_");
        while (st.hasMoreTokens()) {
            String element = (String)st.nextElement();
            out.append(StringUtils.firstLetterCaps(element));
        }
        return out.toString();
    }

    public static String removeAndHump(String data) {
        return StringUtils.removeAndHump(data, "_");
    }

    public static String removeAndHump(String data, String replaceThis) {
        String temp = null;
        StringBuffer out = new StringBuffer();
        temp = data;
        StringTokenizer st = new StringTokenizer(temp, replaceThis);
        while (st.hasMoreTokens()) {
            String element = (String)st.nextElement();
            out.append(StringUtils.capitalizeFirstLetter(element));
        }
        return out.toString();
    }

    public static String firstLetterCaps(String data) {
        String firstLetter = data.substring(0, 1).toUpperCase();
        String restLetters = data.substring(1).toLowerCase();
        return firstLetter + restLetters;
    }

    public static String capitalizeFirstLetter(String data) {
        String firstLetter = data.substring(0, 1).toUpperCase();
        String restLetters = data.substring(1);
        return firstLetter + restLetters;
    }

    public static String[] split(String line, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(line, delim);
        while (t.hasMoreTokens()) {
            list.add(t.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String chop(String s, int i2) {
        return StringUtils.chop(s, i2, EOL);
    }

    public static String chop(String s, int i2, String eol) {
        if (i2 == 0 || s == null || eol == null) {
            return s;
        }
        int length = s.length();
        if (eol.length() == 2 && s.endsWith(eol)) {
            length -= 2;
            --i2;
        }
        if (i2 > 0) {
            length -= i2;
        }
        if (length < 0) {
            length = 0;
        }
        return s.substring(0, length);
    }

    public static StringBuffer stringSubstitution(String argStr, Hashtable vars) {
        return StringUtils.stringSubstitution(argStr, (Map)vars);
    }

    public static StringBuffer stringSubstitution(String argStr, Map vars) {
        StringBuffer argBuf = new StringBuffer();
        int cIdx = 0;
        block3: while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            switch (ch) {
                case '$': {
                    String value;
                    StringBuffer nameBuf = new StringBuffer();
                    ++cIdx;
                    while (cIdx < argStr.length()) {
                        ch = argStr.charAt(cIdx);
                        if (ch != '_' && !Character.isLetterOrDigit(ch)) break;
                        nameBuf.append(ch);
                        ++cIdx;
                    }
                    if (nameBuf.length() <= 0 || (value = (String)vars.get(nameBuf.toString())) == null) continue block3;
                    argBuf.append(value);
                    break;
                }
                default: {
                    argBuf.append(ch);
                    ++cIdx;
                }
            }
        }
        return argBuf;
    }

    public static String fileContentsToString(String file) {
        String contents = "";
        File f2 = new File(file);
        if (f2.exists()) {
            try {
                FileReader fr = new FileReader(f2);
                char[] template = new char[(int)f2.length()];
                fr.read(template);
                contents = new String(template);
            }
            catch (Exception e2) {
                System.out.println(e2);
                e2.printStackTrace();
            }
        }
        return contents;
    }

    public static String collapseNewlines(String argStr) {
        char last = argStr.charAt(0);
        StringBuffer argBuf = new StringBuffer();
        int cIdx = 0;
        while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            if (ch != '\n' || last != '\n') {
                argBuf.append(ch);
                last = ch;
            }
            ++cIdx;
        }
        return argBuf.toString();
    }

    public static String collapseSpaces(String argStr) {
        char last = argStr.charAt(0);
        StringBuffer argBuf = new StringBuffer();
        int cIdx = 0;
        while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            if (ch != ' ' || last != ' ') {
                argBuf.append(ch);
                last = ch;
            }
            ++cIdx;
        }
        return argBuf.toString();
    }

    public static final String sub(String line, String oldString, String newString) {
        int i2 = 0;
        if ((i2 = line.indexOf(oldString, i2)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i2).append(newString2);
            int j2 = i2 += oLength;
            while ((i2 = line.indexOf(oldString, i2)) > 0) {
                buf.append(line2, j2, i2 - j2).append(newString2);
                j2 = i2 += oLength;
            }
            buf.append(line2, j2, line2.length - j2);
            return buf.toString();
        }
        return line;
    }

    public static final String stackTrace(Throwable e2) {
        String foo = null;
        try {
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e2.printStackTrace(new PrintWriter(ostr, true));
            foo = ostr.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return foo;
    }

    public static final String normalizePath(String path) {
        int index;
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("%20")) >= 0) {
            normalized = normalized.substring(0, index) + " " + normalized.substring(index + 3);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public String select(boolean state, String trueString, String falseString) {
        if (state) {
            return trueString;
        }
        return falseString;
    }

    public boolean allEmpty(List list) {
        int size = list.size();
        int i2 = 0;
        while (i2 < size) {
            if (list.get(i2) != null && list.get(i2).toString().length() > 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

