/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.exception.ReferenceException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class ASTReference
extends SimpleNode {
    private static final int NORMAL_REFERENCE = 1;
    private static final int FORMAL_REFERENCE = 2;
    private static final int QUIET_REFERENCE = 3;
    private static final int RUNT = 4;
    private int referenceType;
    private String nullString;
    private String rootString;
    private boolean escaped = false;
    private boolean computableReference = true;
    private String escPrefix = "";
    private String morePrefix = "";
    private String identifier = "";
    private String literal = null;
    private int numChildren = 0;

    public ASTReference(int id) {
        super(id);
    }

    public ASTReference(Parser p2, int id) {
        super(p2, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.rootString = this.getRoot();
        this.numChildren = this.jjtGetNumChildren();
        if (this.numChildren > 0) {
            this.identifier = this.jjtGetChild((int)(this.numChildren - 1)).getFirstToken().image;
        }
        return data;
    }

    public String getRootString() {
        return this.rootString;
    }

    public Object execute(Object o2, InternalContextAdapter context) throws MethodInvocationException {
        if (this.referenceType == 4) {
            return null;
        }
        Object result = this.getVariableValue(context, this.rootString);
        if (result == null) {
            return null;
        }
        try {
            int i2 = 0;
            while (i2 < this.numChildren) {
                result = this.jjtGetChild(i2).execute(result, context);
                if (result == null) {
                    return null;
                }
                ++i2;
            }
            return result;
        }
        catch (MethodInvocationException mie) {
            this.rsvc.error("Method " + mie.getMethodName() + " threw exception for reference $" + this.rootString + " in template " + context.getCurrentTemplateName() + " at " + " [" + this.getLine() + "," + this.getColumn() + "]");
            mie.setReferenceName(this.rootString);
            throw mie;
        }
    }

    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException {
        if (this.referenceType == 4) {
            writer.write(this.rootString);
            return true;
        }
        Object value = this.execute(null, context);
        if (this.escaped) {
            if (value == null) {
                writer.write(this.escPrefix);
                writer.write("\\");
                writer.write(this.nullString);
            } else {
                writer.write(this.escPrefix);
                writer.write(this.nullString);
            }
            return true;
        }
        EventCartridge ec = context.getEventCartridge();
        if (ec != null) {
            value = ec.referenceInsert(this.nullString, value);
        }
        if (value == null) {
            writer.write(this.escPrefix);
            writer.write(this.escPrefix);
            writer.write(this.morePrefix);
            writer.write(this.nullString);
            if (this.referenceType != 3 && this.rsvc.getBoolean("runtime.log.invalid.references", true)) {
                this.rsvc.warn(new ReferenceException("reference : template = " + context.getCurrentTemplateName(), this));
            }
            return true;
        }
        writer.write(this.escPrefix);
        writer.write(this.morePrefix);
        writer.write(value.toString());
        return true;
    }

    public boolean evaluate(InternalContextAdapter context) throws MethodInvocationException {
        Object value = this.execute(null, context);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false;
        }
        return true;
    }

    public Object value(InternalContextAdapter context) throws MethodInvocationException {
        return this.computableReference ? this.execute(null, context) : null;
    }

    public boolean setValue(InternalContextAdapter context, Object value) throws MethodInvocationException {
        Object result = this.getVariableValue(context, this.rootString);
        if (result == null) {
            this.rsvc.error(new ReferenceException("reference set : template = " + context.getCurrentTemplateName(), this));
            return false;
        }
        int i2 = 0;
        while (i2 < this.numChildren - 1) {
            result = this.jjtGetChild(i2).execute(result, context);
            if (result == null) {
                this.rsvc.error(new ReferenceException("reference set : template = " + context.getCurrentTemplateName(), this));
                return false;
            }
            ++i2;
        }
        try {
            Method m2;
            block15: {
                Object[] params = new Object[]{value};
                Class<?> c2 = result.getClass();
                m2 = null;
                try {
                    m2 = this.rsvc.getIntrospector().getMethod(c2, "set" + this.identifier, params);
                    if (m2 == null) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException nsme2) {
                    StringBuffer sb = new StringBuffer("set");
                    sb.append(this.identifier);
                    if (Character.isLowerCase(sb.charAt(3))) {
                        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
                    } else {
                        sb.setCharAt(3, Character.toLowerCase(sb.charAt(3)));
                    }
                    m2 = this.rsvc.getIntrospector().getMethod(c2, sb.toString(), params);
                    if (m2 != null) break block15;
                    throw new NoSuchMethodException();
                }
            }
            Object[] args = new Object[]{value};
            m2.invoke(result, args);
        }
        catch (NoSuchMethodException nsme) {
            if (result instanceof Map) {
                try {
                    ((Map)result).put(this.identifier, value);
                }
                catch (Exception ex) {
                    this.rsvc.error("ASTReference Map.put : exception : " + ex + " template = " + context.getCurrentTemplateName() + " [" + this.getLine() + "," + this.getColumn() + "]");
                    return false;
                }
            }
            this.rsvc.error("ASTReference : cannot find " + this.identifier + " as settable property or key to Map in" + " template = " + context.getCurrentTemplateName() + " [" + this.getLine() + "," + this.getColumn() + "]");
            return false;
        }
        catch (InvocationTargetException ite) {
            throw new MethodInvocationException("ASTReference : Invocation of method '" + this.identifier + "' in  " + result.getClass() + " threw exception " + ite.getTargetException().getClass(), ite.getTargetException(), this.identifier);
        }
        catch (Exception e2) {
            this.rsvc.error("ASTReference setValue() : exception : " + e2 + " template = " + context.getCurrentTemplateName() + " [" + this.getLine() + "," + this.getColumn() + "]");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private String getRoot() {
        block12: {
            t = this.getFirstToken();
            slashbang = t.image.indexOf("\\!");
            if (slashbang == -1) break block12;
            i = 0;
            len = t.image.length();
            i = t.image.indexOf(36);
            if (i != -1) ** GOTO lbl13
            this.rsvc.error("ASTReference.getRoot() : internal error : no $ found for slashbang.");
            this.computableReference = false;
            this.nullString = t.image;
            return this.nullString;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl13:
                // 2 sources

                ** while (i < len && t.image.charAt((int)i) != '\\')
            }
lbl14:
            // 1 sources

            start = i;
            count = 0;
            while (i < len && t.image.charAt(i++) == '\\') {
                ++count;
            }
            this.nullString = t.image.substring(0, start);
            this.nullString = this.nullString + t.image.substring(start, start + count - 1);
            this.nullString = this.nullString + t.image.substring(start + count);
            this.computableReference = false;
            return this.nullString;
        }
        this.escaped = false;
        if (t.image.startsWith("\\")) {
            i = 0;
            len = t.image.length();
            while (i < len && t.image.charAt(i) == '\\') {
                ++i;
            }
            if (i % 2 != 0) {
                this.escaped = true;
            }
            if (i > 0) {
                this.escPrefix = t.image.substring(0, i / 2);
            }
            t.image = t.image.substring(i);
        }
        if ((loc1 = t.image.lastIndexOf(36)) > 0) {
            this.morePrefix = this.morePrefix + t.image.substring(0, loc1);
            t.image = t.image.substring(loc1);
        }
        this.nullString = this.literal();
        if (t.image.startsWith("$!")) {
            this.referenceType = 3;
            if (!this.escaped) {
                this.nullString = "";
            }
            if (t.image.startsWith("$!{")) {
                return t.next.image;
            }
            return t.image.substring(2);
        }
        if (t.image.equals("${")) {
            this.referenceType = 2;
            return t.next.image;
        }
        if (t.image.startsWith("$")) {
            this.referenceType = 1;
            return t.image.substring(1);
        }
        this.referenceType = 4;
        return t.image;
    }

    public Object getVariableValue(Context context, String variable) {
        return context.get(variable);
    }

    public void setLiteral(String literal) {
        if (this.literal == null) {
            this.literal = literal;
        }
    }

    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        return super.literal();
    }
}

