/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.NodeUtils;

public class Macro
extends Directive {
    private static boolean debugMode = false;

    public String getName() {
        return "macro";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        return true;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
    }

    public static void processAndRegister(RuntimeServices rs, Node node, String sourceTemplate) throws IOException {
        int numArgs = node.jjtGetNumChildren();
        if (numArgs < 2) {
            rs.error("#macro error : Velocimacro must have name as 1st argument to #macro()");
            return;
        }
        String[] argArray = Macro.getArgArray(node);
        List macroArray = Macro.getASTAsStringArray(node.jjtGetChild(numArgs - 1));
        StringBuffer temp = new StringBuffer();
        int i2 = 0;
        while (i2 < macroArray.size()) {
            temp.append(macroArray.get(i2));
            ++i2;
        }
        String macroBody = temp.toString();
        boolean bRet = rs.addVelocimacro(argArray[0], macroBody, argArray, sourceTemplate);
    }

    private static String[] getArgArray(Node node) {
        int numArgs = node.jjtGetNumChildren();
        String[] argArray = new String[--numArgs];
        int i2 = 0;
        while (i2 < numArgs) {
            argArray[i2] = node.jjtGetChild((int)i2).getFirstToken().image;
            if (i2 > 0 && argArray[i2].startsWith("$")) {
                argArray[i2] = argArray[i2].substring(1, argArray[i2].length());
            }
            ++i2;
        }
        if (debugMode) {
            System.out.println("Macro.getArgArray() : #args = " + numArgs);
            System.out.print(argArray[0] + "(");
            i2 = 1;
            while (i2 < numArgs) {
                System.out.print(" " + argArray[i2]);
                ++i2;
            }
            System.out.println(" )");
        }
        return argArray;
    }

    private static List getASTAsStringArray(Node rootNode) {
        Token t = rootNode.getFirstToken();
        Token tLast = rootNode.getLastToken();
        ArrayList<String> list = new ArrayList<String>();
        t = rootNode.getFirstToken();
        while (t != tLast) {
            list.add(NodeUtils.tokenLiteral(t));
            t = t.next;
        }
        list.add(NodeUtils.tokenLiteral(t));
        return list;
    }
}

