/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;

public class Configuration
extends Hashtable {
    private ExtendedProperties deprecationCrutch = new ExtendedProperties();
    private Configuration defaults;
    protected String file;
    protected String basePath;
    protected String fileSeparator = System.getProperty("file.separator");
    protected boolean isInitialized = false;
    protected static String include = "include";
    protected ArrayList keysAsListed = new ArrayList();

    public Configuration() {
    }

    public Configuration(String file) throws IOException {
        this(file, null);
    }

    public Configuration(String file, String defaultFile) throws IOException {
        this.file = file;
        this.basePath = new File(file).getAbsolutePath();
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
        this.load(new FileInputStream(file));
        if (defaultFile != null) {
            this.defaults = new Configuration(defaultFile);
        }
    }

    private void init(Configuration exp) throws IOException {
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getInclude() {
        return include;
    }

    public void setInclude(String inc) {
        include = inc;
    }

    public synchronized void load(InputStream input) throws IOException {
        PropertiesReader reader = new PropertiesReader(new InputStreamReader(input));
        try {
            while (true) {
                String line;
                int equalSign;
                if ((equalSign = (line = reader.readProperty()).indexOf(61)) <= 0) {
                    continue;
                }
                String key = line.substring(0, equalSign).trim();
                String value = line.substring(equalSign + 1).trim();
                if ("".equals(value)) continue;
                if (this.getInclude() != null && key.equalsIgnoreCase(this.getInclude())) {
                    File file = null;
                    if (value.startsWith(this.fileSeparator)) {
                        file = new File(value);
                    } else {
                        if (value.startsWith("." + this.fileSeparator)) {
                            value = value.substring(2);
                        }
                        file = new File(this.basePath + value);
                    }
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    this.load(new FileInputStream(file));
                    continue;
                }
                this.addProperty(key, value);
            }
        }
        catch (NullPointerException e2) {
            return;
        }
    }

    public Object getProperty(String key) {
        Object o2 = this.get(key);
        if (o2 == null && this.defaults != null) {
            o2 = this.defaults.get(key);
        }
        return o2;
    }

    public void addProperty(String key, Object token) {
        this.deprecationCrutch.addProperty(key, token);
        Object o2 = this.get(key);
        if (o2 instanceof String) {
            Vector<Object> v = new Vector<Object>(2);
            v.addElement(o2);
            v.addElement(token);
            this.put(key, v);
        } else if (o2 instanceof Vector) {
            ((Vector)o2).addElement(token);
        } else if (token instanceof String && ((String)token).indexOf(",") > 0) {
            PropertiesTokenizer tokenizer = new PropertiesTokenizer((String)token);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                this.addStringProperty(key, value);
            }
        } else {
            if (!this.containsKey(key)) {
                this.keysAsListed.add(key);
            }
            this.put(key, token);
        }
    }

    private void addStringProperty(String key, String token) {
        Object o2 = this.get(key);
        if (o2 instanceof String) {
            Vector<Object> v = new Vector<Object>(2);
            v.addElement(o2);
            v.addElement(token);
            this.put(key, v);
        } else if (o2 instanceof Vector) {
            ((Vector)o2).addElement(token);
        } else {
            if (!this.containsKey(key)) {
                this.keysAsListed.add(key);
            }
            this.put(key, token);
        }
    }

    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    public synchronized void save(OutputStream output, String Header2) throws IOException {
        if (output != null) {
            PrintWriter theWrtr = new PrintWriter(output);
            if (Header2 != null) {
                theWrtr.println(Header2);
            }
            Enumeration theKeys = this.keys();
            while (theKeys.hasMoreElements()) {
                String key = (String)theKeys.nextElement();
                Object value = this.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        StringBuffer currentOutput = new StringBuffer();
                        currentOutput.append(key);
                        currentOutput.append("=");
                        currentOutput.append((String)value);
                        theWrtr.println(currentOutput.toString());
                    } else if (value instanceof Vector) {
                        Vector values = (Vector)value;
                        Enumeration valuesEnum = values.elements();
                        while (valuesEnum.hasMoreElements()) {
                            String currentElement = (String)valuesEnum.nextElement();
                            StringBuffer currentOutput = new StringBuffer();
                            currentOutput.append(key);
                            currentOutput.append("=");
                            currentOutput.append(currentElement);
                            theWrtr.println(currentOutput.toString());
                        }
                    }
                }
                theWrtr.println();
                theWrtr.flush();
            }
        }
    }

    public void combine(Configuration c2) {
        Iterator i2 = c2.getKeys();
        while (i2.hasNext()) {
            String key = (String)i2.next();
            this.setProperty(key, c2.get(key));
        }
    }

    public void clearProperty(String key) {
        this.deprecationCrutch.clearProperty(key);
        if (this.containsKey(key)) {
            int i2 = 0;
            while (i2 < this.keysAsListed.size()) {
                if (((String)this.keysAsListed.get(i2)).equals(key)) {
                    this.keysAsListed.remove(i2);
                    break;
                }
                ++i2;
            }
            this.remove(key);
        }
    }

    public Iterator getKeys() {
        return ((AbstractList)this.keysAsListed).iterator();
    }

    public Iterator getKeys(String prefix) {
        Iterator keys = this.getKeys();
        ArrayList matchingKeys = new ArrayList();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            matchingKeys.add(key);
        }
        return ((AbstractList)matchingKeys).iterator();
    }

    public Configuration subset(String prefix) {
        Configuration c2 = new Configuration();
        Iterator keys = this.getKeys();
        boolean validSubset = false;
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            if (!validSubset) {
                validSubset = true;
            }
            String newKey = null;
            newKey = ((String)key).length() == prefix.length() ? prefix : ((String)key).substring(prefix.length() + 1);
            c2.setProperty(newKey, this.get(key));
        }
        if (validSubset) {
            return c2;
        }
        return null;
    }

    public void display() {
        Iterator i2 = this.getKeys();
        while (i2.hasNext()) {
            String key = (String)i2.next();
            Object value = this.get(key);
            System.out.println(key + " => " + value);
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getString(key, defaultValue);
            }
            return defaultValue;
        }
        if (value instanceof Vector) {
            return (String)((Vector)value).get(0);
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a String object");
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, new Properties());
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = new Properties(defaults);
        int i2 = 0;
        while (i2 < tokens.length) {
            String token = tokens[i2];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                throw new IllegalArgumentException('\'' + token + "' does not contain " + "an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            ((Hashtable)props).put(pkey, pvalue);
            ++i2;
        }
        return props;
    }

    public String[] getStringArray(String key) {
        Vector vector;
        Object value = this.get(key);
        if (value instanceof String) {
            vector = new Vector(1);
            vector.addElement(value);
        } else if (value instanceof Vector) {
            vector = (Vector)value;
        } else {
            if (value == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(key);
                }
                return new String[0];
            }
            throw new ClassCastException('\'' + key + "' doesn't map to a String/Vector object");
        }
        String[] tokens = new String[vector.size()];
        int i2 = 0;
        while (i2 < tokens.length) {
            tokens[i2] = (String)vector.elementAt(i2);
            ++i2;
        }
        return tokens;
    }

    public Vector getVector(String key) {
        return this.getVector(key, null);
    }

    public Vector getVector(String key, Vector defaultValue) {
        Object value = this.get(key);
        if (value instanceof Vector) {
            return (Vector)value;
        }
        if (value instanceof String) {
            Vector<String> v = new Vector<String>(1);
            v.addElement((String)value);
            this.put(key, v);
            return v;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(key, defaultValue);
            }
            return defaultValue == null ? new Vector() : defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Vector object");
    }

    public boolean getBoolean(String key) {
        Boolean b2 = this.getBoolean(key, null);
        if (b2 != null) {
            return b2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, new Boolean(defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String s = this.testBoolean((String)value);
            Boolean b2 = new Boolean(s);
            this.put(key, b2);
            return b2;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Boolean object");
    }

    public String testBoolean(String value) {
        String s = value.toLowerCase();
        if (s.equals("true") || s.equals("on") || s.equals("yes")) {
            return "true";
        }
        if (s.equals("false") || s.equals("off") || s.equals("no")) {
            return "false";
        }
        return null;
    }

    public byte getByte(String key) {
        Byte b2 = this.getByte(key, null);
        if (b2 != null) {
            return b2;
        }
        throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.get(key);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            Byte b2 = new Byte((String)value);
            this.put(key, b2);
            return b2;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Byte object");
    }

    public short getShort(String key) {
        Short s = this.getShort(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(String key, Short defaultValue) {
        Object value = this.get(key);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            Short s = new Short((String)value);
            this.put(key, s);
            return s;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Short object");
    }

    public int getInt(String name) {
        return this.getInteger(name);
    }

    public int getInt(String name, int def) {
        return this.getInteger(name, def);
    }

    public int getInteger(String key) {
        Integer i2 = this.getInteger(key, null);
        if (i2 != null) {
            return i2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public int getInteger(String key, int defaultValue) {
        Integer i2 = this.getInteger(key, null);
        if (i2 == null) {
            return defaultValue;
        }
        return i2;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i2 = new Integer((String)value);
            this.put(key, i2);
            return i2;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Integer object");
    }

    public long getLong(String key) {
        Long l2 = this.getLong(key, null);
        if (l2 != null) {
            return l2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object value = this.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            Long l2 = new Long((String)value);
            this.put(key, l2);
            return l2;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Long object");
    }

    public float getFloat(String key) {
        Float f2 = this.getFloat(key, null);
        if (f2 != null) {
            return f2.floatValue();
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value = this.get(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            Float f2 = new Float((String)value);
            this.put(key, f2);
            return f2;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Float object");
    }

    public double getDouble(String key) {
        Double d2 = this.getDouble(key, null);
        if (d2 != null) {
            return d2;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value = this.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            Double d2 = new Double((String)value);
            this.put(key, d2);
            return d2;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Double object");
    }

    public static Configuration convertProperties(Properties p2) {
        Configuration c2 = new Configuration();
        Enumeration e2 = ((Hashtable)p2).keys();
        while (e2.hasMoreElements()) {
            String s = (String)e2.nextElement();
            c2.setProperty(s, p2.getProperty(s));
        }
        return c2;
    }

    public ExtendedProperties getExtendedProperties() {
        return this.deprecationCrutch;
    }

    class PropertiesTokenizer
    extends StringTokenizer {
        static final String DELIMITER = ",";

        public PropertiesTokenizer(String string) {
            super(string, DELIMITER);
        }

        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        public String nextToken() {
            StringBuffer buffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String token = super.nextToken();
                if (token.endsWith("\\")) {
                    buffer.append(token.substring(0, token.length() - 1));
                    buffer.append(DELIMITER);
                    continue;
                }
                buffer.append(token);
                break;
            }
            return buffer.toString().trim();
        }
    }

    class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            StringBuffer buffer = new StringBuffer();
            try {
                String line;
                while (true) {
                    if ((line = this.readLine().trim()).length() == 0 || line.charAt(0) == '#') {
                        continue;
                    }
                    if (!line.endsWith("\\")) break;
                    line = line.substring(0, line.length() - 1);
                    buffer.append(line);
                }
                buffer.append(line);
            }
            catch (NullPointerException e2) {
                return null;
            }
            return buffer.toString();
        }
    }
}

