/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

public class IntList {
    private int[] _array;
    private int _limit;
    private static final int _default_size = 128;

    public IntList() {
        this(128);
    }

    public IntList(IntList list) {
        this(list._array.length);
        System.arraycopy(list._array, 0, this._array, 0, this._array.length);
        this._limit = list._limit;
    }

    public IntList(int initialCapacity) {
        this._array = new int[initialCapacity];
        this._limit = 0;
    }

    public void add(int index, int value) {
        if (index > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this._limit) {
            this.add(value);
        } else {
            if (this._limit == this._array.length) {
                this.growArray(this._limit * 2);
            }
            System.arraycopy(this._array, index, this._array, index + 1, this._limit - index);
            this._array[index] = value;
            ++this._limit;
        }
    }

    public boolean add(int value) {
        if (this._limit == this._array.length) {
            this.growArray(this._limit * 2);
        }
        this._array[this._limit++] = value;
        return true;
    }

    public boolean addAll(IntList c2) {
        if (c2._limit != 0) {
            if (this._limit + c2._limit > this._array.length) {
                this.growArray(this._limit + c2._limit);
            }
            System.arraycopy(c2._array, 0, this._array, this._limit, c2._limit);
            this._limit += c2._limit;
        }
        return true;
    }

    public boolean addAll(int index, IntList c2) {
        if (index > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (c2._limit != 0) {
            if (this._limit + c2._limit > this._array.length) {
                this.growArray(this._limit + c2._limit);
            }
            System.arraycopy(this._array, index, this._array, index + c2._limit, this._limit - index);
            System.arraycopy(c2._array, 0, this._array, index, c2._limit);
            this._limit += c2._limit;
        }
        return true;
    }

    public void clear() {
        this._limit = 0;
    }

    public boolean contains(int o2) {
        boolean rval = false;
        int j2 = 0;
        while (!rval && j2 < this._limit) {
            if (this._array[j2] == o2) {
                rval = true;
            }
            ++j2;
        }
        return rval;
    }

    public boolean containsAll(IntList c2) {
        boolean rval = true;
        if (this != c2) {
            int j2 = 0;
            while (rval && j2 < c2._limit) {
                if (!this.contains(c2._array[j2])) {
                    rval = false;
                }
                ++j2;
            }
        }
        return rval;
    }

    public boolean equals(Object o2) {
        boolean rval;
        boolean bl = rval = this == o2;
        if (!rval && o2 != null && o2.getClass() == this.getClass()) {
            IntList other = (IntList)o2;
            if (other._limit == this._limit) {
                rval = true;
                int j2 = 0;
                while (rval && j2 < this._limit) {
                    rval = this._array[j2] == other._array[j2];
                    ++j2;
                }
            }
        }
        return rval;
    }

    public int get(int index) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        return this._array[index];
    }

    public int hashCode() {
        int hash = 0;
        int j2 = 0;
        while (j2 < this._limit) {
            hash = 31 * hash + this._array[j2];
            ++j2;
        }
        return hash;
    }

    public int indexOf(int o2) {
        int rval = 0;
        while (rval < this._limit) {
            if (o2 == this._array[rval]) break;
            ++rval;
        }
        if (rval == this._limit) {
            rval = -1;
        }
        return rval;
    }

    public boolean isEmpty() {
        return this._limit == 0;
    }

    public int lastIndexOf(int o2) {
        int rval = this._limit - 1;
        while (rval >= 0) {
            if (o2 == this._array[rval]) break;
            --rval;
        }
        return rval;
    }

    public int remove(int index) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        int rval = this._array[index];
        System.arraycopy(this._array, index + 1, this._array, index, this._limit - index);
        --this._limit;
        return rval;
    }

    public boolean removeValue(int o2) {
        boolean rval = false;
        int j2 = 0;
        while (!rval && j2 < this._limit) {
            if (o2 == this._array[j2]) {
                System.arraycopy(this._array, j2 + 1, this._array, j2, this._limit - j2);
                --this._limit;
                rval = true;
            }
            ++j2;
        }
        return rval;
    }

    public boolean removeAll(IntList c2) {
        boolean rval = false;
        int j2 = 0;
        while (j2 < c2._limit) {
            if (this.removeValue(c2._array[j2])) {
                rval = true;
            }
            ++j2;
        }
        return rval;
    }

    public boolean retainAll(IntList c2) {
        boolean rval = false;
        int j2 = 0;
        while (j2 < this._limit) {
            if (!c2.contains(this._array[j2])) {
                this.remove(j2);
                rval = true;
                continue;
            }
            ++j2;
        }
        return rval;
    }

    public int set(int index, int element) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        int rval = this._array[index];
        this._array[index] = element;
        return rval;
    }

    public int size() {
        return this._limit;
    }

    public int[] toArray() {
        int[] rval = new int[this._limit];
        System.arraycopy(this._array, 0, rval, 0, this._limit);
        return rval;
    }

    public int[] toArray(int[] a2) {
        int[] rval;
        if (a2.length == this._limit) {
            System.arraycopy(this._array, 0, a2, 0, this._limit);
            rval = a2;
        } else {
            rval = this.toArray();
        }
        return rval;
    }

    private void growArray(int new_size) {
        int size = new_size == this._array.length ? new_size + 1 : new_size;
        int[] new_array = new int[size];
        System.arraycopy(this._array, 0, new_array, 0, this._limit);
        this._array = new_array;
    }
}

