/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.HeaderBlockWriter;
import org.apache.poi.util.IntList;

public class BlockAllocationTableWriter
implements BlockWritable,
BATManaged {
    private IntList _entries = new IntList();
    private BATBlock[] _blocks = new BATBlock[0];
    private int _start_block = -2;

    public int createBlocks() {
        int xbat_blocks = 0;
        int bat_blocks = 0;
        while (true) {
            int calculated_bat_blocks = BATBlock.calculateStorageRequirements(bat_blocks + xbat_blocks + this._entries.size());
            int calculated_xbat_blocks = HeaderBlockWriter.calculateXBATStorageRequirements(calculated_bat_blocks);
            if (bat_blocks == calculated_bat_blocks && xbat_blocks == calculated_xbat_blocks) break;
            bat_blocks = calculated_bat_blocks;
            xbat_blocks = calculated_xbat_blocks;
        }
        int startBlock = this.allocateSpace(bat_blocks);
        this.allocateSpace(xbat_blocks);
        this.simpleCreateBlocks();
        return startBlock;
    }

    public int allocateSpace(int blockCount) {
        int startBlock = this._entries.size();
        if (blockCount > 0) {
            int limit = blockCount - 1;
            int index = startBlock + 1;
            int k2 = 0;
            while (k2 < limit) {
                this._entries.add(index++);
                ++k2;
            }
            this._entries.add(-2);
        }
        return startBlock;
    }

    public int getStartBlock() {
        return this._start_block;
    }

    void simpleCreateBlocks() {
        this._blocks = BATBlock.createBATBlocks(this._entries.toArray());
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        int j2 = 0;
        while (j2 < this._blocks.length) {
            this._blocks[j2].writeBlocks(stream);
            ++j2;
        }
    }

    public int countBlocks() {
        return this._blocks.length;
    }

    public void setStartBlock(int start_block) {
        this._start_block = start_block;
    }
}

