/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.File;

public class POIFSDocumentPath {
    private String[] components;
    private int hashcode = 0;

    public POIFSDocumentPath(String[] components) throws IllegalArgumentException {
        if (components == null) {
            this.components = new String[0];
        } else {
            this.components = new String[components.length];
            int j2 = 0;
            while (j2 < components.length) {
                if (components[j2] == null || components[j2].length() == 0) {
                    throw new IllegalArgumentException("components cannot contain null or empty strings");
                }
                this.components[j2] = components[j2];
                ++j2;
            }
        }
    }

    public POIFSDocumentPath() {
        this.components = new String[0];
    }

    public POIFSDocumentPath(POIFSDocumentPath path, String[] components) throws IllegalArgumentException {
        this.components = components == null ? new String[path.components.length] : new String[path.components.length + components.length];
        int j2 = 0;
        while (j2 < path.components.length) {
            this.components[j2] = path.components[j2];
            ++j2;
        }
        if (components != null) {
            int j3 = 0;
            while (j3 < components.length) {
                if (components[j3] == null || components[j3].length() == 0) {
                    throw new IllegalArgumentException("components cannot contain null or empty strings");
                }
                this.components[j3 + path.components.length] = components[j3];
                ++j3;
            }
        }
    }

    public boolean equals(Object o2) {
        boolean rval = false;
        if (o2 != null && o2.getClass() == this.getClass()) {
            if (this == o2) {
                rval = true;
            } else {
                POIFSDocumentPath path = (POIFSDocumentPath)o2;
                if (path.components.length == this.components.length) {
                    rval = true;
                    int j2 = 0;
                    while (j2 < this.components.length) {
                        if (!path.components[j2].equals(this.components[j2])) {
                            rval = false;
                            break;
                        }
                        ++j2;
                    }
                }
            }
        }
        return rval;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int j2 = 0;
            while (j2 < this.components.length) {
                this.hashcode += this.components[j2].hashCode();
                ++j2;
            }
        }
        return this.hashcode;
    }

    public int length() {
        return this.components.length;
    }

    public String getComponent(int n2) throws ArrayIndexOutOfBoundsException {
        return this.components[n2];
    }

    public POIFSDocumentPath getParent() {
        int length = this.components.length - 1;
        if (length < 0) {
            return null;
        }
        POIFSDocumentPath parent = new POIFSDocumentPath(null);
        parent.components = new String[length];
        System.arraycopy(this.components, 0, parent.components, 0, length);
        return parent;
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer();
        int l2 = this.length();
        b2.append(File.separatorChar);
        int i2 = 0;
        while (i2 < l2) {
            b2.append(this.getComponent(i2));
            if (i2 < l2 - 1) {
                b2.append(File.separatorChar);
            }
            ++i2;
        }
        return b2.toString();
    }
}

