/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class IntPtg
extends Ptg {
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private short field_1_value;
    private String val;
    private int strlen = 0;

    public IntPtg() {
    }

    public IntPtg(byte[] data, int offset) {
        this.setValue(LittleEndian.getShort(data, offset + 1));
    }

    protected IntPtg(String formula, int offset) {
        this.val = IntPtg.parseString(formula, offset);
        if (this.val == null) {
            throw new RuntimeException("WHOOAA there...thats got no int!");
        }
        this.strlen = this.val.length();
        this.field_1_value = Short.parseShort(this.val);
    }

    public void setValue(short value) {
        this.field_1_value = value;
    }

    public short getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 30;
        LittleEndian.putShort(array, offset + 1, this.getValue());
    }

    public int getSize() {
        return 3;
    }

    public String toFormulaString() {
        return "" + this.getValue();
    }

    private static String parseString(String formula, int pos) {
        String retval = null;
        while (pos < formula.length() && Character.isWhitespace(formula.charAt(pos))) {
            ++pos;
        }
        if (pos < formula.length() && Character.isDigit(formula.charAt(pos))) {
            int numpos = pos;
            while (numpos < formula.length() && Character.isDigit(formula.charAt(numpos))) {
                ++numpos;
            }
            if (numpos == formula.length() || formula.charAt(numpos) != '.') {
                String numberstr = formula.substring(pos, numpos);
                try {
                    short number = Short.parseShort(numberstr);
                    retval = numberstr;
                }
                catch (NumberFormatException e2) {
                    retval = null;
                }
            }
        }
        return retval;
    }

    public static boolean isNextStringToken(String formula, int pos) {
        return IntPtg.parseString(formula, pos) != null;
    }

    public int getPrecedence() {
        return 5;
    }

    public int getStringLength() {
        return this.strlen;
    }
}

