/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.SubtractPtg;

public class FormulaUtil {
    public static Ptg[] parseFormula(String formula) {
        Ptg[] ptg = null;
        StringBuffer f2 = new StringBuffer(formula);
        if (FormulaUtil.isIntAddition(formula)) {
            int loc = FormulaUtil.getLoc(formula, '+');
            System.out.println(formula.substring(0, loc).trim() + "," + formula.substring(loc + 1, formula.length()).trim());
            ptg = FormulaUtil.formulaAddTwoInts(Short.parseShort(formula.substring(0, loc).trim()), Short.parseShort(formula.substring(loc + 1, formula.length()).trim()));
        } else if (FormulaUtil.isIntSubtraction(formula)) {
            int loc = FormulaUtil.getLoc(formula, '-');
            ptg = FormulaUtil.formulaSubtractTwoInts(Short.parseShort(formula.substring(0, loc).trim()), Short.parseShort(formula.substring(loc + 1, formula.length()).trim()));
        } else if (FormulaUtil.isIntMultiplication(formula)) {
            int loc = FormulaUtil.getLoc(formula, '*');
            ptg = FormulaUtil.formulaMultiplyTwoInts(Short.parseShort(formula.substring(0, loc).trim()), Short.parseShort(formula.substring(loc + 1, formula.length()).trim()));
        } else if (FormulaUtil.isIntDivision(formula)) {
            int loc = FormulaUtil.getLoc(formula, '/');
            ptg = FormulaUtil.formulaDivideTwoInts(Short.parseShort(formula.substring(0, loc).trim()), Short.parseShort(formula.substring(loc + 1, formula.length()).trim()));
        } else if (FormulaUtil.isIntPower(formula)) {
            int loc = FormulaUtil.getLoc(formula, '^');
            ptg = FormulaUtil.formulaPowerTwoInts(Short.parseShort(formula.substring(0, loc).trim()), Short.parseShort(formula.substring(loc + 1, formula.length()).trim()));
        }
        return ptg;
    }

    public static Ptg[] formulaAddTwoInts(short first, short second) {
        Ptg[] ptg = new Ptg[]{FormulaUtil.createInteger(first), FormulaUtil.createInteger(second), FormulaUtil.createAdd()};
        return ptg;
    }

    public static Ptg[] formulaSubtractTwoInts(short first, short second) {
        Ptg[] ptg = new Ptg[]{FormulaUtil.createInteger(first), FormulaUtil.createInteger(second), FormulaUtil.createSubtract()};
        return ptg;
    }

    public static Ptg[] formulaMultiplyTwoInts(short first, short second) {
        Ptg[] ptg = new Ptg[]{FormulaUtil.createInteger(first), FormulaUtil.createInteger(second), FormulaUtil.createMultiply()};
        return ptg;
    }

    public static Ptg[] formulaPowerTwoInts(short first, short second) {
        Ptg[] ptg = new Ptg[]{FormulaUtil.createInteger(second), FormulaUtil.createInteger(first), FormulaUtil.createPower()};
        return ptg;
    }

    public static Ptg[] formulaDivideTwoInts(short first, short second) {
        Ptg[] ptg = new Ptg[]{FormulaUtil.createInteger(first), FormulaUtil.createInteger(second), FormulaUtil.createDivide()};
        return ptg;
    }

    public static Ptg createInteger(short value) {
        IntPtg ptg = new IntPtg();
        ptg.setValue(value);
        return ptg;
    }

    public static Ptg createAdd() {
        AddPtg ptg = new AddPtg();
        return ptg;
    }

    public static Ptg createSubtract() {
        SubtractPtg ptg = new SubtractPtg();
        return ptg;
    }

    public static Ptg createMultiply() {
        MultiplyPtg ptg = new MultiplyPtg();
        return ptg;
    }

    public static Ptg createDivide() {
        DividePtg ptg = new DividePtg();
        return ptg;
    }

    public static Ptg createPower() {
        PowerPtg ptg = new PowerPtg();
        return ptg;
    }

    private static boolean isIntAddition(String formula) {
        StringBuffer buffer = new StringBuffer(formula);
        return FormulaUtil.instr(formula, "+");
    }

    private static boolean isIntSubtraction(String formula) {
        StringBuffer buffer = new StringBuffer(formula);
        return FormulaUtil.instr(formula, "-");
    }

    private static boolean isIntMultiplication(String formula) {
        StringBuffer buffer = new StringBuffer(formula);
        return FormulaUtil.instr(formula, "*");
    }

    private static boolean isIntDivision(String formula) {
        StringBuffer buffer = new StringBuffer(formula);
        return FormulaUtil.instr(formula, "/");
    }

    private static boolean isIntPower(String formula) {
        StringBuffer buffer = new StringBuffer(formula);
        return FormulaUtil.instr(formula, "^");
    }

    /*
     * Unable to fully structure code
     */
    private static boolean instr(String matchin, String matchon) {
        lenmatchin = matchin.length();
        lenmatchon = matchon.length();
        pos = 0;
        if (lenmatchon <= lenmatchin) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            sub = matchin.substring(pos, pos + lenmatchon);
            if (sub.equals(matchon)) {
                return true;
            }
            ++pos;
lbl10:
            // 2 sources

            ** while (pos + lenmatchon < lenmatchin)
        }
lbl11:
        // 1 sources

        return false;
    }

    private static int getLoc(String matchin, char matchon) {
        int retval = -1;
        int pos = 0;
        while (pos < matchin.length()) {
            if (matchin.charAt(pos) == matchon) {
                retval = pos;
                break;
            }
            ++pos;
        }
        return retval;
    }
}

