/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class UnicodeString
extends Record
implements Comparable {
    public static final short sid = 4095;
    private short field_1_charCount;
    private byte field_2_optionflags;
    private String field_3_string;
    private final int RICH_TEXT_BIT = 8;
    private final int EXT_BIT = 4;

    public UnicodeString() {
    }

    public int hashCode() {
        int stringHash = 0;
        if (this.field_3_string != null) {
            stringHash = this.field_3_string.hashCode();
        }
        return this.field_1_charCount + stringHash;
    }

    public boolean equals(Object o2) {
        if (o2 == null || o2.getClass() != this.getClass()) {
            return false;
        }
        UnicodeString other = (UnicodeString)o2;
        return this.field_1_charCount == other.field_1_charCount && this.field_2_optionflags == other.field_2_optionflags && this.field_3_string.equals(other.field_3_string);
    }

    public UnicodeString(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public UnicodeString(short id, short size, byte[] data, String prefix) {
        this(id, size, data);
        this.field_3_string = prefix + this.field_3_string;
        this.setCharCount();
    }

    protected void validateSid(short id) {
    }

    protected void fillFields(byte[] data, short size) {
        this.field_1_charCount = LittleEndian.getShort(data, 0);
        this.field_2_optionflags = data[2];
        if ((this.field_2_optionflags & 1) == 0) {
            this.field_3_string = new String(data, 3, (int)this.getCharCount());
        } else {
            char[] array = new char[this.getCharCount()];
            int j2 = 0;
            while (j2 < array.length) {
                array[j2] = (char)LittleEndian.getShort(data, 3 + j2 * 2);
                ++j2;
            }
            this.field_3_string = new String(array);
        }
    }

    public short getCharCount() {
        return this.field_1_charCount;
    }

    public void setCharCount(short cc) {
        this.field_1_charCount = cc;
    }

    public void setCharCount() {
        this.field_1_charCount = (short)this.field_3_string.length();
    }

    public byte getOptionFlags() {
        return this.field_2_optionflags;
    }

    public void setOptionFlags(byte of) {
        this.field_2_optionflags = of;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setString(String string) {
        this.field_3_string = string;
        if (this.getCharCount() < this.field_3_string.length()) {
            this.setCharCount();
        }
    }

    public String toString() {
        return this.getString();
    }

    public String getDebugInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNICODESTRING]\n");
        buffer.append("    .charcount       = ").append(Integer.toHexString(this.getCharCount())).append("\n");
        buffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("    .string          = ").append(this.getString()).append("\n");
        buffer.append("[/UNICODESTRING]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, this.getCharCount());
        data[2 + offset] = this.getOptionFlags();
        if (!this.isUncompressedUnicode()) {
            StringUtil.putCompressedUnicode(this.getString(), data, 3 + offset);
        } else {
            StringUtil.putUncompressedUnicode(this.getString(), data, 3 + offset);
        }
        return this.getRecordSize();
    }

    private boolean isUncompressedUnicode() {
        return (this.getOptionFlags() & 1) == 1;
    }

    public int getRecordSize() {
        int charsize = this.isUncompressedUnicode() ? 2 : 1;
        return 3 + this.getString().length() * charsize;
    }

    public short getSid() {
        return 4095;
    }

    protected void fillFields(byte[] data, short size, int offset) {
    }

    public int compareTo(Object obj) {
        UnicodeString str = (UnicodeString)obj;
        return this.getString().compareTo(str.getString());
    }

    public boolean isRichText() {
        return (this.getOptionFlags() & 8) != 0;
    }

    int maxBrokenLength(int proposedBrokenLength) {
        int rval = proposedBrokenLength;
        if (this.isUncompressedUnicode()) {
            int proposedStringLength = proposedBrokenLength - 3;
            if (proposedStringLength % 2 == 1) {
                --proposedStringLength;
            }
            rval = proposedStringLength + 3;
        }
        return rval;
    }

    public boolean isExtendedText() {
        return (this.getOptionFlags() & 4) != 0;
    }
}

