/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.RecordProcessor;
import org.apache.poi.hssf.record.SSTRecordHeader;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.BinaryTree;

class SSTSerializer {
    private List recordLengths;
    private BinaryTree strings;
    private int numStrings;
    private int numUniqueStrings;
    private SSTRecordHeader sstRecordHeader;

    public SSTSerializer(List recordLengths, BinaryTree strings, int numStrings, int numUniqueStrings) {
        this.recordLengths = recordLengths;
        this.strings = strings;
        this.numStrings = numStrings;
        this.numUniqueStrings = numUniqueStrings;
        this.sstRecordHeader = new SSTRecordHeader(numStrings, numUniqueStrings);
    }

    public int serialize(int offset, byte[] data) {
        int record_size = this.getRecordSize();
        int record_length_index = 0;
        if (this.calculateUnicodeSize() > 8216) {
            this.serializeLargeRecord(record_size, record_length_index, data, offset);
        } else {
            this.serializeSingleSSTRecord(data, offset, record_length_index);
        }
        return record_size;
    }

    private int calculateUnicodeSize() {
        int retval = 0;
        int k2 = 0;
        while (k2 < this.strings.size()) {
            retval += this.getUnicodeString(k2).getRecordSize();
            ++k2;
        }
        return retval;
    }

    public int getRecordSize() {
        this.recordLengths = new ArrayList();
        int retval = 0;
        int unicodesize = this.calculateUnicodeSize();
        if (unicodesize > 8216) {
            retval = this.calcRecordSizesForLongStrings(unicodesize);
        } else {
            retval = 12 + unicodesize;
            this.recordLengths.add(new Integer(unicodesize));
        }
        return retval;
    }

    private int calcRecordSizesForLongStrings(int unicodesize) {
        UnicodeString unistr = null;
        int stringreminant = 0;
        int unipos = 0;
        boolean lastneedcontinue = false;
        int stringbyteswritten = 0;
        boolean finished = false;
        boolean first_record = true;
        int totalWritten = 0;
        while (!finished) {
            int shortrecord;
            int available;
            int record = 0;
            int pos = 0;
            if (first_record) {
                record = 8228;
                pos = 12;
                first_record = false;
                this.recordLengths.add(new Integer(record - 4));
            } else {
                pos = 0;
                int to_be_written = unicodesize - stringbyteswritten + (lastneedcontinue ? 1 : 0);
                int size = Math.min(8224, to_be_written);
                if (size == to_be_written) {
                    finished = true;
                }
                record = size + 4;
                this.recordLengths.add(new Integer(size));
                pos = 4;
            }
            if (lastneedcontinue) {
                available = 8228 - pos;
                if (stringreminant <= available) {
                    stringbyteswritten += stringreminant - 1;
                    pos += stringreminant;
                    lastneedcontinue = false;
                } else {
                    int toBeWritten = unistr.maxBrokenLength(available);
                    if (available != toBeWritten) {
                        shortrecord = record - (available - toBeWritten);
                        this.recordLengths.set(this.recordLengths.size() - 1, new Integer(shortrecord - 4));
                        record = shortrecord;
                    }
                    stringbyteswritten += toBeWritten - 1;
                    pos += toBeWritten;
                    stringreminant -= toBeWritten - 1;
                    lastneedcontinue = true;
                }
            }
            while (unipos < this.strings.size()) {
                available = 8228 - pos;
                Integer intunipos = new Integer(unipos);
                unistr = (UnicodeString)this.strings.get(intunipos);
                if (unistr.getRecordSize() <= available) {
                    stringbyteswritten += unistr.getRecordSize();
                    pos += unistr.getRecordSize();
                } else {
                    if (available >= 3) {
                        int toBeWritten = unistr.maxBrokenLength(available);
                        stringbyteswritten += toBeWritten;
                        stringreminant = unistr.getRecordSize() - toBeWritten + 1;
                        if (available != toBeWritten) {
                            int shortrecord2 = record - (available - toBeWritten);
                            this.recordLengths.set(this.recordLengths.size() - 1, new Integer(shortrecord2 - 4));
                            record = shortrecord2;
                        }
                        lastneedcontinue = true;
                        ++unipos;
                        break;
                    }
                    shortrecord = record - available;
                    this.recordLengths.set(this.recordLengths.size() - 1, new Integer(shortrecord - 4));
                    record = shortrecord;
                    break;
                }
                ++unipos;
            }
            totalWritten += record;
        }
        int retval = totalWritten;
        return retval;
    }

    private void serializeSingleSSTRecord(byte[] data, int offset, int record_length_index) {
        int len = (Integer)this.recordLengths.get(record_length_index++);
        int recordSize = 12 + len - 4;
        this.sstRecordHeader.writeSSTHeader(data, 0 + offset, recordSize);
        int pos = 12;
        int k2 = 0;
        while (k2 < this.strings.size()) {
            System.arraycopy(this.getUnicodeString(k2).serialize(), 0, data, pos + offset, this.getUnicodeString(k2).getRecordSize());
            pos += this.getUnicodeString(k2).getRecordSize();
            ++k2;
        }
    }

    private void serializeLargeRecord(int record_size, int record_length_index, byte[] buffer, int offset) {
        byte[] stringReminant = null;
        int stringIndex = 0;
        boolean lastneedcontinue = false;
        boolean first_record = true;
        int totalWritten = 0;
        while (totalWritten != record_size) {
            int recordLength = (Integer)this.recordLengths.get(record_length_index++);
            RecordProcessor recordProcessor = new RecordProcessor(buffer, recordLength, this.numStrings, this.numUniqueStrings);
            recordProcessor.writeRecordHeader(offset, totalWritten, recordLength, first_record);
            first_record = false;
            if (lastneedcontinue) {
                lastneedcontinue = stringReminant.length > recordProcessor.getAvailable();
                stringReminant = recordProcessor.writeStringRemainder(lastneedcontinue, stringReminant, offset, totalWritten);
            }
            while (stringIndex < this.strings.size()) {
                UnicodeString unistr = this.getUnicodeString(stringIndex);
                if (unistr.getRecordSize() > recordProcessor.getAvailable()) {
                    if (recordProcessor.getAvailable() < 3) break;
                    stringReminant = recordProcessor.writePartString(unistr, offset, totalWritten);
                    lastneedcontinue = true;
                    ++stringIndex;
                    break;
                }
                recordProcessor.writeWholeString(unistr, offset, totalWritten);
                ++stringIndex;
            }
            totalWritten += recordLength + 4;
        }
    }

    private UnicodeString getUnicodeString(int index) {
        Integer intunipos = new Integer(index);
        return (UnicodeString)this.strings.get(intunipos);
    }
}

