/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.util.LittleEndian;

public class RecordFactory {
    private static int NUM_RECORDS = 10000;
    private static final Class[] records = new Class[]{class$org$apache$poi$hssf$record$BOFRecord == null ? (class$org$apache$poi$hssf$record$BOFRecord = RecordFactory.class$("org.apache.poi.hssf.record.BOFRecord")) : class$org$apache$poi$hssf$record$BOFRecord, class$org$apache$poi$hssf$record$InterfaceHdrRecord == null ? (class$org$apache$poi$hssf$record$InterfaceHdrRecord = RecordFactory.class$("org.apache.poi.hssf.record.InterfaceHdrRecord")) : class$org$apache$poi$hssf$record$InterfaceHdrRecord, class$org$apache$poi$hssf$record$MMSRecord == null ? (class$org$apache$poi$hssf$record$MMSRecord = RecordFactory.class$("org.apache.poi.hssf.record.MMSRecord")) : class$org$apache$poi$hssf$record$MMSRecord, class$org$apache$poi$hssf$record$InterfaceEndRecord == null ? (class$org$apache$poi$hssf$record$InterfaceEndRecord = RecordFactory.class$("org.apache.poi.hssf.record.InterfaceEndRecord")) : class$org$apache$poi$hssf$record$InterfaceEndRecord, class$org$apache$poi$hssf$record$WriteAccessRecord == null ? (class$org$apache$poi$hssf$record$WriteAccessRecord = RecordFactory.class$("org.apache.poi.hssf.record.WriteAccessRecord")) : class$org$apache$poi$hssf$record$WriteAccessRecord, class$org$apache$poi$hssf$record$CodepageRecord == null ? (class$org$apache$poi$hssf$record$CodepageRecord = RecordFactory.class$("org.apache.poi.hssf.record.CodepageRecord")) : class$org$apache$poi$hssf$record$CodepageRecord, class$org$apache$poi$hssf$record$DSFRecord == null ? (class$org$apache$poi$hssf$record$DSFRecord = RecordFactory.class$("org.apache.poi.hssf.record.DSFRecord")) : class$org$apache$poi$hssf$record$DSFRecord, class$org$apache$poi$hssf$record$TabIdRecord == null ? (class$org$apache$poi$hssf$record$TabIdRecord = RecordFactory.class$("org.apache.poi.hssf.record.TabIdRecord")) : class$org$apache$poi$hssf$record$TabIdRecord, class$org$apache$poi$hssf$record$FnGroupCountRecord == null ? (class$org$apache$poi$hssf$record$FnGroupCountRecord = RecordFactory.class$("org.apache.poi.hssf.record.FnGroupCountRecord")) : class$org$apache$poi$hssf$record$FnGroupCountRecord, class$org$apache$poi$hssf$record$WindowProtectRecord == null ? (class$org$apache$poi$hssf$record$WindowProtectRecord = RecordFactory.class$("org.apache.poi.hssf.record.WindowProtectRecord")) : class$org$apache$poi$hssf$record$WindowProtectRecord, class$org$apache$poi$hssf$record$ProtectRecord == null ? (class$org$apache$poi$hssf$record$ProtectRecord = RecordFactory.class$("org.apache.poi.hssf.record.ProtectRecord")) : class$org$apache$poi$hssf$record$ProtectRecord, class$org$apache$poi$hssf$record$PasswordRecord == null ? (class$org$apache$poi$hssf$record$PasswordRecord = RecordFactory.class$("org.apache.poi.hssf.record.PasswordRecord")) : class$org$apache$poi$hssf$record$PasswordRecord, class$org$apache$poi$hssf$record$ProtectionRev4Record == null ? (class$org$apache$poi$hssf$record$ProtectionRev4Record = RecordFactory.class$("org.apache.poi.hssf.record.ProtectionRev4Record")) : class$org$apache$poi$hssf$record$ProtectionRev4Record, class$org$apache$poi$hssf$record$PasswordRev4Record == null ? (class$org$apache$poi$hssf$record$PasswordRev4Record = RecordFactory.class$("org.apache.poi.hssf.record.PasswordRev4Record")) : class$org$apache$poi$hssf$record$PasswordRev4Record, class$org$apache$poi$hssf$record$WindowOneRecord == null ? (class$org$apache$poi$hssf$record$WindowOneRecord = RecordFactory.class$("org.apache.poi.hssf.record.WindowOneRecord")) : class$org$apache$poi$hssf$record$WindowOneRecord, class$org$apache$poi$hssf$record$BackupRecord == null ? (class$org$apache$poi$hssf$record$BackupRecord = RecordFactory.class$("org.apache.poi.hssf.record.BackupRecord")) : class$org$apache$poi$hssf$record$BackupRecord, class$org$apache$poi$hssf$record$HideObjRecord == null ? (class$org$apache$poi$hssf$record$HideObjRecord = RecordFactory.class$("org.apache.poi.hssf.record.HideObjRecord")) : class$org$apache$poi$hssf$record$HideObjRecord, class$org$apache$poi$hssf$record$DateWindow1904Record == null ? (class$org$apache$poi$hssf$record$DateWindow1904Record = RecordFactory.class$("org.apache.poi.hssf.record.DateWindow1904Record")) : class$org$apache$poi$hssf$record$DateWindow1904Record, class$org$apache$poi$hssf$record$PrecisionRecord == null ? (class$org$apache$poi$hssf$record$PrecisionRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrecisionRecord")) : class$org$apache$poi$hssf$record$PrecisionRecord, class$org$apache$poi$hssf$record$RefreshAllRecord == null ? (class$org$apache$poi$hssf$record$RefreshAllRecord = RecordFactory.class$("org.apache.poi.hssf.record.RefreshAllRecord")) : class$org$apache$poi$hssf$record$RefreshAllRecord, class$org$apache$poi$hssf$record$BookBoolRecord == null ? (class$org$apache$poi$hssf$record$BookBoolRecord = RecordFactory.class$("org.apache.poi.hssf.record.BookBoolRecord")) : class$org$apache$poi$hssf$record$BookBoolRecord, class$org$apache$poi$hssf$record$FontRecord == null ? (class$org$apache$poi$hssf$record$FontRecord = RecordFactory.class$("org.apache.poi.hssf.record.FontRecord")) : class$org$apache$poi$hssf$record$FontRecord, class$org$apache$poi$hssf$record$FormatRecord == null ? (class$org$apache$poi$hssf$record$FormatRecord = RecordFactory.class$("org.apache.poi.hssf.record.FormatRecord")) : class$org$apache$poi$hssf$record$FormatRecord, class$org$apache$poi$hssf$record$ExtendedFormatRecord == null ? (class$org$apache$poi$hssf$record$ExtendedFormatRecord = RecordFactory.class$("org.apache.poi.hssf.record.ExtendedFormatRecord")) : class$org$apache$poi$hssf$record$ExtendedFormatRecord, class$org$apache$poi$hssf$record$StyleRecord == null ? (class$org$apache$poi$hssf$record$StyleRecord = RecordFactory.class$("org.apache.poi.hssf.record.StyleRecord")) : class$org$apache$poi$hssf$record$StyleRecord, class$org$apache$poi$hssf$record$UseSelFSRecord == null ? (class$org$apache$poi$hssf$record$UseSelFSRecord = RecordFactory.class$("org.apache.poi.hssf.record.UseSelFSRecord")) : class$org$apache$poi$hssf$record$UseSelFSRecord, class$org$apache$poi$hssf$record$BoundSheetRecord == null ? (class$org$apache$poi$hssf$record$BoundSheetRecord = RecordFactory.class$("org.apache.poi.hssf.record.BoundSheetRecord")) : class$org$apache$poi$hssf$record$BoundSheetRecord, class$org$apache$poi$hssf$record$CountryRecord == null ? (class$org$apache$poi$hssf$record$CountryRecord = RecordFactory.class$("org.apache.poi.hssf.record.CountryRecord")) : class$org$apache$poi$hssf$record$CountryRecord, class$org$apache$poi$hssf$record$SSTRecord == null ? (class$org$apache$poi$hssf$record$SSTRecord = RecordFactory.class$("org.apache.poi.hssf.record.SSTRecord")) : class$org$apache$poi$hssf$record$SSTRecord, class$org$apache$poi$hssf$record$ExtSSTRecord == null ? (class$org$apache$poi$hssf$record$ExtSSTRecord = RecordFactory.class$("org.apache.poi.hssf.record.ExtSSTRecord")) : class$org$apache$poi$hssf$record$ExtSSTRecord, class$org$apache$poi$hssf$record$EOFRecord == null ? (class$org$apache$poi$hssf$record$EOFRecord = RecordFactory.class$("org.apache.poi.hssf.record.EOFRecord")) : class$org$apache$poi$hssf$record$EOFRecord, class$org$apache$poi$hssf$record$IndexRecord == null ? (class$org$apache$poi$hssf$record$IndexRecord = RecordFactory.class$("org.apache.poi.hssf.record.IndexRecord")) : class$org$apache$poi$hssf$record$IndexRecord, class$org$apache$poi$hssf$record$CalcModeRecord == null ? (class$org$apache$poi$hssf$record$CalcModeRecord = RecordFactory.class$("org.apache.poi.hssf.record.CalcModeRecord")) : class$org$apache$poi$hssf$record$CalcModeRecord, class$org$apache$poi$hssf$record$CalcCountRecord == null ? (class$org$apache$poi$hssf$record$CalcCountRecord = RecordFactory.class$("org.apache.poi.hssf.record.CalcCountRecord")) : class$org$apache$poi$hssf$record$CalcCountRecord, class$org$apache$poi$hssf$record$RefModeRecord == null ? (class$org$apache$poi$hssf$record$RefModeRecord = RecordFactory.class$("org.apache.poi.hssf.record.RefModeRecord")) : class$org$apache$poi$hssf$record$RefModeRecord, class$org$apache$poi$hssf$record$IterationRecord == null ? (class$org$apache$poi$hssf$record$IterationRecord = RecordFactory.class$("org.apache.poi.hssf.record.IterationRecord")) : class$org$apache$poi$hssf$record$IterationRecord, class$org$apache$poi$hssf$record$DeltaRecord == null ? (class$org$apache$poi$hssf$record$DeltaRecord = RecordFactory.class$("org.apache.poi.hssf.record.DeltaRecord")) : class$org$apache$poi$hssf$record$DeltaRecord, class$org$apache$poi$hssf$record$SaveRecalcRecord == null ? (class$org$apache$poi$hssf$record$SaveRecalcRecord = RecordFactory.class$("org.apache.poi.hssf.record.SaveRecalcRecord")) : class$org$apache$poi$hssf$record$SaveRecalcRecord, class$org$apache$poi$hssf$record$PrintHeadersRecord == null ? (class$org$apache$poi$hssf$record$PrintHeadersRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrintHeadersRecord")) : class$org$apache$poi$hssf$record$PrintHeadersRecord, class$org$apache$poi$hssf$record$PrintGridlinesRecord == null ? (class$org$apache$poi$hssf$record$PrintGridlinesRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrintGridlinesRecord")) : class$org$apache$poi$hssf$record$PrintGridlinesRecord, class$org$apache$poi$hssf$record$GridsetRecord == null ? (class$org$apache$poi$hssf$record$GridsetRecord = RecordFactory.class$("org.apache.poi.hssf.record.GridsetRecord")) : class$org$apache$poi$hssf$record$GridsetRecord, class$org$apache$poi$hssf$record$GutsRecord == null ? (class$org$apache$poi$hssf$record$GutsRecord = RecordFactory.class$("org.apache.poi.hssf.record.GutsRecord")) : class$org$apache$poi$hssf$record$GutsRecord, class$org$apache$poi$hssf$record$DefaultRowHeightRecord == null ? (class$org$apache$poi$hssf$record$DefaultRowHeightRecord = RecordFactory.class$("org.apache.poi.hssf.record.DefaultRowHeightRecord")) : class$org$apache$poi$hssf$record$DefaultRowHeightRecord, class$org$apache$poi$hssf$record$WSBoolRecord == null ? (class$org$apache$poi$hssf$record$WSBoolRecord = RecordFactory.class$("org.apache.poi.hssf.record.WSBoolRecord")) : class$org$apache$poi$hssf$record$WSBoolRecord, class$org$apache$poi$hssf$record$HeaderRecord == null ? (class$org$apache$poi$hssf$record$HeaderRecord = RecordFactory.class$("org.apache.poi.hssf.record.HeaderRecord")) : class$org$apache$poi$hssf$record$HeaderRecord, class$org$apache$poi$hssf$record$FooterRecord == null ? (class$org$apache$poi$hssf$record$FooterRecord = RecordFactory.class$("org.apache.poi.hssf.record.FooterRecord")) : class$org$apache$poi$hssf$record$FooterRecord, class$org$apache$poi$hssf$record$HCenterRecord == null ? (class$org$apache$poi$hssf$record$HCenterRecord = RecordFactory.class$("org.apache.poi.hssf.record.HCenterRecord")) : class$org$apache$poi$hssf$record$HCenterRecord, class$org$apache$poi$hssf$record$VCenterRecord == null ? (class$org$apache$poi$hssf$record$VCenterRecord = RecordFactory.class$("org.apache.poi.hssf.record.VCenterRecord")) : class$org$apache$poi$hssf$record$VCenterRecord, class$org$apache$poi$hssf$record$PrintSetupRecord == null ? (class$org$apache$poi$hssf$record$PrintSetupRecord = RecordFactory.class$("org.apache.poi.hssf.record.PrintSetupRecord")) : class$org$apache$poi$hssf$record$PrintSetupRecord, class$org$apache$poi$hssf$record$DefaultColWidthRecord == null ? (class$org$apache$poi$hssf$record$DefaultColWidthRecord = RecordFactory.class$("org.apache.poi.hssf.record.DefaultColWidthRecord")) : class$org$apache$poi$hssf$record$DefaultColWidthRecord, class$org$apache$poi$hssf$record$DimensionsRecord == null ? (class$org$apache$poi$hssf$record$DimensionsRecord = RecordFactory.class$("org.apache.poi.hssf.record.DimensionsRecord")) : class$org$apache$poi$hssf$record$DimensionsRecord, class$org$apache$poi$hssf$record$RowRecord == null ? (class$org$apache$poi$hssf$record$RowRecord = RecordFactory.class$("org.apache.poi.hssf.record.RowRecord")) : class$org$apache$poi$hssf$record$RowRecord, class$org$apache$poi$hssf$record$LabelSSTRecord == null ? (class$org$apache$poi$hssf$record$LabelSSTRecord = RecordFactory.class$("org.apache.poi.hssf.record.LabelSSTRecord")) : class$org$apache$poi$hssf$record$LabelSSTRecord, class$org$apache$poi$hssf$record$RKRecord == null ? (class$org$apache$poi$hssf$record$RKRecord = RecordFactory.class$("org.apache.poi.hssf.record.RKRecord")) : class$org$apache$poi$hssf$record$RKRecord, class$org$apache$poi$hssf$record$NumberRecord == null ? (class$org$apache$poi$hssf$record$NumberRecord = RecordFactory.class$("org.apache.poi.hssf.record.NumberRecord")) : class$org$apache$poi$hssf$record$NumberRecord, class$org$apache$poi$hssf$record$DBCellRecord == null ? (class$org$apache$poi$hssf$record$DBCellRecord = RecordFactory.class$("org.apache.poi.hssf.record.DBCellRecord")) : class$org$apache$poi$hssf$record$DBCellRecord, class$org$apache$poi$hssf$record$WindowTwoRecord == null ? (class$org$apache$poi$hssf$record$WindowTwoRecord = RecordFactory.class$("org.apache.poi.hssf.record.WindowTwoRecord")) : class$org$apache$poi$hssf$record$WindowTwoRecord, class$org$apache$poi$hssf$record$SelectionRecord == null ? (class$org$apache$poi$hssf$record$SelectionRecord = RecordFactory.class$("org.apache.poi.hssf.record.SelectionRecord")) : class$org$apache$poi$hssf$record$SelectionRecord, class$org$apache$poi$hssf$record$ContinueRecord == null ? (class$org$apache$poi$hssf$record$ContinueRecord = RecordFactory.class$("org.apache.poi.hssf.record.ContinueRecord")) : class$org$apache$poi$hssf$record$ContinueRecord, class$org$apache$poi$hssf$record$LabelRecord == null ? (class$org$apache$poi$hssf$record$LabelRecord = RecordFactory.class$("org.apache.poi.hssf.record.LabelRecord")) : class$org$apache$poi$hssf$record$LabelRecord, class$org$apache$poi$hssf$record$BlankRecord == null ? (class$org$apache$poi$hssf$record$BlankRecord = RecordFactory.class$("org.apache.poi.hssf.record.BlankRecord")) : class$org$apache$poi$hssf$record$BlankRecord, class$org$apache$poi$hssf$record$ColumnInfoRecord == null ? (class$org$apache$poi$hssf$record$ColumnInfoRecord = RecordFactory.class$("org.apache.poi.hssf.record.ColumnInfoRecord")) : class$org$apache$poi$hssf$record$ColumnInfoRecord, class$org$apache$poi$hssf$record$MulRKRecord == null ? (class$org$apache$poi$hssf$record$MulRKRecord = RecordFactory.class$("org.apache.poi.hssf.record.MulRKRecord")) : class$org$apache$poi$hssf$record$MulRKRecord, class$org$apache$poi$hssf$record$MulBlankRecord == null ? (class$org$apache$poi$hssf$record$MulBlankRecord = RecordFactory.class$("org.apache.poi.hssf.record.MulBlankRecord")) : class$org$apache$poi$hssf$record$MulBlankRecord, class$org$apache$poi$hssf$record$MergeCellsRecord == null ? (class$org$apache$poi$hssf$record$MergeCellsRecord = RecordFactory.class$("org.apache.poi.hssf.record.MergeCellsRecord")) : class$org$apache$poi$hssf$record$MergeCellsRecord, class$org$apache$poi$hssf$record$BoolErrRecord == null ? (class$org$apache$poi$hssf$record$BoolErrRecord = RecordFactory.class$("org.apache.poi.hssf.record.BoolErrRecord")) : class$org$apache$poi$hssf$record$BoolErrRecord};
    private static Map recordsMap = RecordFactory.recordsToMap(records);
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BOFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$InterfaceHdrRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MMSRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$InterfaceEndRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WriteAccessRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CodepageRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DSFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$TabIdRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FnGroupCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ProtectRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PasswordRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ProtectionRev4Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PasswordRev4Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowOneRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BackupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HideObjRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DateWindow1904Record;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrecisionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RefreshAllRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BookBoolRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FontRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FormatRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExtendedFormatRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$StyleRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$UseSelFSRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BoundSheetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CountryRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExtSSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$EOFRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$IndexRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CalcModeRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CalcCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RefModeRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$IterationRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DeltaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SaveRecalcRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintHeadersRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintGridlinesRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$GridsetRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$GutsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DefaultRowHeightRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WSBoolRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HeaderRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FooterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$HCenterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$VCenterRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$PrintSetupRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DefaultColWidthRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DimensionsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RowRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LabelSSTRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$RKRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NumberRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$DBCellRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$WindowTwoRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SelectionRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ContinueRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$LabelRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BlankRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ColumnInfoRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MulRKRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MulBlankRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$MergeCellsRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$FormulaRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$BoolErrRecord;
    static /* synthetic */ Class array$B;

    public static void setCapacity(int capacity) {
        NUM_RECORDS = capacity;
    }

    public static List createRecords(InputStream in) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>(NUM_RECORDS);
        Record last_record = null;
        try {
            short rectype = 0;
            do {
                if ((rectype = LittleEndian.readShort(in)) == 0) continue;
                short recsize = LittleEndian.readShort(in);
                byte[] data = new byte[recsize];
                in.read(data);
                Record[] recs = RecordFactory.createRecord(rectype, recsize, data);
                if (recs.length > 1) {
                    int k2 = 0;
                    while (k2 < recs.length) {
                        records.add(recs[k2]);
                        last_record = recs[k2];
                        ++k2;
                    }
                } else {
                    Record record = recs[0];
                    if (record == null) continue;
                    if (rectype == 60) {
                        if (last_record == null) {
                            throw new RecordFormatException("First record is a ContinueRecord??");
                        }
                        last_record.processContinueRecord(data);
                        continue;
                    }
                    last_record = record;
                    records.add(record);
                }
            } while (rectype != 0);
        }
        catch (IOException e2) {
            throw new RecordFormatException("Error reading bytes");
        }
        return records;
    }

    public static Record[] createRecord(short rectype, short size, byte[] data) {
        Record retval = null;
        Record[] realretval = null;
        try {
            Constructor constructor = (Constructor)recordsMap.get(new Short(rectype));
            retval = constructor != null ? (Record)constructor.newInstance(new Short(rectype), new Short(size), data) : new UnknownRecord(rectype, size, data);
        }
        catch (Exception introspectionException) {
            introspectionException.printStackTrace();
            throw new RecordFormatException("Unable to construct record instance, the following exception occured: " + introspectionException.getMessage());
        }
        if (retval instanceof RKRecord) {
            RKRecord rk = (RKRecord)retval;
            NumberRecord num = new NumberRecord();
            num.setColumn(rk.getColumn());
            num.setRow(rk.getRow());
            num.setXFIndex(rk.getXFIndex());
            num.setValue(rk.getRKNumber());
            retval = num;
        } else if (retval instanceof DBCellRecord) {
            retval = null;
        } else if (retval instanceof MulRKRecord) {
            MulRKRecord mrk = (MulRKRecord)retval;
            realretval = new Record[mrk.getNumColumns()];
            int k2 = 0;
            while (k2 < mrk.getNumColumns()) {
                NumberRecord nr = new NumberRecord();
                nr.setColumn((short)(k2 + mrk.getFirstColumn()));
                nr.setRow(mrk.getRow());
                nr.setXFIndex(mrk.getXFAt(k2));
                nr.setValue(mrk.getRKNumberAt(k2));
                realretval[k2] = nr;
                ++k2;
            }
        } else if (retval instanceof MulBlankRecord) {
            MulBlankRecord mb = (MulBlankRecord)retval;
            realretval = new Record[mb.getNumColumns()];
            int k3 = 0;
            while (k3 < mb.getNumColumns()) {
                BlankRecord br = new BlankRecord();
                br.setColumn((short)(k3 + mb.getFirstColumn()));
                br.setRow(mb.getRow());
                br.setXFIndex(mb.getXFAt(k3));
                realretval[k3] = br;
                ++k3;
            }
        }
        if (realretval == null) {
            realretval = new Record[]{retval};
        }
        return realretval;
    }

    public static short[] getAllKnownRecordSIDs() {
        short[] results = new short[recordsMap.size()];
        int i2 = 0;
        Iterator iterator = recordsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Short sid = (Short)iterator.next();
            results[i2++] = sid;
        }
        return results;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        int i2 = 0;
        while (i2 < records.length) {
            Constructor constructor;
            Class record = null;
            short sid = 0;
            record = records[i2];
            try {
                sid = record.getField("sid").getShort(null);
                constructor = record.getConstructor(Short.TYPE, Short.TYPE, array$B == null ? RecordFactory.class$("[B") : array$B);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types");
            }
            result.put(new Short(sid), constructor);
            ++i2;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

