/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.List;
import java.util.Stack;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class FormulaRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final boolean EXPERIMENTAL_FORMULA_SUPPORT_ENABLED = false;
    public static final short sid = 6;
    private short field_1_row;
    private short field_2_column;
    private short field_3_xf;
    private double field_4_value;
    private short field_5_options;
    private int field_6_zero;
    private short field_7_expression_len;
    private Stack field_8_parsed_expr;
    private byte[] all_data;

    public FormulaRecord() {
        this.field_8_parsed_expr = new Stack();
    }

    public FormulaRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FormulaRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.all_data = new byte[size + 4];
        LittleEndian.putShort(this.all_data, 0, (short)6);
        LittleEndian.putShort(this.all_data, 2, size);
        System.arraycopy(data, offset, this.all_data, 4, size);
    }

    private Stack getParsedExpressionTokens(byte[] data, short size, int offset) {
        Stack stack = new Stack();
        return stack;
    }

    public void setRow(short row) {
        this.field_1_row = row;
    }

    public void setColumn(short column) {
        this.field_2_column = column;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public void setValue(double value) {
        this.field_4_value = value;
    }

    public void setOptions(short options) {
        this.field_5_options = options;
    }

    public void setExpressionLength(short len) {
        this.field_7_expression_len = len;
    }

    public short getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public short getExpressionLength() {
        return this.field_7_expression_len;
    }

    public void pushExpressionToken(Ptg ptg) {
        this.field_8_parsed_expr.push(ptg);
    }

    public Ptg popExpressionToken() {
        return (Ptg)this.field_8_parsed_expr.pop();
    }

    public Ptg peekExpressionToken() {
        return (Ptg)this.field_8_parsed_expr.peek();
    }

    public int getNumberOfExpressionTokens() {
        return this.field_8_parsed_expr.size();
    }

    public List getParsedExpression() {
        return this.field_8_parsed_expr;
    }

    protected void validateSid(short id) {
        if (id != 6) {
            throw new RecordFormatException("NOT A FORMULA RECORD");
        }
    }

    public short getSid() {
        return 6;
    }

    public int serialize(int offset, byte[] data) {
        System.arraycopy(this.all_data, 0, data, offset, this.all_data.length);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 0;
        retval = this.all_data.length;
        return retval;
    }

    private int getTotalPtgSize() {
        List list = this.getParsedExpression();
        int retval = 0;
        int k2 = 0;
        while (k2 < list.size()) {
            Ptg ptg = (Ptg)list.get(k2);
            retval += ptg.getSize();
            ++k2;
        }
        return retval;
    }

    private void serializePtgs(byte[] data, int offset) {
        int pos = offset;
        int k2 = 0;
        while (k2 < this.field_8_parsed_expr.size()) {
            Ptg ptg = (Ptg)this.field_8_parsed_expr.get(k2);
            ptg.writeBytes(data, pos);
            pos += ptg.getSize();
            ++k2;
        }
    }

    public boolean isBefore(CellValueRecordInterface i2) {
        if (this.getRow() > i2.getRow()) {
            return false;
        }
        if (this.getRow() == i2.getRow() && this.getColumn() > i2.getColumn()) {
            return false;
        }
        return this.getRow() != i2.getRow() || this.getColumn() != i2.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface i2) {
        if (this.getRow() < i2.getRow()) {
            return false;
        }
        if (this.getRow() == i2.getRow() && this.getColumn() < i2.getColumn()) {
            return false;
        }
        return this.getRow() != i2.getRow() || this.getColumn() != i2.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface i2) {
        return this.getRow() == i2.getRow() && this.getColumn() == i2.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int compareTo(Object obj) {
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        if (this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn()) {
            return 0;
        }
        if (this.getRow() < loc.getRow()) {
            return -1;
        }
        if (this.getRow() > loc.getRow()) {
            return 1;
        }
        if (this.getColumn() < loc.getColumn()) {
            return -1;
        }
        if (this.getColumn() > loc.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        return this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn();
    }
}

