/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.ExtSSTInfoSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class ExtSSTRecord
extends Record {
    public static final short sid = 255;
    private short field_1_strings_per_bucket;
    private ArrayList field_2_sst_info;

    public ExtSSTRecord() {
        this.field_2_sst_info = new ArrayList();
    }

    public ExtSSTRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ExtSSTRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 255) {
            throw new RecordFormatException("NOT An EXTSST RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_2_sst_info = new ArrayList();
        this.field_1_strings_per_bucket = LittleEndian.getShort(data, 0 + offset);
        int k2 = 2;
        while (k2 < data.length - offset - size) {
            byte[] tempdata = new byte[8 + offset];
            System.arraycopy(data, k2, tempdata, 0, 8);
            ExtSSTInfoSubRecord rec = new ExtSSTInfoSubRecord(0, 8, tempdata);
            this.field_2_sst_info.add(rec);
            k2 += 8;
        }
    }

    public void setNumStringsPerBucket(short numStrings) {
        this.field_1_strings_per_bucket = numStrings;
    }

    public void addInfoRecord(ExtSSTInfoSubRecord rec) {
        this.field_2_sst_info.add(rec);
    }

    public short getNumStringsPerBucket() {
        return this.field_1_strings_per_bucket;
    }

    public int getNumInfoRecords() {
        return this.field_2_sst_info.size();
    }

    public ExtSSTInfoSubRecord getInfoRecordAt(int elem) {
        return (ExtSSTInfoSubRecord)this.field_2_sst_info.get(elem);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTSST]\n");
        buffer.append("    .dsst           = ").append(Integer.toHexString(this.getNumStringsPerBucket())).append("\n");
        buffer.append("    .numInfoRecords = ").append(this.getNumInfoRecords()).append("\n");
        int k2 = 0;
        while (k2 < this.getNumInfoRecords()) {
            buffer.append("    .inforecord     = ").append(k2).append("\n");
            buffer.append("    .streampos      = ").append(Integer.toHexString(this.getInfoRecordAt(k2).getStreamPos())).append("\n");
            buffer.append("    .sstoffset      = ").append(Integer.toHexString(this.getInfoRecordAt(k2).getBucketSSTOffset())).append("\n");
            ++k2;
        }
        buffer.append("[/EXTSST]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)255);
        LittleEndian.putShort(data, 2 + offset, (short)1018);
        int pos = 4;
        int k2 = 0;
        while (k2 < this.getNumInfoRecords()) {
            System.arraycopy(this.getInfoRecordAt(k2).serialize(), 0, data, pos + offset, 8);
            ++k2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 1022;
    }

    public short getSid() {
        return 255;
    }
}

