/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class BlankRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 513;
    private short field_1_row;
    private short field_2_col;
    private short field_3_xf;

    public BlankRecord() {
    }

    public BlankRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public BlankRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_row = LittleEndian.getShort(data, 0 + offset);
        this.field_2_col = LittleEndian.getShort(data, 2 + offset);
        this.field_3_xf = LittleEndian.getShort(data, 4 + offset);
    }

    protected void validateSid(short id) {
        if (id != 513) {
            throw new RecordFormatException("NOT A BLANKRECORD!");
        }
    }

    public void setRow(short row) {
        this.field_1_row = row;
    }

    public short getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public void setColumn(short col) {
        this.field_2_col = col;
    }

    public boolean isBefore(CellValueRecordInterface i2) {
        if (this.getRow() > i2.getRow()) {
            return false;
        }
        if (this.getRow() == i2.getRow() && this.getColumn() > i2.getColumn()) {
            return false;
        }
        return this.getRow() != i2.getRow() || this.getColumn() != i2.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface i2) {
        if (this.getRow() < i2.getRow()) {
            return false;
        }
        if (this.getRow() == i2.getRow() && this.getColumn() < i2.getColumn()) {
            return false;
        }
        return this.getRow() != i2.getRow() || this.getColumn() != i2.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface i2) {
        return this.getRow() == i2.getRow() && this.getColumn() == i2.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public short getSid() {
        return 513;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BLANK]\n");
        buffer.append("row       = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("col       = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("xf        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("[/BLANK]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)513);
        LittleEndian.putShort(data, 2 + offset, (short)6);
        LittleEndian.putShort(data, 4 + offset, this.getRow());
        LittleEndian.putShort(data, 6 + offset, this.getColumn());
        LittleEndian.putShort(data, 8 + offset, this.getXFIndex());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public int compareTo(Object obj) {
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        if (this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn()) {
            return 0;
        }
        if (this.getRow() < loc.getRow()) {
            return -1;
        }
        if (this.getRow() > loc.getRow()) {
            return 1;
        }
        if (this.getColumn() < loc.getColumn()) {
            return -1;
        }
        if (this.getColumn() > loc.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        return this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn();
    }
}

