/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.util;

import org.apache.oro.util.GenericCache;
import org.apache.oro.util.GenericCacheEntry;

public final class CacheLRU
extends GenericCache {
    private int __head = 0;
    private int __tail = 0;
    private int[] __next = new int[this._cache.length];
    private int[] __prev = new int[this._cache.length];

    public CacheLRU(int n2) {
        super(n2);
        int n3 = 0;
        while (n3 < this.__next.length) {
            this.__prev[n3] = -1;
            this.__next[n3] = -1;
            ++n3;
        }
    }

    public CacheLRU() {
        this(20);
    }

    private void __moveToFront(int n2) {
        if (this.__head != n2) {
            int n3 = this.__next[n2];
            int n4 = this.__prev[n2];
            this.__next[n4] = n3;
            if (n3 >= 0) {
                this.__prev[n3] = n4;
            } else {
                this.__tail = n4;
            }
            this.__prev[n2] = -1;
            this.__next[n2] = this.__head;
            this.__prev[this.__head] = n2;
            this.__head = n2;
        }
    }

    public synchronized Object getElement(Object object) {
        Object v = this._table.get(object);
        if (v != null) {
            GenericCacheEntry genericCacheEntry = (GenericCacheEntry)v;
            this.__moveToFront(genericCacheEntry._index);
            return genericCacheEntry._value;
        }
        return null;
    }

    public final synchronized void addElement(Object object, Object object2) {
        Object v = this._table.get(object);
        if (v != null) {
            GenericCacheEntry genericCacheEntry = (GenericCacheEntry)v;
            genericCacheEntry._value = object2;
            genericCacheEntry._key = object;
            this.__moveToFront(genericCacheEntry._index);
            return;
        }
        if (!this.isFull()) {
            if (this._numEntries > 0) {
                this.__prev[this._numEntries] = this.__tail;
                this.__next[this._numEntries] = -1;
                this.__moveToFront(this._numEntries);
            }
            ++this._numEntries;
        } else {
            this._table.remove(this._cache[this.__tail]._key);
            this.__moveToFront(this.__tail);
        }
        this._cache[this.__head]._value = object2;
        this._cache[this.__head]._key = object;
        this._table.put(object, this._cache[this.__head]);
    }
}

