/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;

public final class GlobCompiler
implements PatternCompiler {
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int STAR_CANNOT_MATCH_NULL_MASK = 2;
    public static final int QUESTION_MATCHES_ZERO_OR_ONE_MASK = 4;
    public static final int READ_ONLY_MASK = 8;
    private Perl5Compiler __perl5Compiler = new Perl5Compiler();

    private static boolean __isPerl5MetaCharacter(char c2) {
        return c2 == '*' || c2 == '?' || c2 == '+' || c2 == '[' || c2 == ']' || c2 == '(' || c2 == ')' || c2 == '|' || c2 == '^' || c2 == '$' || c2 == '.' || c2 == '{' || c2 == '}' || c2 == '\\';
    }

    private static boolean __isGlobMetaCharacter(char c2) {
        return c2 == '*' || c2 == '?' || c2 == '[' || c2 == ']';
    }

    public static String globToPerl5(char[] cArray, int n2) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(2 * cArray.length);
        boolean bl2 = false;
        boolean bl3 = (n2 & 4) != 0;
        bl = (n2 & 2) != 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            block0 : switch (cArray[n3]) {
                case '*': {
                    if (bl2) {
                        stringBuffer.append('*');
                        break;
                    }
                    if (bl) {
                        stringBuffer.append(".+");
                        break;
                    }
                    stringBuffer.append(".*");
                    break;
                }
                case '?': {
                    if (bl2) {
                        stringBuffer.append('?');
                        break;
                    }
                    if (bl3) {
                        stringBuffer.append(".?");
                        break;
                    }
                    stringBuffer.append('.');
                    break;
                }
                case '[': {
                    bl2 = true;
                    stringBuffer.append(cArray[n3]);
                    if (n3 + 1 >= cArray.length) break;
                    switch (cArray[n3 + 1]) {
                        case '!': 
                        case '^': {
                            stringBuffer.append('^');
                            ++n3;
                            break block0;
                        }
                        case ']': {
                            stringBuffer.append(']');
                            ++n3;
                            break block0;
                        }
                    }
                    break;
                }
                case ']': {
                    bl2 = false;
                    stringBuffer.append(cArray[n3]);
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    if (n3 == cArray.length - 1) {
                        stringBuffer.append('\\');
                        break;
                    }
                    if (GlobCompiler.__isGlobMetaCharacter(cArray[n3 + 1])) {
                        stringBuffer.append(cArray[++n3]);
                        break;
                    }
                    stringBuffer.append('\\');
                    break;
                }
                default: {
                    if (!bl2 && GlobCompiler.__isPerl5MetaCharacter(cArray[n3])) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(cArray[n3]);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public Pattern compile(char[] cArray, int n2) throws MalformedPatternException {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 8) != 0) {
            n3 |= 0x8000;
        }
        return this.__perl5Compiler.compile(GlobCompiler.globToPerl5(cArray, n2), n3);
    }

    public Pattern compile(char[] cArray) throws MalformedPatternException {
        return this.compile(cArray, 0);
    }

    public Pattern compile(String string) throws MalformedPatternException {
        return this.compile(string.toCharArray(), 0);
    }

    public Pattern compile(String string, int n2) throws MalformedPatternException {
        return this.compile(string.toCharArray(), n2);
    }
}

