/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3d;
import javax.vecmath.VecMathI18N;
import javax.vecmath.VecMathUtil;
import javax.vecmath.Vector3d;

public class Matrix3d
implements Serializable,
Cloneable {
    static final long serialVersionUID = 6837536777072402710L;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;
    private static final double EPS = 1.110223024E-16;
    private static final double ERR_EPS = 1.0E-8;
    private static double xin;
    private static double yin;
    private static double zin;
    private static double xout;
    private static double yout;
    private static double zout;

    public Matrix3d(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
    }

    public Matrix3d(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public Matrix3d(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
    }

    public Matrix3d(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public Matrix3d() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
    }

    public String toString() {
        return this.m00 + ", " + this.m01 + ", " + this.m02 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + "\n";
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public final void setScale(double d2) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        this.m00 = dArray[0] * d2;
        this.m01 = dArray[1] * d2;
        this.m02 = dArray[2] * d2;
        this.m10 = dArray[3] * d2;
        this.m11 = dArray[4] * d2;
        this.m12 = dArray[5] * d2;
        this.m20 = dArray[6] * d2;
        this.m21 = dArray[7] * d2;
        this.m22 = dArray[8] * d2;
    }

    public final void setElement(int n2, int n3, double d2) {
        block0 : switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        this.m00 = d2;
                        break block0;
                    }
                    case 1: {
                        this.m01 = d2;
                        break block0;
                    }
                    case 2: {
                        this.m02 = d2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d0"));
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        this.m10 = d2;
                        break block0;
                    }
                    case 1: {
                        this.m11 = d2;
                        break block0;
                    }
                    case 2: {
                        this.m12 = d2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d0"));
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        this.m20 = d2;
                        break block0;
                    }
                    case 1: {
                        this.m21 = d2;
                        break block0;
                    }
                    case 2: {
                        this.m22 = d2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d0"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d0"));
            }
        }
    }

    public final double getElement(int n2, int n3) {
        switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
                break;
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
                break;
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
                break;
            }
        }
        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d1"));
    }

    public final void getRow(int n2, Vector3d vector3d) {
        if (n2 == 0) {
            vector3d.x = this.m00;
            vector3d.y = this.m01;
            vector3d.z = this.m02;
        } else if (n2 == 1) {
            vector3d.x = this.m10;
            vector3d.y = this.m11;
            vector3d.z = this.m12;
        } else if (n2 == 2) {
            vector3d.x = this.m20;
            vector3d.y = this.m21;
            vector3d.z = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d2"));
        }
    }

    public final void getRow(int n2, double[] dArray) {
        if (n2 == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m01;
            dArray[2] = this.m02;
        } else if (n2 == 1) {
            dArray[0] = this.m10;
            dArray[1] = this.m11;
            dArray[2] = this.m12;
        } else if (n2 == 2) {
            dArray[0] = this.m20;
            dArray[1] = this.m21;
            dArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d2"));
        }
    }

    public final void getColumn(int n2, Vector3d vector3d) {
        if (n2 == 0) {
            vector3d.x = this.m00;
            vector3d.y = this.m10;
            vector3d.z = this.m20;
        } else if (n2 == 1) {
            vector3d.x = this.m01;
            vector3d.y = this.m11;
            vector3d.z = this.m21;
        } else if (n2 == 2) {
            vector3d.x = this.m02;
            vector3d.y = this.m12;
            vector3d.z = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d4"));
        }
    }

    public final void getColumn(int n2, double[] dArray) {
        if (n2 == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m10;
            dArray[2] = this.m20;
        } else if (n2 == 1) {
            dArray[0] = this.m01;
            dArray[1] = this.m11;
            dArray[2] = this.m21;
        } else if (n2 == 2) {
            dArray[0] = this.m02;
            dArray[1] = this.m12;
            dArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d4"));
        }
    }

    public final void setRow(int n2, double d2, double d3, double d4) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m01 = d3;
                this.m02 = d4;
                break;
            }
            case 1: {
                this.m10 = d2;
                this.m11 = d3;
                this.m12 = d4;
                break;
            }
            case 2: {
                this.m20 = d2;
                this.m21 = d3;
                this.m22 = d4;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d6"));
            }
        }
    }

    public final void setRow(int n2, Vector3d vector3d) {
        switch (n2) {
            case 0: {
                this.m00 = vector3d.x;
                this.m01 = vector3d.y;
                this.m02 = vector3d.z;
                break;
            }
            case 1: {
                this.m10 = vector3d.x;
                this.m11 = vector3d.y;
                this.m12 = vector3d.z;
                break;
            }
            case 2: {
                this.m20 = vector3d.x;
                this.m21 = vector3d.y;
                this.m22 = vector3d.z;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d6"));
            }
        }
    }

    public final void setRow(int n2, double[] dArray) {
        switch (n2) {
            case 0: {
                this.m00 = dArray[0];
                this.m01 = dArray[1];
                this.m02 = dArray[2];
                break;
            }
            case 1: {
                this.m10 = dArray[0];
                this.m11 = dArray[1];
                this.m12 = dArray[2];
                break;
            }
            case 2: {
                this.m20 = dArray[0];
                this.m21 = dArray[1];
                this.m22 = dArray[2];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d6"));
            }
        }
    }

    public final void setColumn(int n2, double d2, double d3, double d4) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m10 = d3;
                this.m20 = d4;
                break;
            }
            case 1: {
                this.m01 = d2;
                this.m11 = d3;
                this.m21 = d4;
                break;
            }
            case 2: {
                this.m02 = d2;
                this.m12 = d3;
                this.m22 = d4;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d9"));
            }
        }
    }

    public final void setColumn(int n2, Vector3d vector3d) {
        switch (n2) {
            case 0: {
                this.m00 = vector3d.x;
                this.m10 = vector3d.y;
                this.m20 = vector3d.z;
                break;
            }
            case 1: {
                this.m01 = vector3d.x;
                this.m11 = vector3d.y;
                this.m21 = vector3d.z;
                break;
            }
            case 2: {
                this.m02 = vector3d.x;
                this.m12 = vector3d.y;
                this.m22 = vector3d.z;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d9"));
            }
        }
    }

    public final void setColumn(int n2, double[] dArray) {
        switch (n2) {
            case 0: {
                this.m00 = dArray[0];
                this.m10 = dArray[1];
                this.m20 = dArray[2];
                break;
            }
            case 1: {
                this.m01 = dArray[0];
                this.m11 = dArray[1];
                this.m21 = dArray[2];
                break;
            }
            case 2: {
                this.m02 = dArray[0];
                this.m12 = dArray[1];
                this.m22 = dArray[2];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix3d9"));
            }
        }
    }

    public final double getScale() {
        double[] dArray = new double[3];
        double[] dArray2 = new double[9];
        this.getScaleRotate(dArray, dArray2);
        return Matrix3d.max3(dArray);
    }

    public final void add(double d2) {
        this.m00 += d2;
        this.m01 += d2;
        this.m02 += d2;
        this.m10 += d2;
        this.m11 += d2;
        this.m12 += d2;
        this.m20 += d2;
        this.m21 += d2;
        this.m22 += d2;
    }

    public final void add(double d2, Matrix3d matrix3d) {
        this.m00 = matrix3d.m00 + d2;
        this.m01 = matrix3d.m01 + d2;
        this.m02 = matrix3d.m02 + d2;
        this.m10 = matrix3d.m10 + d2;
        this.m11 = matrix3d.m11 + d2;
        this.m12 = matrix3d.m12 + d2;
        this.m20 = matrix3d.m20 + d2;
        this.m21 = matrix3d.m21 + d2;
        this.m22 = matrix3d.m22 + d2;
    }

    public final void add(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.m00 = matrix3d.m00 + matrix3d2.m00;
        this.m01 = matrix3d.m01 + matrix3d2.m01;
        this.m02 = matrix3d.m02 + matrix3d2.m02;
        this.m10 = matrix3d.m10 + matrix3d2.m10;
        this.m11 = matrix3d.m11 + matrix3d2.m11;
        this.m12 = matrix3d.m12 + matrix3d2.m12;
        this.m20 = matrix3d.m20 + matrix3d2.m20;
        this.m21 = matrix3d.m21 + matrix3d2.m21;
        this.m22 = matrix3d.m22 + matrix3d2.m22;
    }

    public final void add(Matrix3d matrix3d) {
        this.m00 += matrix3d.m00;
        this.m01 += matrix3d.m01;
        this.m02 += matrix3d.m02;
        this.m10 += matrix3d.m10;
        this.m11 += matrix3d.m11;
        this.m12 += matrix3d.m12;
        this.m20 += matrix3d.m20;
        this.m21 += matrix3d.m21;
        this.m22 += matrix3d.m22;
    }

    public final void sub(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.m00 = matrix3d.m00 - matrix3d2.m00;
        this.m01 = matrix3d.m01 - matrix3d2.m01;
        this.m02 = matrix3d.m02 - matrix3d2.m02;
        this.m10 = matrix3d.m10 - matrix3d2.m10;
        this.m11 = matrix3d.m11 - matrix3d2.m11;
        this.m12 = matrix3d.m12 - matrix3d2.m12;
        this.m20 = matrix3d.m20 - matrix3d2.m20;
        this.m21 = matrix3d.m21 - matrix3d2.m21;
        this.m22 = matrix3d.m22 - matrix3d2.m22;
    }

    public final void sub(Matrix3d matrix3d) {
        this.m00 -= matrix3d.m00;
        this.m01 -= matrix3d.m01;
        this.m02 -= matrix3d.m02;
        this.m10 -= matrix3d.m10;
        this.m11 -= matrix3d.m11;
        this.m12 -= matrix3d.m12;
        this.m20 -= matrix3d.m20;
        this.m21 -= matrix3d.m21;
        this.m22 -= matrix3d.m22;
    }

    public final void transpose() {
        double d2 = this.m10;
        this.m10 = this.m01;
        this.m01 = d2;
        d2 = this.m20;
        this.m20 = this.m02;
        this.m02 = d2;
        d2 = this.m21;
        this.m21 = this.m12;
        this.m12 = d2;
    }

    public final void transpose(Matrix3d matrix3d) {
        if (this != matrix3d) {
            this.m00 = matrix3d.m00;
            this.m01 = matrix3d.m10;
            this.m02 = matrix3d.m20;
            this.m10 = matrix3d.m01;
            this.m11 = matrix3d.m11;
            this.m12 = matrix3d.m21;
            this.m20 = matrix3d.m02;
            this.m21 = matrix3d.m12;
            this.m22 = matrix3d.m22;
        } else {
            this.transpose();
        }
    }

    public final void set(Quat4d quat4d) {
        this.m00 = 1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z;
        this.m10 = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z);
        this.m20 = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y);
        this.m01 = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z);
        this.m11 = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z;
        this.m21 = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x);
        this.m02 = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y);
        this.m12 = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x);
        this.m22 = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y;
    }

    public final void set(AxisAngle4d axisAngle4d) {
        double d2 = Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z);
        if (d2 < 1.110223024E-16) {
            this.m00 = 1.0;
            this.m01 = 0.0;
            this.m02 = 0.0;
            this.m10 = 0.0;
            this.m11 = 1.0;
            this.m12 = 0.0;
            this.m20 = 0.0;
            this.m21 = 0.0;
            this.m22 = 1.0;
        } else {
            d2 = 1.0 / d2;
            double d3 = axisAngle4d.x * d2;
            double d4 = axisAngle4d.y * d2;
            double d5 = axisAngle4d.z * d2;
            double d6 = Math.sin(axisAngle4d.angle);
            double d7 = Math.cos(axisAngle4d.angle);
            double d8 = 1.0 - d7;
            double d9 = axisAngle4d.x * axisAngle4d.z;
            double d10 = axisAngle4d.x * axisAngle4d.y;
            double d11 = axisAngle4d.y * axisAngle4d.z;
            this.m00 = d8 * d3 * d3 + d7;
            this.m01 = d8 * d10 - d6 * d5;
            this.m02 = d8 * d9 + d6 * d4;
            this.m10 = d8 * d10 + d6 * d5;
            this.m11 = d8 * d4 * d4 + d7;
            this.m12 = d8 * d11 - d6 * d3;
            this.m20 = d8 * d9 - d6 * d4;
            this.m21 = d8 * d11 + d6 * d3;
            this.m22 = d8 * d5 * d5 + d7;
        }
    }

    public final void set(Quat4f quat4f) {
        this.m00 = 1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z;
        this.m10 = 2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.m20 = 2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.m01 = 2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.m11 = 1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z;
        this.m21 = 2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.m02 = 2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.m12 = 2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.m22 = 1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y;
    }

    public final void set(AxisAngle4f axisAngle4f) {
        double d2 = Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z);
        if (d2 < 1.110223024E-16) {
            this.m00 = 1.0;
            this.m01 = 0.0;
            this.m02 = 0.0;
            this.m10 = 0.0;
            this.m11 = 1.0;
            this.m12 = 0.0;
            this.m20 = 0.0;
            this.m21 = 0.0;
            this.m22 = 1.0;
        } else {
            d2 = 1.0 / d2;
            double d3 = (double)axisAngle4f.x * d2;
            double d4 = (double)axisAngle4f.y * d2;
            double d5 = (double)axisAngle4f.z * d2;
            double d6 = Math.sin(axisAngle4f.angle);
            double d7 = Math.cos(axisAngle4f.angle);
            double d8 = 1.0 - d7;
            double d9 = d3 * d5;
            double d10 = d3 * d4;
            double d11 = d4 * d5;
            this.m00 = d8 * d3 * d3 + d7;
            this.m01 = d8 * d10 - d6 * d5;
            this.m02 = d8 * d9 + d6 * d4;
            this.m10 = d8 * d10 + d6 * d5;
            this.m11 = d8 * d4 * d4 + d7;
            this.m12 = d8 * d11 - d6 * d3;
            this.m20 = d8 * d9 - d6 * d4;
            this.m21 = d8 * d11 + d6 * d3;
            this.m22 = d8 * d5 * d5 + d7;
        }
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
    }

    public final void set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public final void invert(Matrix3d matrix3d) {
        this.invertGeneral(matrix3d);
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    private final void invertGeneral(Matrix3d matrix3d) {
        double[] dArray = new double[9];
        int[] nArray = new int[3];
        double[] dArray2 = new double[]{matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22};
        if (!Matrix3d.luDecomposition(dArray2, nArray)) {
            throw new SingularMatrixException(VecMathI18N.getString("Matrix3d12"));
        }
        for (int i2 = 0; i2 < 9; ++i2) {
            dArray[i2] = 0.0;
        }
        dArray[0] = 1.0;
        dArray[4] = 1.0;
        dArray[8] = 1.0;
        Matrix3d.luBacksubstitution(dArray2, nArray, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        int n2;
        double[] dArray2 = new double[3];
        int n3 = 0;
        int n4 = 0;
        int n5 = 3;
        while (n5-- != 0) {
            double d2 = 0.0;
            n2 = 3;
            while (n2-- != 0) {
                double d3 = dArray[n3++];
                if (!((d3 = Math.abs(d3)) > d2)) continue;
                d2 = d3;
            }
            if (d2 == 0.0) {
                return false;
            }
            dArray2[n4++] = 1.0 / d2;
        }
        n2 = 0;
        for (n5 = 0; n5 < 3; ++n5) {
            double d4;
            int n6;
            int n7;
            int n8;
            double d5;
            int n9;
            for (n3 = 0; n3 < n5; ++n3) {
                n9 = n2 + 3 * n3 + n5;
                d5 = dArray[n9];
                int n10 = n3;
                int n11 = n2 + 3 * n3;
                n8 = n2 + n5;
                while (n10-- != 0) {
                    d5 -= dArray[n11] * dArray[n8];
                    ++n11;
                    n8 += 3;
                }
                dArray[n9] = d5;
            }
            double d6 = 0.0;
            n4 = -1;
            for (n3 = n5; n3 < 3; ++n3) {
                double d7;
                n9 = n2 + 3 * n3 + n5;
                d5 = dArray[n9];
                n7 = n5;
                n6 = n2 + 3 * n3;
                n8 = n2 + n5;
                while (n7-- != 0) {
                    d5 -= dArray[n6] * dArray[n8];
                    ++n6;
                    n8 += 3;
                }
                dArray[n9] = d5;
                d4 = dArray2[n3] * Math.abs(d5);
                if (!(d7 >= d6)) continue;
                d6 = d4;
                n4 = n3;
            }
            if (n4 < 0) {
                throw new RuntimeException(VecMathI18N.getString("Matrix3d13"));
            }
            if (n5 != n4) {
                n7 = 3;
                n6 = n2 + 3 * n4;
                n8 = n2 + 3 * n5;
                while (n7-- != 0) {
                    d4 = dArray[n6];
                    dArray[n6++] = dArray[n8];
                    dArray[n8++] = d4;
                }
                dArray2[n4] = dArray2[n5];
            }
            nArray[n5] = n4;
            if (dArray[n2 + 3 * n5 + n5] == 0.0) {
                return false;
            }
            if (n5 == 2) continue;
            d4 = 1.0 / dArray[n2 + 3 * n5 + n5];
            n9 = n2 + 3 * (n5 + 1) + n5;
            n3 = 2 - n5;
            while (n3-- != 0) {
                int n12 = n9;
                dArray[n12] = dArray[n12] * d4;
                n9 += 3;
            }
        }
        return true;
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n2 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            int n3;
            int n4 = i2;
            int n5 = -1;
            for (int i3 = 0; i3 < 3; ++i3) {
                int n6 = nArray[n2 + i3];
                double d2 = dArray2[n4 + 3 * n6];
                dArray2[n4 + 3 * n6] = dArray2[n4 + 3 * i3];
                if (n5 >= 0) {
                    n3 = i3 * 3;
                    for (int i4 = n5; i4 <= i3 - 1; ++i4) {
                        d2 -= dArray[n3 + i4] * dArray2[n4 + 3 * i4];
                    }
                } else if (d2 != 0.0) {
                    n5 = i3;
                }
                dArray2[n4 + 3 * i3] = d2;
            }
            n3 = 6;
            int n7 = n4 + 6;
            dArray2[n7] = dArray2[n7] / dArray[n3 + 2];
            dArray2[n4 + 3] = (dArray2[n4 + 3] - dArray[(n3 -= 3) + 2] * dArray2[n4 + 6]) / dArray[n3 + 1];
            dArray2[n4 + 0] = (dArray2[n4 + 0] - dArray[(n3 -= 3) + 1] * dArray2[n4 + 3] - dArray[n3 + 2] * dArray2[n4 + 6]) / dArray[n3 + 0];
        }
    }

    public final double determinant() {
        double d2 = this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
        return d2;
    }

    public final void set(double d2) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d2;
    }

    public final void rotX(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d4;
        this.m12 = -d3;
        this.m20 = 0.0;
        this.m21 = d3;
        this.m22 = d4;
    }

    public final void rotY(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cos(d2);
        this.m01 = 0.0;
        this.m02 = d4;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = -d4;
        this.m21 = 0.0;
        this.m22 = d3;
    }

    public final void rotZ(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cos(d2);
        this.m01 = -d4;
        this.m02 = 0.0;
        this.m10 = d4;
        this.m11 = d3;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public final void mul(double d2) {
        this.m00 *= d2;
        this.m01 *= d2;
        this.m02 *= d2;
        this.m10 *= d2;
        this.m11 *= d2;
        this.m12 *= d2;
        this.m20 *= d2;
        this.m21 *= d2;
        this.m22 *= d2;
    }

    public final void mul(double d2, Matrix3d matrix3d) {
        this.m00 = d2 * matrix3d.m00;
        this.m01 = d2 * matrix3d.m01;
        this.m02 = d2 * matrix3d.m02;
        this.m10 = d2 * matrix3d.m10;
        this.m11 = d2 * matrix3d.m11;
        this.m12 = d2 * matrix3d.m12;
        this.m20 = d2 * matrix3d.m20;
        this.m21 = d2 * matrix3d.m21;
        this.m22 = d2 * matrix3d.m22;
    }

    public final void mul(Matrix3d matrix3d) {
        double d2 = this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20;
        double d3 = this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21;
        double d4 = this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22;
        double d5 = this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20;
        double d6 = this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21;
        double d7 = this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22;
        double d8 = this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20;
        double d9 = this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21;
        double d10 = this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22;
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
    }

    public final void mul(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m10 + matrix3d.m02 * matrix3d2.m20;
            this.m01 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m21;
            this.m02 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m01 * matrix3d2.m12 + matrix3d.m02 * matrix3d2.m22;
            this.m10 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m20;
            this.m11 = matrix3d.m10 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m21;
            this.m12 = matrix3d.m10 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m12 * matrix3d2.m22;
            this.m20 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            this.m21 = matrix3d.m20 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            this.m22 = matrix3d.m20 * matrix3d2.m02 + matrix3d.m21 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d2 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m10 + matrix3d.m02 * matrix3d2.m20;
            double d3 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m21;
            double d4 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m01 * matrix3d2.m12 + matrix3d.m02 * matrix3d2.m22;
            double d5 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m20;
            double d6 = matrix3d.m10 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m21;
            double d7 = matrix3d.m10 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m12 * matrix3d2.m22;
            double d8 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            double d9 = matrix3d.m20 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            double d10 = matrix3d.m20 * matrix3d2.m02 + matrix3d.m21 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m10 = d5;
            this.m11 = d6;
            this.m12 = d7;
            this.m20 = d8;
            this.m21 = d9;
            this.m22 = d10;
        }
    }

    public final void mulNormalize(Matrix3d matrix3d) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        double[] dArray3 = new double[3];
        dArray[0] = this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20;
        dArray[1] = this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21;
        dArray[2] = this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22;
        dArray[3] = this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20;
        dArray[4] = this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21;
        dArray[5] = this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22;
        dArray[6] = this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20;
        dArray[7] = this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21;
        dArray[8] = this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22;
        Matrix3d.compute_svd(dArray, dArray3, dArray2);
        this.m00 = dArray2[0];
        this.m01 = dArray2[1];
        this.m02 = dArray2[2];
        this.m10 = dArray2[3];
        this.m11 = dArray2[4];
        this.m12 = dArray2[5];
        this.m20 = dArray2[6];
        this.m21 = dArray2[7];
        this.m22 = dArray2[8];
    }

    public final void mulNormalize(Matrix3d matrix3d, Matrix3d matrix3d2) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        double[] dArray3 = new double[3];
        dArray[0] = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m10 + matrix3d.m02 * matrix3d2.m20;
        dArray[1] = matrix3d.m00 * matrix3d2.m01 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m21;
        dArray[2] = matrix3d.m00 * matrix3d2.m02 + matrix3d.m01 * matrix3d2.m12 + matrix3d.m02 * matrix3d2.m22;
        dArray[3] = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m20;
        dArray[4] = matrix3d.m10 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m21;
        dArray[5] = matrix3d.m10 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m12 * matrix3d2.m22;
        dArray[6] = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
        dArray[7] = matrix3d.m20 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
        dArray[8] = matrix3d.m20 * matrix3d2.m02 + matrix3d.m21 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
        Matrix3d.compute_svd(dArray, dArray3, dArray2);
        this.m00 = dArray2[0];
        this.m01 = dArray2[1];
        this.m02 = dArray2[2];
        this.m10 = dArray2[3];
        this.m11 = dArray2[4];
        this.m12 = dArray2[5];
        this.m20 = dArray2[6];
        this.m21 = dArray2[7];
        this.m22 = dArray2[8];
    }

    public final void mulTransposeBoth(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m01 + matrix3d.m20 * matrix3d2.m02;
            this.m01 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m12;
            this.m02 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m10 * matrix3d2.m21 + matrix3d.m20 * matrix3d2.m22;
            this.m10 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m02;
            this.m11 = matrix3d.m01 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m12;
            this.m12 = matrix3d.m01 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m21 * matrix3d2.m22;
            this.m20 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            this.m21 = matrix3d.m02 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            this.m22 = matrix3d.m02 * matrix3d2.m20 + matrix3d.m12 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d2 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m01 + matrix3d.m20 * matrix3d2.m02;
            double d3 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m12;
            double d4 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m10 * matrix3d2.m21 + matrix3d.m20 * matrix3d2.m22;
            double d5 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m02;
            double d6 = matrix3d.m01 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m12;
            double d7 = matrix3d.m01 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m21 * matrix3d2.m22;
            double d8 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            double d9 = matrix3d.m02 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            double d10 = matrix3d.m02 * matrix3d2.m20 + matrix3d.m12 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m10 = d5;
            this.m11 = d6;
            this.m12 = d7;
            this.m20 = d8;
            this.m21 = d9;
            this.m22 = d10;
        }
    }

    public final void mulTransposeRight(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m01 + matrix3d.m02 * matrix3d2.m02;
            this.m01 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m12;
            this.m02 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m01 * matrix3d2.m21 + matrix3d.m02 * matrix3d2.m22;
            this.m10 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m02;
            this.m11 = matrix3d.m10 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m12;
            this.m12 = matrix3d.m10 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m12 * matrix3d2.m22;
            this.m20 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            this.m21 = matrix3d.m20 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            this.m22 = matrix3d.m20 * matrix3d2.m20 + matrix3d.m21 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d2 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m01 + matrix3d.m02 * matrix3d2.m02;
            double d3 = matrix3d.m00 * matrix3d2.m10 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m12;
            double d4 = matrix3d.m00 * matrix3d2.m20 + matrix3d.m01 * matrix3d2.m21 + matrix3d.m02 * matrix3d2.m22;
            double d5 = matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m02;
            double d6 = matrix3d.m10 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m12;
            double d7 = matrix3d.m10 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m12 * matrix3d2.m22;
            double d8 = matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02;
            double d9 = matrix3d.m20 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12;
            double d10 = matrix3d.m20 * matrix3d2.m20 + matrix3d.m21 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m10 = d5;
            this.m11 = d6;
            this.m12 = d7;
            this.m20 = d8;
            this.m21 = d9;
            this.m22 = d10;
        }
    }

    public final void mulTransposeLeft(Matrix3d matrix3d, Matrix3d matrix3d2) {
        if (this != matrix3d && this != matrix3d2) {
            this.m00 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m10 + matrix3d.m20 * matrix3d2.m20;
            this.m01 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m21;
            this.m02 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m10 * matrix3d2.m12 + matrix3d.m20 * matrix3d2.m22;
            this.m10 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m20;
            this.m11 = matrix3d.m01 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m21;
            this.m12 = matrix3d.m01 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m21 * matrix3d2.m22;
            this.m20 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            this.m21 = matrix3d.m02 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            this.m22 = matrix3d.m02 * matrix3d2.m02 + matrix3d.m12 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
        } else {
            double d2 = matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m10 + matrix3d.m20 * matrix3d2.m20;
            double d3 = matrix3d.m00 * matrix3d2.m01 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m21;
            double d4 = matrix3d.m00 * matrix3d2.m02 + matrix3d.m10 * matrix3d2.m12 + matrix3d.m20 * matrix3d2.m22;
            double d5 = matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m20;
            double d6 = matrix3d.m01 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m21;
            double d7 = matrix3d.m01 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m21 * matrix3d2.m22;
            double d8 = matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20;
            double d9 = matrix3d.m02 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21;
            double d10 = matrix3d.m02 * matrix3d2.m02 + matrix3d.m12 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m10 = d5;
            this.m11 = d6;
            this.m12 = d7;
            this.m20 = d8;
            this.m21 = d9;
            this.m22 = d10;
        }
    }

    public final void normalize() {
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        this.getScaleRotate(dArray2, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public final void normalize(Matrix3d matrix3d) {
        double[] dArray = new double[9];
        double[] dArray2 = new double[9];
        double[] dArray3 = new double[3];
        dArray[0] = matrix3d.m00;
        dArray[1] = matrix3d.m01;
        dArray[2] = matrix3d.m02;
        dArray[3] = matrix3d.m10;
        dArray[4] = matrix3d.m11;
        dArray[5] = matrix3d.m12;
        dArray[6] = matrix3d.m20;
        dArray[7] = matrix3d.m21;
        dArray[8] = matrix3d.m22;
        Matrix3d.compute_svd(dArray, dArray3, dArray2);
        this.m00 = dArray2[0];
        this.m01 = dArray2[1];
        this.m02 = dArray2[2];
        this.m10 = dArray2[3];
        this.m11 = dArray2[4];
        this.m12 = dArray2[5];
        this.m20 = dArray2[6];
        this.m21 = dArray2[7];
        this.m22 = dArray2[8];
    }

    public final void normalizeCP() {
        double d2 = 1.0 / Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
        this.m00 *= d2;
        this.m10 *= d2;
        this.m20 *= d2;
        d2 = 1.0 / Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
        this.m01 *= d2;
        this.m11 *= d2;
        this.m21 *= d2;
        this.m02 = this.m10 * this.m21 - this.m11 * this.m20;
        this.m12 = this.m01 * this.m20 - this.m00 * this.m21;
        this.m22 = this.m00 * this.m11 - this.m01 * this.m10;
    }

    public final void normalizeCP(Matrix3d matrix3d) {
        double d2 = 1.0 / Math.sqrt(matrix3d.m00 * matrix3d.m00 + matrix3d.m10 * matrix3d.m10 + matrix3d.m20 * matrix3d.m20);
        this.m00 = matrix3d.m00 * d2;
        this.m10 = matrix3d.m10 * d2;
        this.m20 = matrix3d.m20 * d2;
        d2 = 1.0 / Math.sqrt(matrix3d.m01 * matrix3d.m01 + matrix3d.m11 * matrix3d.m11 + matrix3d.m21 * matrix3d.m21);
        this.m01 = matrix3d.m01 * d2;
        this.m11 = matrix3d.m11 * d2;
        this.m21 = matrix3d.m21 * d2;
        this.m02 = this.m10 * this.m21 - this.m11 * this.m20;
        this.m12 = this.m01 * this.m20 - this.m00 * this.m21;
        this.m22 = this.m00 * this.m11 - this.m01 * this.m10;
    }

    public boolean equals(Matrix3d matrix3d) {
        try {
            return this.m00 == matrix3d.m00 && this.m01 == matrix3d.m01 && this.m02 == matrix3d.m02 && this.m10 == matrix3d.m10 && this.m11 == matrix3d.m11 && this.m12 == matrix3d.m12 && this.m20 == matrix3d.m20 && this.m21 == matrix3d.m21 && this.m22 == matrix3d.m22;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            Matrix3d matrix3d = (Matrix3d)object;
            return this.m00 == matrix3d.m00 && this.m01 == matrix3d.m01 && this.m02 == matrix3d.m02 && this.m10 == matrix3d.m10 && this.m11 == matrix3d.m11 && this.m12 == matrix3d.m12 && this.m20 == matrix3d.m20 && this.m21 == matrix3d.m21 && this.m22 == matrix3d.m22;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean epsilonEquals(Matrix3d matrix3d, double d2) {
        double d3 = this.m00 - matrix3d.m00;
        double d4 = d3 < 0.0 ? -d3 : d3;
        if (d4 > d2) {
            return false;
        }
        d3 = this.m01 - matrix3d.m01;
        double d5 = d3 < 0.0 ? -d3 : d3;
        if (d5 > d2) {
            return false;
        }
        d3 = this.m02 - matrix3d.m02;
        double d6 = d3 < 0.0 ? -d3 : d3;
        if (d6 > d2) {
            return false;
        }
        d3 = this.m10 - matrix3d.m10;
        double d7 = d3 < 0.0 ? -d3 : d3;
        if (d7 > d2) {
            return false;
        }
        d3 = this.m11 - matrix3d.m11;
        double d8 = d3 < 0.0 ? -d3 : d3;
        if (d8 > d2) {
            return false;
        }
        d3 = this.m12 - matrix3d.m12;
        double d9 = d3 < 0.0 ? -d3 : d3;
        if (d9 > d2) {
            return false;
        }
        d3 = this.m20 - matrix3d.m20;
        double d10 = d3 < 0.0 ? -d3 : d3;
        if (d10 > d2) {
            return false;
        }
        d3 = this.m21 - matrix3d.m21;
        double d11 = d3 < 0.0 ? -d3 : d3;
        if (d11 > d2) {
            return false;
        }
        d3 = this.m22 - matrix3d.m22;
        double d12 = d3 < 0.0 ? -d3 : d3;
        return !(d12 > d2);
    }

    public int hashCode() {
        long l2 = 1L;
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m00);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m01);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m02);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m10);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m11);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m12);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m20);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m21);
        l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.m22);
        return (int)(l2 ^ l2 >> 32);
    }

    public final void setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
    }

    public final void negate(Matrix3d matrix3d) {
        this.m00 = -matrix3d.m00;
        this.m01 = -matrix3d.m01;
        this.m02 = -matrix3d.m02;
        this.m10 = -matrix3d.m10;
        this.m11 = -matrix3d.m11;
        this.m12 = -matrix3d.m12;
        this.m20 = -matrix3d.m20;
        this.m21 = -matrix3d.m21;
        this.m22 = -matrix3d.m22;
    }

    public final void transform(Tuple3d tuple3d) {
        double d2 = this.m00 * tuple3d.x + this.m01 * tuple3d.y + this.m02 * tuple3d.z;
        double d3 = this.m10 * tuple3d.x + this.m11 * tuple3d.y + this.m12 * tuple3d.z;
        double d4 = this.m20 * tuple3d.x + this.m21 * tuple3d.y + this.m22 * tuple3d.z;
        tuple3d.set(d2, d3, d4);
    }

    public final void transform(Tuple3d tuple3d, Tuple3d tuple3d2) {
        double d2 = this.m00 * tuple3d.x + this.m01 * tuple3d.y + this.m02 * tuple3d.z;
        double d3 = this.m10 * tuple3d.x + this.m11 * tuple3d.y + this.m12 * tuple3d.z;
        tuple3d2.z = this.m20 * tuple3d.x + this.m21 * tuple3d.y + this.m22 * tuple3d.z;
        tuple3d2.x = d2;
        tuple3d2.y = d3;
    }

    final void getScaleRotate(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22};
        Matrix3d.compute_svd(dArray3, dArray, dArray2);
    }

    static void compute_svd(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2;
        int n2;
        double[] dArray4 = new double[9];
        double[] dArray5 = new double[9];
        double[] dArray6 = new double[9];
        double[] dArray7 = new double[9];
        double[] dArray8 = dArray6;
        double[] dArray9 = dArray7;
        double[] dArray10 = new double[9];
        double[] dArray11 = new double[3];
        double[] dArray12 = new double[3];
        int n3 = 0;
        for (n2 = 0; n2 < 9; ++n2) {
            dArray10[n2] = dArray[n2];
        }
        if (dArray[3] * dArray[3] < 1.110223024E-16) {
            dArray4[0] = 1.0;
            dArray4[1] = 0.0;
            dArray4[2] = 0.0;
            dArray4[3] = 0.0;
            dArray4[4] = 1.0;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        } else if (dArray[0] * dArray[0] < 1.110223024E-16) {
            dArray8[0] = dArray[0];
            dArray8[1] = dArray[1];
            dArray8[2] = dArray[2];
            dArray[0] = dArray[3];
            dArray[1] = dArray[4];
            dArray[2] = dArray[5];
            dArray[3] = -dArray8[0];
            dArray[4] = -dArray8[1];
            dArray[5] = -dArray8[2];
            dArray4[0] = 0.0;
            dArray4[1] = 1.0;
            dArray4[2] = 0.0;
            dArray4[3] = -1.0;
            dArray4[4] = 0.0;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        } else {
            d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[3] * dArray[3]);
            double d3 = dArray[0] * d2;
            double d4 = dArray[3] * d2;
            dArray8[0] = d3 * dArray[0] + d4 * dArray[3];
            dArray8[1] = d3 * dArray[1] + d4 * dArray[4];
            dArray8[2] = d3 * dArray[2] + d4 * dArray[5];
            dArray[3] = -d4 * dArray[0] + d3 * dArray[3];
            dArray[4] = -d4 * dArray[1] + d3 * dArray[4];
            dArray[5] = -d4 * dArray[2] + d3 * dArray[5];
            dArray[0] = dArray8[0];
            dArray[1] = dArray8[1];
            dArray[2] = dArray8[2];
            dArray4[0] = d3;
            dArray4[1] = d4;
            dArray4[2] = 0.0;
            dArray4[3] = -d4;
            dArray4[4] = d3;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        }
        if (!(dArray[6] * dArray[6] < 1.110223024E-16)) {
            if (dArray[0] * dArray[0] < 1.110223024E-16) {
                dArray8[0] = dArray[0];
                dArray8[1] = dArray[1];
                dArray8[2] = dArray[2];
                dArray[0] = dArray[6];
                dArray[1] = dArray[7];
                dArray[2] = dArray[8];
                dArray[6] = -dArray8[0];
                dArray[7] = -dArray8[1];
                dArray[8] = -dArray8[2];
                dArray8[0] = dArray4[0];
                dArray8[1] = dArray4[1];
                dArray8[2] = dArray4[2];
                dArray4[0] = dArray4[6];
                dArray4[1] = dArray4[7];
                dArray4[2] = dArray4[8];
                dArray4[6] = -dArray8[0];
                dArray4[7] = -dArray8[1];
                dArray4[8] = -dArray8[2];
            } else {
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[6] * dArray[6]);
                double d5 = dArray[0] * d2;
                double d6 = dArray[6] * d2;
                dArray8[0] = d5 * dArray[0] + d6 * dArray[6];
                dArray8[1] = d5 * dArray[1] + d6 * dArray[7];
                dArray8[2] = d5 * dArray[2] + d6 * dArray[8];
                dArray[6] = -d6 * dArray[0] + d5 * dArray[6];
                dArray[7] = -d6 * dArray[1] + d5 * dArray[7];
                dArray[8] = -d6 * dArray[2] + d5 * dArray[8];
                dArray[0] = dArray8[0];
                dArray[1] = dArray8[1];
                dArray[2] = dArray8[2];
                dArray8[0] = d5 * dArray4[0];
                dArray8[1] = d5 * dArray4[1];
                dArray4[2] = d6;
                dArray8[6] = -dArray4[0] * d6;
                dArray8[7] = -dArray4[1] * d6;
                dArray4[8] = d5;
                dArray4[0] = dArray8[0];
                dArray4[1] = dArray8[1];
                dArray4[6] = dArray8[6];
                dArray4[7] = dArray8[7];
            }
        }
        if (dArray[2] * dArray[2] < 1.110223024E-16) {
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = 1.0;
            dArray5[5] = 0.0;
            dArray5[6] = 0.0;
            dArray5[7] = 0.0;
            dArray5[8] = 1.0;
        } else if (dArray[1] * dArray[1] < 1.110223024E-16) {
            dArray8[2] = dArray[2];
            dArray8[5] = dArray[5];
            dArray8[8] = dArray[8];
            dArray[2] = -dArray[1];
            dArray[5] = -dArray[4];
            dArray[8] = -dArray[7];
            dArray[1] = dArray8[2];
            dArray[4] = dArray8[5];
            dArray[7] = dArray8[8];
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = 0.0;
            dArray5[5] = -1.0;
            dArray5[6] = 0.0;
            dArray5[7] = 1.0;
            dArray5[8] = 0.0;
        } else {
            d2 = 1.0 / Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
            double d7 = dArray[1] * d2;
            double d8 = dArray[2] * d2;
            dArray8[1] = d7 * dArray[1] + d8 * dArray[2];
            dArray[2] = -d8 * dArray[1] + d7 * dArray[2];
            dArray[1] = dArray8[1];
            dArray8[4] = d7 * dArray[4] + d8 * dArray[5];
            dArray[5] = -d8 * dArray[4] + d7 * dArray[5];
            dArray[4] = dArray8[4];
            dArray8[7] = d7 * dArray[7] + d8 * dArray[8];
            dArray[8] = -d8 * dArray[7] + d7 * dArray[8];
            dArray[7] = dArray8[7];
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = d7;
            dArray5[5] = -d8;
            dArray5[6] = 0.0;
            dArray5[7] = d8;
            dArray5[8] = d7;
        }
        if (!(dArray[7] * dArray[7] < 1.110223024E-16)) {
            if (dArray[4] * dArray[4] < 1.110223024E-16) {
                dArray8[3] = dArray[3];
                dArray8[4] = dArray[4];
                dArray8[5] = dArray[5];
                dArray[3] = dArray[6];
                dArray[4] = dArray[7];
                dArray[5] = dArray[8];
                dArray[6] = -dArray8[3];
                dArray[7] = -dArray8[4];
                dArray[8] = -dArray8[5];
                dArray8[3] = dArray4[3];
                dArray8[4] = dArray4[4];
                dArray8[5] = dArray4[5];
                dArray4[3] = dArray4[6];
                dArray4[4] = dArray4[7];
                dArray4[5] = dArray4[8];
                dArray4[6] = -dArray8[3];
                dArray4[7] = -dArray8[4];
                dArray4[8] = -dArray8[5];
            } else {
                d2 = 1.0 / Math.sqrt(dArray[4] * dArray[4] + dArray[7] * dArray[7]);
                double d9 = dArray[4] * d2;
                double d10 = dArray[7] * d2;
                dArray8[3] = d9 * dArray[3] + d10 * dArray[6];
                dArray[6] = -d10 * dArray[3] + d9 * dArray[6];
                dArray[3] = dArray8[3];
                dArray8[4] = d9 * dArray[4] + d10 * dArray[7];
                dArray[7] = -d10 * dArray[4] + d9 * dArray[7];
                dArray[4] = dArray8[4];
                dArray8[5] = d9 * dArray[5] + d10 * dArray[8];
                dArray[8] = -d10 * dArray[5] + d9 * dArray[8];
                dArray[5] = dArray8[5];
                dArray8[3] = d9 * dArray4[3] + d10 * dArray4[6];
                dArray4[6] = -d10 * dArray4[3] + d9 * dArray4[6];
                dArray4[3] = dArray8[3];
                dArray8[4] = d9 * dArray4[4] + d10 * dArray4[7];
                dArray4[7] = -d10 * dArray4[4] + d9 * dArray4[7];
                dArray4[4] = dArray8[4];
                dArray8[5] = d9 * dArray4[5] + d10 * dArray4[8];
                dArray4[8] = -d10 * dArray4[5] + d9 * dArray4[8];
                dArray4[5] = dArray8[5];
            }
        }
        dArray9[0] = dArray[0];
        dArray9[1] = dArray[4];
        dArray9[2] = dArray[8];
        dArray11[0] = dArray[1];
        dArray11[1] = dArray[5];
        if (!(dArray11[0] * dArray11[0] < 1.110223024E-16) || !(dArray11[1] * dArray11[1] < 1.110223024E-16)) {
            Matrix3d.compute_qr(dArray9, dArray11, dArray4, dArray5);
        }
        dArray12[0] = dArray9[0];
        dArray12[1] = dArray9[1];
        dArray12[2] = dArray9[2];
        if (Matrix3d.almostEqual(Math.abs(dArray12[0]), 1.0) && Matrix3d.almostEqual(Math.abs(dArray12[1]), 1.0) && Matrix3d.almostEqual(Math.abs(dArray12[2]), 1.0)) {
            for (n2 = 0; n2 < 3; ++n2) {
                if (!(dArray12[n2] < 0.0)) continue;
                ++n3;
            }
            if (n3 == 0 || n3 == 2) {
                dArray2[2] = 1.0;
                dArray2[1] = 1.0;
                dArray2[0] = 1.0;
                for (n2 = 0; n2 < 9; ++n2) {
                    dArray3[n2] = dArray10[n2];
                }
                return;
            }
        }
        Matrix3d.transpose_mat(dArray4, dArray6);
        Matrix3d.transpose_mat(dArray5, dArray7);
        Matrix3d.svdReorder(dArray, dArray6, dArray7, dArray12, dArray3, dArray2);
    }

    static void svdReorder(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[9];
        if (dArray4[0] < 0.0) {
            dArray4[0] = -dArray4[0];
            dArray3[0] = -dArray3[0];
            dArray3[1] = -dArray3[1];
            dArray3[2] = -dArray3[2];
        }
        if (dArray4[1] < 0.0) {
            dArray4[1] = -dArray4[1];
            dArray3[3] = -dArray3[3];
            dArray3[4] = -dArray3[4];
            dArray3[5] = -dArray3[5];
        }
        if (dArray4[2] < 0.0) {
            dArray4[2] = -dArray4[2];
            dArray3[6] = -dArray3[6];
            dArray3[7] = -dArray3[7];
            dArray3[8] = -dArray3[8];
        }
        Matrix3d.mat_mul(dArray2, dArray3, dArray8);
        if (Matrix3d.almostEqual(Math.abs(dArray4[0]), Math.abs(dArray4[1])) && Matrix3d.almostEqual(Math.abs(dArray4[1]), Math.abs(dArray4[2]))) {
            int n2;
            for (n2 = 0; n2 < 9; ++n2) {
                dArray5[n2] = dArray8[n2];
            }
            for (n2 = 0; n2 < 3; ++n2) {
                dArray6[n2] = dArray4[n2];
            }
        } else {
            int n3;
            int n4;
            int n5;
            if (dArray4[0] > dArray4[1]) {
                if (dArray4[0] > dArray4[2]) {
                    if (dArray4[2] > dArray4[1]) {
                        nArray[0] = 0;
                        nArray[1] = 2;
                        nArray[2] = 1;
                    } else {
                        nArray[0] = 0;
                        nArray[1] = 1;
                        nArray[2] = 2;
                    }
                } else {
                    nArray[0] = 2;
                    nArray[1] = 0;
                    nArray[2] = 1;
                }
            } else if (dArray4[1] > dArray4[2]) {
                if (dArray4[2] > dArray4[0]) {
                    nArray[0] = 1;
                    nArray[1] = 2;
                    nArray[2] = 0;
                } else {
                    nArray[0] = 1;
                    nArray[1] = 0;
                    nArray[2] = 2;
                }
            } else {
                nArray[0] = 2;
                nArray[1] = 1;
                nArray[2] = 0;
            }
            dArray7[0] = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
            dArray7[1] = dArray[3] * dArray[3] + dArray[4] * dArray[4] + dArray[5] * dArray[5];
            dArray7[2] = dArray[6] * dArray[6] + dArray[7] * dArray[7] + dArray[8] * dArray[8];
            if (dArray7[0] > dArray7[1]) {
                if (dArray7[0] > dArray7[2]) {
                    if (dArray7[2] > dArray7[1]) {
                        n5 = 0;
                        n4 = 1;
                        n3 = 2;
                    } else {
                        n5 = 0;
                        n3 = 1;
                        n4 = 2;
                    }
                } else {
                    n4 = 0;
                    n5 = 1;
                    n3 = 2;
                }
            } else if (dArray7[1] > dArray7[2]) {
                if (dArray7[2] > dArray7[0]) {
                    n3 = 0;
                    n4 = 1;
                    n5 = 2;
                } else {
                    n3 = 0;
                    n5 = 1;
                    n4 = 2;
                }
            } else {
                n4 = 0;
                n3 = 1;
                n5 = 2;
            }
            int n6 = nArray[n5];
            dArray6[0] = dArray4[n6];
            n6 = nArray[n3];
            dArray6[1] = dArray4[n6];
            n6 = nArray[n4];
            dArray6[2] = dArray4[n6];
            n6 = nArray[n5];
            dArray5[0] = dArray8[n6];
            n6 = nArray[n5] + 3;
            dArray5[3] = dArray8[n6];
            n6 = nArray[n5] + 6;
            dArray5[6] = dArray8[n6];
            n6 = nArray[n3];
            dArray5[1] = dArray8[n6];
            n6 = nArray[n3] + 3;
            dArray5[4] = dArray8[n6];
            n6 = nArray[n3] + 6;
            dArray5[7] = dArray8[n6];
            n6 = nArray[n4];
            dArray5[2] = dArray8[n6];
            n6 = nArray[n4] + 3;
            dArray5[5] = dArray8[n6];
            n6 = nArray[n4] + 6;
            dArray5[8] = dArray8[n6];
        }
    }

    static int compute_qr(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d2;
        double d3;
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        double[] dArray7 = new double[2];
        double[] dArray8 = new double[2];
        double[] dArray9 = new double[9];
        double d4 = 1.0;
        double d5 = -1.0;
        boolean bl = false;
        int n2 = 1;
        if (Math.abs(dArray2[1]) < 4.89E-15 || Math.abs(dArray2[0]) < 4.89E-15) {
            bl = true;
        }
        for (int i2 = 0; i2 < 10 && !bl; ++i2) {
            double d6 = Matrix3d.compute_shift(dArray[1], dArray2[1], dArray[2]);
            double d7 = (Math.abs(dArray[0]) - d6) * (Matrix3d.d_sign(d4, dArray[0]) + d6 / dArray[0]);
            double d8 = dArray2[0];
            double d9 = Matrix3d.compute_rot(d7, d8, dArray8, dArray6, 0, n2);
            d7 = dArray6[0] * dArray[0] + dArray8[0] * dArray2[0];
            dArray2[0] = dArray6[0] * dArray2[0] - dArray8[0] * dArray[0];
            d8 = dArray8[0] * dArray[1];
            dArray[1] = dArray6[0] * dArray[1];
            d9 = Matrix3d.compute_rot(d7, d8, dArray7, dArray5, 0, n2);
            n2 = 0;
            dArray[0] = d9;
            d7 = dArray5[0] * dArray2[0] + dArray7[0] * dArray[1];
            dArray[1] = dArray5[0] * dArray[1] - dArray7[0] * dArray2[0];
            d8 = dArray7[0] * dArray2[1];
            dArray2[1] = dArray5[0] * dArray2[1];
            dArray2[0] = d9 = Matrix3d.compute_rot(d7, d8, dArray8, dArray6, 1, n2);
            d7 = dArray6[1] * dArray[1] + dArray8[1] * dArray2[1];
            dArray2[1] = dArray6[1] * dArray2[1] - dArray8[1] * dArray[1];
            d8 = dArray8[1] * dArray[2];
            dArray[2] = dArray6[1] * dArray[2];
            dArray[1] = d9 = Matrix3d.compute_rot(d7, d8, dArray7, dArray5, 1, n2);
            d7 = dArray5[1] * dArray2[1] + dArray7[1] * dArray[2];
            dArray[2] = dArray5[1] * dArray[2] - dArray7[1] * dArray2[1];
            dArray2[1] = d7;
            d3 = dArray3[0];
            dArray3[0] = dArray5[0] * d3 + dArray7[0] * dArray3[3];
            dArray3[3] = -dArray7[0] * d3 + dArray5[0] * dArray3[3];
            d3 = dArray3[1];
            dArray3[1] = dArray5[0] * d3 + dArray7[0] * dArray3[4];
            dArray3[4] = -dArray7[0] * d3 + dArray5[0] * dArray3[4];
            d3 = dArray3[2];
            dArray3[2] = dArray5[0] * d3 + dArray7[0] * dArray3[5];
            dArray3[5] = -dArray7[0] * d3 + dArray5[0] * dArray3[5];
            d3 = dArray3[3];
            dArray3[3] = dArray5[1] * d3 + dArray7[1] * dArray3[6];
            dArray3[6] = -dArray7[1] * d3 + dArray5[1] * dArray3[6];
            d3 = dArray3[4];
            dArray3[4] = dArray5[1] * d3 + dArray7[1] * dArray3[7];
            dArray3[7] = -dArray7[1] * d3 + dArray5[1] * dArray3[7];
            d3 = dArray3[5];
            dArray3[5] = dArray5[1] * d3 + dArray7[1] * dArray3[8];
            dArray3[8] = -dArray7[1] * d3 + dArray5[1] * dArray3[8];
            d2 = dArray4[0];
            dArray4[0] = dArray6[0] * d2 + dArray8[0] * dArray4[1];
            dArray4[1] = -dArray8[0] * d2 + dArray6[0] * dArray4[1];
            d2 = dArray4[3];
            dArray4[3] = dArray6[0] * d2 + dArray8[0] * dArray4[4];
            dArray4[4] = -dArray8[0] * d2 + dArray6[0] * dArray4[4];
            d2 = dArray4[6];
            dArray4[6] = dArray6[0] * d2 + dArray8[0] * dArray4[7];
            dArray4[7] = -dArray8[0] * d2 + dArray6[0] * dArray4[7];
            d2 = dArray4[1];
            dArray4[1] = dArray6[1] * d2 + dArray8[1] * dArray4[2];
            dArray4[2] = -dArray8[1] * d2 + dArray6[1] * dArray4[2];
            d2 = dArray4[4];
            dArray4[4] = dArray6[1] * d2 + dArray8[1] * dArray4[5];
            dArray4[5] = -dArray8[1] * d2 + dArray6[1] * dArray4[5];
            d2 = dArray4[7];
            dArray4[7] = dArray6[1] * d2 + dArray8[1] * dArray4[8];
            dArray4[8] = -dArray8[1] * d2 + dArray6[1] * dArray4[8];
            dArray9[0] = dArray[0];
            dArray9[1] = dArray2[0];
            dArray9[2] = 0.0;
            dArray9[3] = 0.0;
            dArray9[4] = dArray[1];
            dArray9[5] = dArray2[1];
            dArray9[6] = 0.0;
            dArray9[7] = 0.0;
            dArray9[8] = dArray[2];
            if (!(Math.abs(dArray2[1]) < 4.89E-15) && !(Math.abs(dArray2[0]) < 4.89E-15)) continue;
            bl = true;
        }
        if (Math.abs(dArray2[1]) < 4.89E-15) {
            Matrix3d.compute_2X2(dArray[0], dArray2[0], dArray[1], dArray, dArray7, dArray5, dArray8, dArray6, 0);
            d3 = dArray3[0];
            dArray3[0] = dArray5[0] * d3 + dArray7[0] * dArray3[3];
            dArray3[3] = -dArray7[0] * d3 + dArray5[0] * dArray3[3];
            d3 = dArray3[1];
            dArray3[1] = dArray5[0] * d3 + dArray7[0] * dArray3[4];
            dArray3[4] = -dArray7[0] * d3 + dArray5[0] * dArray3[4];
            d3 = dArray3[2];
            dArray3[2] = dArray5[0] * d3 + dArray7[0] * dArray3[5];
            dArray3[5] = -dArray7[0] * d3 + dArray5[0] * dArray3[5];
            d2 = dArray4[0];
            dArray4[0] = dArray6[0] * d2 + dArray8[0] * dArray4[1];
            dArray4[1] = -dArray8[0] * d2 + dArray6[0] * dArray4[1];
            d2 = dArray4[3];
            dArray4[3] = dArray6[0] * d2 + dArray8[0] * dArray4[4];
            dArray4[4] = -dArray8[0] * d2 + dArray6[0] * dArray4[4];
            d2 = dArray4[6];
            dArray4[6] = dArray6[0] * d2 + dArray8[0] * dArray4[7];
            dArray4[7] = -dArray8[0] * d2 + dArray6[0] * dArray4[7];
        } else {
            Matrix3d.compute_2X2(dArray[1], dArray2[1], dArray[2], dArray, dArray7, dArray5, dArray8, dArray6, 1);
            d3 = dArray3[3];
            dArray3[3] = dArray5[0] * d3 + dArray7[0] * dArray3[6];
            dArray3[6] = -dArray7[0] * d3 + dArray5[0] * dArray3[6];
            d3 = dArray3[4];
            dArray3[4] = dArray5[0] * d3 + dArray7[0] * dArray3[7];
            dArray3[7] = -dArray7[0] * d3 + dArray5[0] * dArray3[7];
            d3 = dArray3[5];
            dArray3[5] = dArray5[0] * d3 + dArray7[0] * dArray3[8];
            dArray3[8] = -dArray7[0] * d3 + dArray5[0] * dArray3[8];
            d2 = dArray4[1];
            dArray4[1] = dArray6[0] * d2 + dArray8[0] * dArray4[2];
            dArray4[2] = -dArray8[0] * d2 + dArray6[0] * dArray4[2];
            d2 = dArray4[4];
            dArray4[4] = dArray6[0] * d2 + dArray8[0] * dArray4[5];
            dArray4[5] = -dArray8[0] * d2 + dArray6[0] * dArray4[5];
            d2 = dArray4[7];
            dArray4[7] = dArray6[0] * d2 + dArray8[0] * dArray4[8];
            dArray4[8] = -dArray8[0] * d2 + dArray6[0] * dArray4[8];
        }
        return 0;
    }

    static double max(double d2, double d3) {
        if (d2 > d3) {
            return d2;
        }
        return d3;
    }

    static double min(double d2, double d3) {
        if (d2 < d3) {
            return d2;
        }
        return d3;
    }

    static double d_sign(double d2, double d3) {
        double d4 = d2 >= 0.0 ? d2 : -d2;
        return d3 >= 0.0 ? d4 : -d4;
    }

    static double compute_shift(double d2, double d3, double d4) {
        double d5;
        double d6 = Math.abs(d2);
        double d7 = Math.abs(d3);
        double d8 = Math.abs(d4);
        double d9 = Matrix3d.min(d6, d8);
        double d10 = Matrix3d.max(d6, d8);
        if (d9 == 0.0) {
            d5 = 0.0;
            if (d10 != 0.0) {
                double d11 = Matrix3d.min(d10, d7) / Matrix3d.max(d10, d7);
            }
        } else if (d7 < d10) {
            double d12 = d9 / d10 + 1.0;
            double d13 = (d10 - d9) / d10;
            double d14 = d7 / d10;
            double d15 = d14 * d14;
            double d16 = 2.0 / (Math.sqrt(d12 * d12 + d15) + Math.sqrt(d13 * d13 + d15));
            d5 = d9 * d16;
        } else {
            double d17 = d10 / d7;
            if (d17 == 0.0) {
                d5 = d9 * d10 / d7;
            } else {
                double d18 = d9 / d10 + 1.0;
                double d19 = (d10 - d9) / d10;
                double d20 = d18 * d17;
                double d21 = d19 * d17;
                double d22 = 1.0 / (Math.sqrt(d20 * d20 + 1.0) + Math.sqrt(d21 * d21 + 1.0));
                d5 = d9 * d22 * d17;
                d5 += d5;
            }
        }
        return d5;
    }

    static int compute_2X2(double d2, double d3, double d4, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n2) {
        double d5;
        double d6;
        double d7 = 2.0;
        double d8 = 1.0;
        double d9 = dArray[0];
        double d10 = dArray[1];
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = d2;
        double d17 = Math.abs(d16);
        double d18 = d4;
        double d19 = Math.abs(d4);
        int n3 = 1;
        boolean bl = d19 > d17;
        if (bl) {
            n3 = 3;
            double d20 = d16;
            d16 = d18;
            d18 = d20;
            d20 = d17;
            d17 = d19;
            d19 = d20;
        }
        if ((d6 = Math.abs(d5 = d3)) == 0.0) {
            dArray[1] = d19;
            dArray[0] = d17;
            d11 = 1.0;
            d12 = 1.0;
            d13 = 0.0;
            d14 = 0.0;
        } else {
            boolean bl2 = true;
            if (d6 > d17) {
                n3 = 2;
                if (d17 / d6 < 1.110223024E-16) {
                    bl2 = false;
                    d9 = d6;
                    d10 = d19 > 1.0 ? d17 / (d6 / d19) : d17 / d6 * d19;
                    d11 = 1.0;
                    d13 = d18 / d5;
                    d14 = 1.0;
                    d12 = d16 / d5;
                }
            }
            if (bl2) {
                double d21 = d17 - d19;
                double d22 = d21 == d17 ? 1.0 : d21 / d17;
                double d23 = d5 / d16;
                double d24 = 2.0 - d22;
                double d25 = d23 * d23;
                double d26 = d24 * d24;
                double d27 = Math.sqrt(d26 + d25);
                double d28 = d22 == 0.0 ? Math.abs(d23) : Math.sqrt(d22 * d22 + d25);
                double d29 = (d27 + d28) * 0.5;
                if (d6 > d17) {
                    n3 = 2;
                    if (d17 / d6 < 1.110223024E-16) {
                        bl2 = false;
                        d9 = d6;
                        d10 = d19 > 1.0 ? d17 / (d6 / d19) : d17 / d6 * d19;
                        d11 = 1.0;
                        d13 = d18 / d5;
                        d14 = 1.0;
                        d12 = d16 / d5;
                    }
                }
                if (bl2) {
                    d21 = d17 - d19;
                    d22 = d21 == d17 ? 1.0 : d21 / d17;
                    d23 = d5 / d16;
                    d24 = 2.0 - d22;
                    d25 = d23 * d23;
                    d26 = d24 * d24;
                    d27 = Math.sqrt(d26 + d25);
                    d28 = d22 == 0.0 ? Math.abs(d23) : Math.sqrt(d22 * d22 + d25);
                    d29 = (d27 + d28) * 0.5;
                    d10 = d19 / d29;
                    d9 = d17 * d29;
                    d24 = d25 == 0.0 ? (d22 == 0.0 ? Matrix3d.d_sign(d7, d16) * Matrix3d.d_sign(d8, d5) : d5 / Matrix3d.d_sign(d21, d16) + d23 / d24) : (d23 / (d27 + d24) + d23 / (d28 + d22)) * (d29 + 1.0);
                    d22 = Math.sqrt(d24 * d24 + 4.0);
                    d12 = 2.0 / d22;
                    d14 = d24 / d22;
                    d11 = (d12 + d14 * d23) / d29;
                    d13 = d18 / d16 * d14 / d29;
                }
            }
            if (bl) {
                dArray3[0] = d14;
                dArray2[0] = d12;
                dArray5[0] = d13;
                dArray4[0] = d11;
            } else {
                dArray3[0] = d11;
                dArray2[0] = d13;
                dArray5[0] = d12;
                dArray4[0] = d14;
            }
            if (n3 == 1) {
                d15 = Matrix3d.d_sign(d8, dArray5[0]) * Matrix3d.d_sign(d8, dArray3[0]) * Matrix3d.d_sign(d8, d2);
            }
            if (n3 == 2) {
                d15 = Matrix3d.d_sign(d8, dArray4[0]) * Matrix3d.d_sign(d8, dArray3[0]) * Matrix3d.d_sign(d8, d3);
            }
            if (n3 == 3) {
                d15 = Matrix3d.d_sign(d8, dArray4[0]) * Matrix3d.d_sign(d8, dArray2[0]) * Matrix3d.d_sign(d8, d4);
            }
            dArray[n2] = Matrix3d.d_sign(d9, d15);
            double d30 = d15 * Matrix3d.d_sign(d8, d2) * Matrix3d.d_sign(d8, d4);
            dArray[n2 + 1] = Matrix3d.d_sign(d10, d30);
        }
        return 0;
    }

    static double compute_rot(double d2, double d3, double[] dArray, double[] dArray2, int n2, int n3) {
        double d4;
        double d5;
        double d6;
        if (d3 == 0.0) {
            d6 = 1.0;
            d5 = 0.0;
            d4 = d2;
        } else if (d2 == 0.0) {
            d6 = 0.0;
            d5 = 1.0;
            d4 = d3;
        } else {
            double d7 = d2;
            double d8 = d3;
            double d9 = Matrix3d.max(Math.abs(d7), Math.abs(d8));
            if (d9 >= 4.994797680505588E145) {
                int n4 = 0;
                while (d9 >= 4.994797680505588E145) {
                    ++n4;
                    d9 = Matrix3d.max(Math.abs(d7 *= 2.002083095183101E-146), Math.abs(d8 *= 2.002083095183101E-146));
                }
                d4 = Math.sqrt(d7 * d7 + d8 * d8);
                d6 = d7 / d4;
                d5 = d8 / d4;
                int n5 = n4;
                for (int i2 = 1; i2 <= n4; ++i2) {
                    d4 *= 4.994797680505588E145;
                }
            } else if (d9 <= 2.002083095183101E-146) {
                int n6 = 0;
                while (d9 <= 2.002083095183101E-146) {
                    ++n6;
                    d9 = Matrix3d.max(Math.abs(d7 *= 4.994797680505588E145), Math.abs(d8 *= 4.994797680505588E145));
                }
                d4 = Math.sqrt(d7 * d7 + d8 * d8);
                d6 = d7 / d4;
                d5 = d8 / d4;
                int n7 = n6;
                for (int i3 = 1; i3 <= n6; ++i3) {
                    d4 *= 2.002083095183101E-146;
                }
            } else {
                d4 = Math.sqrt(d7 * d7 + d8 * d8);
                d6 = d7 / d4;
                d5 = d8 / d4;
            }
            if (Math.abs(d2) > Math.abs(d3) && d6 < 0.0) {
                d6 = -d6;
                d5 = -d5;
                d4 = -d4;
            }
        }
        dArray[n2] = d5;
        dArray2[n2] = d6;
        return d4;
    }

    static void print_mat(double[] dArray) {
        for (int i2 = 0; i2 < 3; ++i2) {
            System.out.println(dArray[i2 * 3 + 0] + " " + dArray[i2 * 3 + 1] + " " + dArray[i2 * 3 + 2] + "\n");
        }
    }

    static void print_det(double[] dArray) {
        double d2 = dArray[0] * dArray[4] * dArray[8] + dArray[1] * dArray[5] * dArray[6] + dArray[2] * dArray[3] * dArray[7] - dArray[2] * dArray[4] * dArray[6] - dArray[0] * dArray[5] * dArray[7] - dArray[1] * dArray[3] * dArray[8];
        System.out.println("det= " + d2);
    }

    static void mat_mul(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[]{dArray[0] * dArray2[0] + dArray[1] * dArray2[3] + dArray[2] * dArray2[6], dArray[0] * dArray2[1] + dArray[1] * dArray2[4] + dArray[2] * dArray2[7], dArray[0] * dArray2[2] + dArray[1] * dArray2[5] + dArray[2] * dArray2[8], dArray[3] * dArray2[0] + dArray[4] * dArray2[3] + dArray[5] * dArray2[6], dArray[3] * dArray2[1] + dArray[4] * dArray2[4] + dArray[5] * dArray2[7], dArray[3] * dArray2[2] + dArray[4] * dArray2[5] + dArray[5] * dArray2[8], dArray[6] * dArray2[0] + dArray[7] * dArray2[3] + dArray[8] * dArray2[6], dArray[6] * dArray2[1] + dArray[7] * dArray2[4] + dArray[8] * dArray2[7], dArray[6] * dArray2[2] + dArray[7] * dArray2[5] + dArray[8] * dArray2[8]};
        for (int i2 = 0; i2 < 9; ++i2) {
            dArray3[i2] = dArray4[i2];
        }
    }

    static void transpose_mat(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[3];
        dArray2[2] = dArray[6];
        dArray2[3] = dArray[1];
        dArray2[4] = dArray[4];
        dArray2[5] = dArray[7];
        dArray2[6] = dArray[2];
        dArray2[7] = dArray[5];
        dArray2[8] = dArray[8];
    }

    static double max3(double[] dArray) {
        if (dArray[0] > dArray[1]) {
            if (dArray[0] > dArray[2]) {
                return dArray[0];
            }
            return dArray[2];
        }
        if (dArray[1] > dArray[2]) {
            return dArray[1];
        }
        return dArray[2];
    }

    private static final boolean almostEqual(double d2, double d3) {
        double d4;
        double d5;
        if (d2 == d3) {
            return true;
        }
        double d6 = Math.abs(d2 - d3);
        double d7 = Math.abs(d2);
        double d8 = d5 = d7 >= (d4 = Math.abs(d3)) ? d7 : d4;
        if (d6 < 1.0E-6) {
            return true;
        }
        return d6 / d5 < 1.0E-4;
    }

    public Object clone() {
        Matrix3d matrix3d = null;
        try {
            matrix3d = (Matrix3d)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return matrix3d;
    }
}

