/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GMatrix;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.VecMathI18N;
import javax.vecmath.VecMathUtil;

public class GVector
implements Serializable,
Cloneable {
    private int length;
    double[] values;
    static final long serialVersionUID = 1398850036893875112L;

    public GVector(int n2) {
        this.length = n2;
        this.values = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values[i2] = 0.0;
        }
    }

    public GVector(double[] dArray) {
        this.length = dArray.length;
        this.values = new double[dArray.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = dArray[i2];
        }
    }

    public GVector(GVector gVector) {
        this.values = new double[gVector.length];
        this.length = gVector.length;
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = gVector.values[i2];
        }
    }

    public GVector(Tuple2f tuple2f) {
        this.values = new double[2];
        this.values[0] = tuple2f.x;
        this.values[1] = tuple2f.y;
        this.length = 2;
    }

    public GVector(Tuple3f tuple3f) {
        this.values = new double[3];
        this.values[0] = tuple3f.x;
        this.values[1] = tuple3f.y;
        this.values[2] = tuple3f.z;
        this.length = 3;
    }

    public GVector(Tuple3d tuple3d) {
        this.values = new double[3];
        this.values[0] = tuple3d.x;
        this.values[1] = tuple3d.y;
        this.values[2] = tuple3d.z;
        this.length = 3;
    }

    public GVector(Tuple4f tuple4f) {
        this.values = new double[4];
        this.values[0] = tuple4f.x;
        this.values[1] = tuple4f.y;
        this.values[2] = tuple4f.z;
        this.values[3] = tuple4f.w;
        this.length = 4;
    }

    public GVector(Tuple4d tuple4d) {
        this.values = new double[4];
        this.values[0] = tuple4d.x;
        this.values[1] = tuple4d.y;
        this.values[2] = tuple4d.z;
        this.values[3] = tuple4d.w;
        this.length = 4;
    }

    public GVector(double[] dArray, int n2) {
        this.length = n2;
        this.values = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values[i2] = dArray[i2];
        }
    }

    public final double norm() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.length; ++i2) {
            d2 += this.values[i2] * this.values[i2];
        }
        return Math.sqrt(d2);
    }

    public final double normSquared() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.length; ++i2) {
            d2 += this.values[i2] * this.values[i2];
        }
        return d2;
    }

    public final void normalize(GVector gVector) {
        int n2;
        double d2 = 0.0;
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector0"));
        }
        for (n2 = 0; n2 < this.length; ++n2) {
            d2 += gVector.values[n2] * gVector.values[n2];
        }
        double d3 = 1.0 / Math.sqrt(d2);
        for (n2 = 0; n2 < this.length; ++n2) {
            this.values[n2] = gVector.values[n2] * d3;
        }
    }

    public final void normalize() {
        int n2;
        double d2 = 0.0;
        for (n2 = 0; n2 < this.length; ++n2) {
            d2 += this.values[n2] * this.values[n2];
        }
        double d3 = 1.0 / Math.sqrt(d2);
        for (n2 = 0; n2 < this.length; ++n2) {
            this.values[n2] = this.values[n2] * d3;
        }
    }

    public final void scale(double d2, GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector1"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = gVector.values[i2] * d2;
        }
    }

    public final void scale(double d2) {
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = this.values[i2] * d2;
        }
    }

    public final void scaleAdd(double d2, GVector gVector, GVector gVector2) {
        if (gVector2.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector2"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector3"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = gVector.values[i2] * d2 + gVector2.values[i2];
        }
    }

    public final void add(GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector4"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            int n2 = i2;
            this.values[n2] = this.values[n2] + gVector.values[i2];
        }
    }

    public final void add(GVector gVector, GVector gVector2) {
        if (gVector.length != gVector2.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector5"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector6"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = gVector.values[i2] + gVector2.values[i2];
        }
    }

    public final void sub(GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector7"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            int n2 = i2;
            this.values[n2] = this.values[n2] - gVector.values[i2];
        }
    }

    public final void sub(GVector gVector, GVector gVector2) {
        if (gVector.length != gVector2.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector8"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector9"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = gVector.values[i2] - gVector2.values[i2];
        }
    }

    public final void mul(GMatrix gMatrix, GVector gVector) {
        if (gMatrix.getNumCol() != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector10"));
        }
        if (this.length != gMatrix.getNumRow()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector11"));
        }
        double[] dArray = gVector != this ? gVector.values : (double[])this.values.clone();
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            this.values[i2] = 0.0;
            for (int i3 = gVector.length - 1; i3 >= 0; --i3) {
                int n2 = i2;
                this.values[n2] = this.values[n2] + gMatrix.values[i2][i3] * dArray[i3];
            }
        }
    }

    public final void mul(GVector gVector, GMatrix gMatrix) {
        if (gMatrix.getNumRow() != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector12"));
        }
        if (this.length != gMatrix.getNumCol()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector13"));
        }
        double[] dArray = gVector != this ? gVector.values : (double[])this.values.clone();
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            this.values[i2] = 0.0;
            for (int i3 = gVector.length - 1; i3 >= 0; --i3) {
                int n2 = i2;
                this.values[n2] = this.values[n2] + gMatrix.values[i3][i2] * dArray[i3];
            }
        }
    }

    public final void negate() {
        int n2 = this.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            this.values[n3] = this.values[n3] * -1.0;
        }
    }

    public final void zero() {
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = 0.0;
        }
    }

    public final void setSize(int n2) {
        double[] dArray = new double[n2];
        int n3 = this.length < n2 ? this.length : n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = this.values[i2];
        }
        this.length = n2;
        this.values = dArray;
    }

    public final void set(double[] dArray) {
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            this.values[i2] = dArray[i2];
        }
    }

    public final void set(GVector gVector) {
        if (this.length < gVector.length) {
            this.length = gVector.length;
            this.values = new double[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.values[i2] = gVector.values[i2];
            }
        } else {
            int n2;
            for (n2 = 0; n2 < gVector.length; ++n2) {
                this.values[n2] = gVector.values[n2];
            }
            for (n2 = gVector.length; n2 < this.length; ++n2) {
                this.values[n2] = 0.0;
            }
        }
    }

    public final void set(Tuple2f tuple2f) {
        if (this.length < 2) {
            this.length = 2;
            this.values = new double[2];
        }
        this.values[0] = tuple2f.x;
        this.values[1] = tuple2f.y;
        for (int i2 = 2; i2 < this.length; ++i2) {
            this.values[i2] = 0.0;
        }
    }

    public final void set(Tuple3f tuple3f) {
        if (this.length < 3) {
            this.length = 3;
            this.values = new double[3];
        }
        this.values[0] = tuple3f.x;
        this.values[1] = tuple3f.y;
        this.values[2] = tuple3f.z;
        for (int i2 = 3; i2 < this.length; ++i2) {
            this.values[i2] = 0.0;
        }
    }

    public final void set(Tuple3d tuple3d) {
        if (this.length < 3) {
            this.length = 3;
            this.values = new double[3];
        }
        this.values[0] = tuple3d.x;
        this.values[1] = tuple3d.y;
        this.values[2] = tuple3d.z;
        for (int i2 = 3; i2 < this.length; ++i2) {
            this.values[i2] = 0.0;
        }
    }

    public final void set(Tuple4f tuple4f) {
        if (this.length < 4) {
            this.length = 4;
            this.values = new double[4];
        }
        this.values[0] = tuple4f.x;
        this.values[1] = tuple4f.y;
        this.values[2] = tuple4f.z;
        this.values[3] = tuple4f.w;
        for (int i2 = 4; i2 < this.length; ++i2) {
            this.values[i2] = 0.0;
        }
    }

    public final void set(Tuple4d tuple4d) {
        if (this.length < 4) {
            this.length = 4;
            this.values = new double[4];
        }
        this.values[0] = tuple4d.x;
        this.values[1] = tuple4d.y;
        this.values[2] = tuple4d.z;
        this.values[3] = tuple4d.w;
        for (int i2 = 4; i2 < this.length; ++i2) {
            this.values[i2] = 0.0;
        }
    }

    public final int getSize() {
        return this.values.length;
    }

    public final double getElement(int n2) {
        return this.values[n2];
    }

    public final void setElement(int n2, double d2) {
        this.values[n2] = d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.length * 8);
        for (int i2 = 0; i2 < this.length; ++i2) {
            stringBuffer.append(this.values[i2]).append(" ");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        long l2 = 1L;
        for (int i2 = 0; i2 < this.length; ++i2) {
            l2 = 31L * l2 + VecMathUtil.doubleToLongBits(this.values[i2]);
        }
        return (int)(l2 ^ l2 >> 32);
    }

    public boolean equals(GVector gVector) {
        try {
            if (this.length != gVector.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.values[i2] == gVector.values[i2]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            GVector gVector = (GVector)object;
            if (this.length != gVector.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.values[i2] == gVector.values[i2]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean epsilonEquals(GVector gVector, double d2) {
        if (this.length != gVector.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            double d3 = this.values[i2] - gVector.values[i2];
            double d4 = d3 < 0.0 ? -d3 : d3;
            if (!(d4 > d2)) continue;
            return false;
        }
        return true;
    }

    public final double dot(GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector14"));
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.length; ++i2) {
            d2 += this.values[i2] * gVector.values[i2];
        }
        return d2;
    }

    public final void SVDBackSolve(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3, GVector gVector) {
        if (gMatrix.nRow != gVector.getSize() || gMatrix.nRow != gMatrix.nCol || gMatrix.nRow != gMatrix2.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector15"));
        }
        if (gMatrix2.nCol != this.values.length || gMatrix2.nCol != gMatrix3.nCol || gMatrix2.nCol != gMatrix3.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector23"));
        }
        GMatrix gMatrix4 = new GMatrix(gMatrix.nRow, gMatrix2.nCol);
        gMatrix4.mul(gMatrix, gMatrix3);
        gMatrix4.mulTransposeRight(gMatrix, gMatrix2);
        gMatrix4.invert();
        this.mul(gMatrix4, gVector);
    }

    public final void LUDBackSolve(GMatrix gMatrix, GVector gVector, GVector gVector2) {
        int n2;
        int n3 = gMatrix.nRow * gMatrix.nCol;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int[] nArray = new int[gVector.getSize()];
        if (gMatrix.nRow != gVector.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector16"));
        }
        if (gMatrix.nRow != gVector2.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector24"));
        }
        if (gMatrix.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector25"));
        }
        for (n2 = 0; n2 < gMatrix.nRow; ++n2) {
            for (int i2 = 0; i2 < gMatrix.nCol; ++i2) {
                dArray[n2 * gMatrix.nCol + i2] = gMatrix.values[n2][i2];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = 0.0;
        }
        for (n2 = 0; n2 < gMatrix.nRow; ++n2) {
            dArray2[n2 * gMatrix.nCol] = gVector.values[n2];
        }
        for (n2 = 0; n2 < gMatrix.nCol; ++n2) {
            nArray[n2] = (int)gVector2.values[n2];
        }
        GMatrix.luBacksubstitution(gMatrix.nRow, dArray, nArray, dArray2);
        for (n2 = 0; n2 < gMatrix.nRow; ++n2) {
            this.values[n2] = dArray2[n2 * gMatrix.nCol];
        }
    }

    public final double angle(GVector gVector) {
        return Math.acos(this.dot(gVector) / (this.norm() * gVector.norm()));
    }

    public final void interpolate(GVector gVector, GVector gVector2, float f2) {
        this.interpolate(gVector, gVector2, (double)f2);
    }

    public final void interpolate(GVector gVector, float f2) {
        this.interpolate(gVector, (double)f2);
    }

    public final void interpolate(GVector gVector, GVector gVector2, double d2) {
        if (gVector2.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector20"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector21"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = (1.0 - d2) * gVector.values[i2] + d2 * gVector2.values[i2];
        }
    }

    public final void interpolate(GVector gVector, double d2) {
        if (gVector.length != this.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector22"));
        }
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.values[i2] = (1.0 - d2) * this.values[i2] + d2 * gVector.values[i2];
        }
    }

    public Object clone() {
        GVector gVector = null;
        try {
            gVector = (GVector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        gVector.values = new double[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            gVector.values[i2] = this.values[i2];
        }
        return gVector;
    }
}

