/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private volatile Vector transportListeners = null;

    public Transport(Session session, URLName urlname) {
        super(session, urlname);
    }

    public static void send(Message msg) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, msg.getAllRecipients(), null, null);
    }

    public static void send(Message msg, Address[] addresses) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, addresses, null, null);
    }

    public static void send(Message msg, String user, String password) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, msg.getAllRecipients(), user, password);
    }

    public static void send(Message msg, Address[] addresses, String user, String password) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, addresses, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void send0(Message msg, Address[] addresses, String user, String password) throws MessagingException {
        Session s;
        if (addresses == null) throw new SendFailedException("No recipient addresses");
        if (addresses.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Hashtable protocols = new Hashtable();
        Vector<Object> invalid = new Vector<Object>();
        Vector<Address> validSent = new Vector<Address>();
        Vector<Address> validUnsent = new Vector<Address>();
        for (int i2 = 0; i2 < addresses.length; ++i2) {
            if (protocols.containsKey(addresses[i2].getType())) {
                Vector v = (Vector)protocols.get(addresses[i2].getType());
                v.addElement(addresses[i2]);
                continue;
            }
            Vector<Address> w = new Vector<Address>();
            w.addElement(addresses[i2]);
            protocols.put(addresses[i2].getType(), w);
        }
        int dsize = protocols.size();
        if (dsize == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Session session = s = msg.session != null ? msg.session : Session.getDefaultInstance(System.getProperties(), null);
        if (dsize == 1) {
            Transport transport = s.getTransport(addresses[0]);
            try {
                if (user != null) {
                    transport.connect(user, password);
                } else {
                    transport.connect();
                }
                transport.sendMessage(msg, addresses);
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
            return;
        }
        MessagingException chainedEx = null;
        boolean sendFailed = false;
        Enumeration e2 = protocols.elements();
        while (e2.hasMoreElements()) {
            Object var21_28;
            Vector v = (Vector)e2.nextElement();
            Object[] protaddresses = new Address[v.size()];
            v.copyInto(protaddresses);
            Transport transport = s.getTransport((Address)protaddresses[0]);
            if (transport == null) {
                for (int j2 = 0; j2 < protaddresses.length; ++j2) {
                    invalid.addElement(protaddresses[j2]);
                }
                continue;
            }
            try {
                try {
                    transport.connect();
                    transport.sendMessage(msg, (Address[])protaddresses);
                }
                catch (SendFailedException sex) {
                    Address[] c2;
                    sendFailed = true;
                    if (chainedEx == null) {
                        chainedEx = sex;
                    } else {
                        chainedEx.setNextException(sex);
                    }
                    Address[] a2 = sex.getInvalidAddresses();
                    if (a2 != null) {
                        for (int j3 = 0; j3 < a2.length; ++j3) {
                            invalid.addElement(a2[j3]);
                        }
                    }
                    if ((a2 = sex.getValidSentAddresses()) != null) {
                        for (int k2 = 0; k2 < a2.length; ++k2) {
                            validSent.addElement(a2[k2]);
                        }
                    }
                    if ((c2 = sex.getValidUnsentAddresses()) != null) {
                        for (int l2 = 0; l2 < c2.length; ++l2) {
                            validUnsent.addElement(c2[l2]);
                        }
                    }
                    var21_28 = null;
                    transport.close();
                    continue;
                }
                catch (MessagingException mex) {
                    sendFailed = true;
                    if (chainedEx == null) {
                        chainedEx = mex;
                    } else {
                        chainedEx.setNextException(mex);
                    }
                    var21_28 = null;
                    transport.close();
                    continue;
                }
                var21_28 = null;
            }
            catch (Throwable throwable) {
                var21_28 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
        }
        if (!sendFailed && invalid.size() == 0) {
            if (validUnsent.size() == 0) return;
        }
        Object[] a3 = null;
        Object[] b2 = null;
        Object[] c3 = null;
        if (validSent.size() > 0) {
            a3 = new Address[validSent.size()];
            validSent.copyInto(a3);
        }
        if (validUnsent.size() > 0) {
            b2 = new Address[validUnsent.size()];
            validUnsent.copyInto(b2);
        }
        if (invalid.size() <= 0) throw new SendFailedException("Sending failed", chainedEx, (Address[])a3, (Address[])b2, (Address[])c3);
        c3 = new Address[invalid.size()];
        invalid.copyInto(c3);
        throw new SendFailedException("Sending failed", chainedEx, (Address[])a3, (Address[])b2, (Address[])c3);
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    public synchronized void addTransportListener(TransportListener l2) {
        if (this.transportListeners == null) {
            this.transportListeners = new Vector();
        }
        this.transportListeners.addElement(l2);
    }

    public synchronized void removeTransportListener(TransportListener l2) {
        if (this.transportListeners != null) {
            this.transportListeners.removeElement(l2);
        }
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message msg) {
        if (this.transportListeners == null) {
            return;
        }
        TransportEvent e2 = new TransportEvent(this, type, validSent, validUnsent, invalid, msg);
        this.queueEvent(e2, this.transportListeners);
    }
}

