/*
 * Decompiled with CFR 0.152.
 */
package com.werken.saxpath;

import com.werken.saxpath.Token;
import com.werken.saxpath.TokenTypes;
import com.werken.saxpath.XPathLexer;
import junit.framework.Assert;
import junit.framework.TestCase;

public class XPathLexerTokenTest
extends TestCase
implements TokenTypes {
    private XPathLexer lexer;

    public XPathLexerTokenTest(String name) {
        super(name);
    }

    private void runTest(String text, int[] expectedTokens) {
        this.lexer.setXPath(text);
        int tokenType = 0;
        Token token = null;
        int i2 = 0;
        while (i2 < expectedTokens.length) {
            tokenType = expectedTokens[i2];
            token = this.lexer.nextToken();
            Assert.assertNotNull((Object)token);
            Assert.assertEquals((int)tokenType, (int)token.getTokenType());
            ++i2;
        }
    }

    public void setUp() {
        this.lexer = new XPathLexer();
    }

    public void tearDown() {
        this.lexer = null;
    }

    public void testAt() {
        this.runTest("@", new int[]{16, -1});
    }

    public void testColon() {
        this.runTest(":", new int[]{18, -1});
    }

    public void testComma() {
        this.runTest(",", new int[]{32, -1});
    }

    public void testDollar() {
        this.runTest("$", new int[]{26, -1});
    }

    public void testDoubleColon() {
        this.runTest("::", new int[]{19, -1});
    }

    public void testDoubleDot() {
        this.runTest("..", new int[]{14, -1});
    }

    public void testDoubleSlash() {
        this.runTest("//", new int[]{12, -1});
    }

    public void testEquals() {
        this.runTest("=", new int[]{21, -1});
    }

    public void testGreaterThan() {
        this.runTest(">", new int[]{9, -1});
    }

    public void testGreaterThanEquals() {
        this.runTest(">=", new int[]{10, -1});
    }

    public void testIdentifier() {
        this.runTest("identifier", new int[]{15, -1});
    }

    public void testLeftBracket() {
        this.runTest("[", new int[]{3, -1});
    }

    public void testLeftParen() {
        this.runTest("(", new int[]{1, -1});
    }

    public void testLessThan() {
        this.runTest("<", new int[]{7, -1});
    }

    public void testLessThanEquals() {
        this.runTest("<=", new int[]{8, -1});
    }

    public void testLiteralDoubleQuote() {
        this.runTest("\"literal\"", new int[]{27, -1});
    }

    public void testLiteralSingleQuote() {
        this.runTest("'literal'", new int[]{27, -1});
    }

    public void testMinus() {
        this.runTest("-", new int[]{6, -1});
    }

    public void testNot() {
        this.runTest("!", new int[]{23, -1});
    }

    public void testNotEquals() {
        this.runTest("!=", new int[]{22, -1});
    }

    public void testNumberDouble() {
        this.runTest("42.42", new int[]{31, -1});
    }

    public void testNumberInteger() {
        this.runTest("42", new int[]{30, -1});
    }

    public void testOperatorAnd() {
        this.runTest("identifier and", new int[]{15, 28, -1});
    }

    public void testOperatorDiv() {
        this.runTest("identifier div", new int[]{15, 24});
    }

    public void testOperatorMod() {
        this.runTest("identifier mod", new int[]{15, 25, -1});
    }

    public void testOperatorOr() {
        this.runTest("identifier or", new int[]{15, 29, -1});
    }

    public void testPipe() {
        this.runTest("|", new int[]{17, -1});
    }

    public void testPlus() {
        this.runTest("+", new int[]{5, -1});
    }

    public void testRightBracket() {
        this.runTest("]", new int[]{4, -1});
    }

    public void testSingleDot() {
        this.runTest(".", new int[]{13, -1});
    }

    public void testSingleSlash() {
        this.runTest("/", new int[]{11, -1});
    }

    public void testStar() {
        this.runTest("*", new int[]{20, -1});
    }

    public void testWhitespace() {
        this.runTest(" \t \t \t", new int[]{-1});
    }
}

