/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import com.sun.mail.util.logging.CompactFormatter;
import com.sun.mail.util.logging.LogManagerProperties;
import com.sun.mail.util.logging.SeverityComparator;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorFormatter
extends Formatter {
    private static final long INIT_TIME = System.currentTimeMillis();
    private final String fmt;
    private final Formatter formatter;
    private final Comparator<? super LogRecord> comparator;
    private LogRecord last;
    private long count;
    private long thrown;
    private long minMillis;
    private long maxMillis;

    public CollectorFormatter() {
        String p2 = this.getClass().getName();
        this.fmt = this.initFormat(p2);
        this.formatter = this.initFormatter(p2);
        this.comparator = this.initComparator(p2);
        this.reset();
    }

    public CollectorFormatter(String format) {
        String p2 = this.getClass().getName();
        this.fmt = format == null ? this.initFormat(p2) : format;
        this.formatter = this.initFormatter(p2);
        this.comparator = this.initComparator(p2);
        this.reset();
    }

    public CollectorFormatter(String format, Formatter f2, Comparator<? super LogRecord> c2) {
        String p2 = this.getClass().getName();
        this.fmt = format == null ? this.initFormat(p2) : format;
        this.formatter = f2;
        this.comparator = c2;
        this.reset();
    }

    @Override
    public String format(LogRecord record) {
        boolean accepted;
        if (record == null) {
            throw new NullPointerException();
        }
        do {
            LogRecord update;
            LogRecord peek;
            if (peek != (update = this.apply((peek = this.peek()) != null ? peek : record, record))) {
                update.getSourceMethodName();
                accepted = this.acceptAndUpdate(peek, update);
                continue;
            }
            accepted = true;
            this.accept(record);
        } while (!accepted);
        return "";
    }

    @Override
    public String getTail(Handler h2) {
        return this.formatRecord(h2, true);
    }

    public String toString() {
        String result;
        try {
            result = this.formatRecord(null, false);
        }
        catch (RuntimeException ignore) {
            result = super.toString();
        }
        return result;
    }

    protected LogRecord apply(LogRecord t, LogRecord u) {
        if (t == null || u == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return this.comparator.compare(t, u) >= 0 ? t : u;
        }
        return u;
    }

    private synchronized void accept(LogRecord record) {
        long millis = record.getMillis();
        this.minMillis = Math.min(this.minMillis, millis);
        this.maxMillis = Math.max(this.maxMillis, millis);
        ++this.count;
        if (record.getThrown() != null) {
            ++this.thrown;
        }
    }

    private synchronized void reset() {
        this.last = null;
        this.count = 0L;
        this.thrown = 0L;
        this.minMillis = Long.MAX_VALUE;
        this.maxMillis = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatRecord(Handler h2, boolean reset) {
        String tail;
        String msg;
        String head;
        Formatter f2;
        long msh;
        long msl;
        long t;
        long c2;
        LogRecord record;
        CollectorFormatter collectorFormatter = this;
        synchronized (collectorFormatter) {
            record = this.last;
            c2 = this.count;
            t = this.thrown;
            msl = this.minMillis;
            msh = this.maxMillis;
            if (reset) {
                this.reset();
            }
        }
        if (c2 == 0L) {
            msl = INIT_TIME;
            msh = System.currentTimeMillis();
        }
        if ((f2 = this.formatter) != null) {
            Formatter formatter = f2;
            synchronized (formatter) {
                head = f2.getHead(h2);
                msg = record != null ? f2.format(record) : "";
                tail = f2.getTail(h2);
            }
        } else {
            tail = "";
            msg = "";
            head = "";
        }
        Locale l2 = null;
        if (record != null) {
            ResourceBundle rb = record.getResourceBundle();
            l2 = rb == null ? null : rb.getLocale();
        }
        MessageFormat mf = l2 == null ? new MessageFormat(this.fmt) : new MessageFormat(this.fmt, l2);
        return mf.format(new Object[]{this.finish(head), this.finish(msg), this.finish(tail), c2, c2 - 1L, t, c2 - t, msl, msh});
    }

    protected String finish(String s) {
        return s.trim();
    }

    private synchronized LogRecord peek() {
        return this.last;
    }

    private synchronized boolean acceptAndUpdate(LogRecord e2, LogRecord u) {
        if (e2 == this.last) {
            this.accept(u);
            this.last = u;
            return true;
        }
        return false;
    }

    private String initFormat(String p2) {
        LogManager m2 = LogManagerProperties.getLogManager();
        String v = m2.getProperty(p2.concat(".format"));
        if (v == null || v.length() == 0) {
            v = "{0}{1}{2}{4,choice,-1#|0#|0<... {4,number,integer} more}\n";
        }
        return v;
    }

    private Formatter initFormatter(String p2) {
        Formatter f2;
        LogManager m2 = LogManagerProperties.getLogManager();
        String v = m2.getProperty(p2.concat(".formatter"));
        if (v != null && v.length() != 0) {
            if (!"null".equalsIgnoreCase(v)) {
                try {
                    f2 = LogManagerProperties.newFormatter(v);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e2) {
                    throw new UndeclaredThrowableException(e2);
                }
            } else {
                f2 = null;
            }
        } else {
            f2 = (Formatter)Formatter.class.cast(new CompactFormatter());
        }
        return f2;
    }

    private Comparator<? super LogRecord> initComparator(String p2) {
        Comparator<? super LogRecord> c2;
        LogManager m2 = LogManagerProperties.getLogManager();
        String name = m2.getProperty(p2.concat(".comparator"));
        String reverse = m2.getProperty(p2.concat(".comparator.reverse"));
        try {
            if (name != null && name.length() != 0) {
                if (!"null".equalsIgnoreCase(name)) {
                    c2 = LogManagerProperties.newComparator(name);
                    if (Boolean.parseBoolean(reverse)) {
                        assert (c2 != null);
                        c2 = LogManagerProperties.reverseOrder(c2);
                    }
                } else {
                    if (reverse != null) {
                        throw new IllegalArgumentException("No comparator to reverse.");
                    }
                    c2 = null;
                }
            } else {
                if (reverse != null) {
                    throw new IllegalArgumentException("No comparator to reverse.");
                }
                c2 = (Comparator<? super LogRecord>)Comparator.class.cast(SeverityComparator.getInstance());
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e2) {
            throw new UndeclaredThrowableException(e2);
        }
        return c2;
    }
}

