/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.auth.Ntlm;
import com.sun.mail.iap.Argument;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.CopyUID;
import com.sun.mail.imap.ResyncData;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.SortTerm;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.BASE64MailboxEncoder;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.FLAGS;
import com.sun.mail.imap.protocol.FetchItem;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.ID;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MODSEQ;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.Namespaces;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.SaslAuthenticator;
import com.sun.mail.imap.protocol.SearchSequence;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.imap.protocol.UIDSet;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.MailLogger;
import com.sun.mail.util.PropUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.mail.Flags;
import javax.mail.Quota;
import javax.mail.internet.MimeUtility;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMAPProtocol
extends Protocol {
    private boolean connected = false;
    private boolean rev1 = false;
    private boolean noauthdebug = true;
    private boolean authenticated;
    private Map capabilities;
    private List authmechs;
    protected SearchSequence searchSequence;
    protected String[] searchCharsets;
    protected Set<String> enabled;
    private String name;
    private SaslAuthenticator saslAuthenticator;
    private String proxyAuthUser;
    private ByteArray ba;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final FetchItem[] fetchItems = new FetchItem[0];
    private volatile String idleTag;
    private static final byte[] DONE = new byte[]{68, 79, 78, 69, 13, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMAPProtocol(String name, String host, int port, Properties props, boolean isSSL, MailLogger logger) throws IOException, ProtocolException {
        super(host, port, props, "mail." + name, isSSL, logger);
        try {
            this.name = name;
            boolean bl = this.noauthdebug = !PropUtil.getBooleanProperty(props, "mail.debug.auth", false);
            if (this.capabilities == null) {
                this.capability();
            }
            if (this.hasCapability("IMAP4rev1")) {
                this.rev1 = true;
            }
            this.searchCharsets = new String[2];
            this.searchCharsets[0] = "UTF-8";
            this.searchCharsets[1] = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
            this.connected = true;
        }
        finally {
            if (!this.connected) {
                this.disconnect();
            }
        }
    }

    public IMAPProtocol(InputStream in, PrintStream out, Properties props, boolean debug) throws IOException {
        super(in, out, props, debug);
        this.name = "imap";
        boolean bl = this.noauthdebug = !PropUtil.getBooleanProperty(props, "mail.debug.auth", false);
        if (this.capabilities == null) {
            this.capabilities = new HashMap();
        }
        this.searchCharsets = new String[2];
        this.searchCharsets[0] = "UTF-8";
        this.searchCharsets[1] = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        this.connected = true;
    }

    public FetchItem[] getFetchItems() {
        return fetchItems;
    }

    public void capability() throws ProtocolException {
        Response[] r2 = this.command("CAPABILITY", null);
        if (!r2[r2.length - 1].isOK()) {
            throw new ProtocolException(r2[r2.length - 1].toString());
        }
        this.capabilities = new HashMap(10);
        this.authmechs = new ArrayList(5);
        int len = r2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            IMAPResponse ir;
            if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("CAPABILITY")) continue;
            this.parseCapabilities(ir);
        }
    }

    protected void setCapabilities(Response r2) {
        byte b2;
        while ((b2 = r2.readByte()) > 0 && b2 != 91) {
        }
        if (b2 == 0) {
            return;
        }
        String s = r2.readAtom();
        if (!s.equalsIgnoreCase("CAPABILITY")) {
            return;
        }
        this.capabilities = new HashMap(10);
        this.authmechs = new ArrayList(5);
        this.parseCapabilities(r2);
    }

    protected void parseCapabilities(Response r2) {
        String s;
        while ((s = r2.readAtom()) != null) {
            if (s.length() == 0) {
                if (r2.peekByte() == 93) break;
                r2.skipToken();
                continue;
            }
            this.capabilities.put(s.toUpperCase(Locale.ENGLISH), s);
            if (!s.regionMatches(true, 0, "AUTH=", 0, 5)) continue;
            this.authmechs.add(s.substring(5));
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("AUTH: " + s.substring(5));
        }
    }

    @Override
    protected void processGreeting(Response r2) throws ProtocolException {
        super.processGreeting(r2);
        if (r2.isOK()) {
            this.setCapabilities(r2);
            return;
        }
        assert (r2 instanceof IMAPResponse);
        IMAPResponse ir = (IMAPResponse)r2;
        if (!ir.keyEquals("PREAUTH")) {
            throw new ConnectionException(this, r2);
        }
        this.authenticated = true;
        this.setCapabilities(r2);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isREV1() {
        return this.rev1;
    }

    @Override
    protected boolean supportsNonSyncLiterals() {
        return this.hasCapability("LITERAL+");
    }

    @Override
    public Response readResponse() throws IOException, ProtocolException {
        IMAPResponse r2 = new IMAPResponse(this);
        if (r2.keyEquals("FETCH")) {
            r2 = new FetchResponse(r2, this.getFetchItems());
        }
        return r2;
    }

    public boolean hasCapability(String c2) {
        if (c2.endsWith("*")) {
            c2 = c2.substring(0, c2.length() - 1).toUpperCase(Locale.ENGLISH);
            Iterator it = this.capabilities.keySet().iterator();
            while (it.hasNext()) {
                if (!((String)it.next()).startsWith(c2)) continue;
                return true;
            }
            return false;
        }
        return this.capabilities.containsKey(c2.toUpperCase(Locale.ENGLISH));
    }

    public Map getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.authenticated = false;
    }

    public void noop() throws ProtocolException {
        this.logger.fine("IMAPProtocol noop");
        this.simpleCommand("NOOP", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws ProtocolException {
        try {
            Response[] r2 = this.command("LOGOUT", null);
            this.authenticated = false;
            this.notifyResponseHandlers(r2);
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String u, String p2) throws ProtocolException {
        Argument args = new Argument();
        args.writeString(u);
        args.writeString(p2);
        Response[] r2 = null;
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("LOGIN command trace suppressed");
                this.suspendTracing();
            }
            r2 = this.command("LOGIN", args);
        }
        finally {
            this.resumeTracing();
        }
        this.notifyResponseHandlers(r2);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine("LOGIN command result: " + r2[r2.length - 1]);
        }
        this.handleResult(r2[r2.length - 1]);
        this.setCapabilities(r2[r2.length - 1]);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void authlogin(String u, String p2) throws ProtocolException {
        ArrayList<Response> v = new ArrayList<Response>();
        String tag = null;
        Response r2 = null;
        boolean done = false;
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("AUTHENTICATE LOGIN command trace suppressed");
                this.suspendTracing();
            }
            try {
                tag = this.writeCommand("AUTHENTICATE LOGIN", null);
            }
            catch (Exception ex) {
                r2 = Response.byeResponse(ex);
                done = true;
            }
            OutputStream os = this.getOutputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
            boolean first = true;
            while (!done) {
                try {
                    r2 = this.readResponse();
                    if (r2.isContinuation()) {
                        String s;
                        if (first) {
                            s = u;
                            first = false;
                        } else {
                            s = p2;
                        }
                        ((OutputStream)b64os).write(ASCIIUtility.getBytes(s));
                        ((OutputStream)b64os).flush();
                        bos.write(CRLF);
                        os.write(bos.toByteArray());
                        os.flush();
                        bos.reset();
                        continue;
                    }
                    if (r2.isTagged() && r2.getTag().equals(tag)) {
                        done = true;
                        continue;
                    }
                    if (r2.isBYE()) {
                        done = true;
                        continue;
                    }
                    v.add(r2);
                }
                catch (Exception ioex) {
                    r2 = Response.byeResponse(ioex);
                    done = true;
                }
            }
        }
        finally {
            this.resumeTracing();
        }
        Response[] responses = v.toArray(new Response[v.size()]);
        this.notifyResponseHandlers(responses);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine("AUTHENTICATE LOGIN command result: " + r2);
        }
        this.handleResult(r2);
        this.setCapabilities(r2);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void authplain(String authzid, String u, String p2) throws ProtocolException {
        ArrayList<Response> v = new ArrayList<Response>();
        String tag = null;
        Response r2 = null;
        boolean done = false;
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("AUTHENTICATE PLAIN command trace suppressed");
                this.suspendTracing();
            }
            try {
                tag = this.writeCommand("AUTHENTICATE PLAIN", null);
            }
            catch (Exception ex) {
                r2 = Response.byeResponse(ex);
                done = true;
            }
            OutputStream os = this.getOutputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
            while (!done) {
                try {
                    r2 = this.readResponse();
                    if (r2.isContinuation()) {
                        String nullByte = "\u0000";
                        String s = (authzid == null ? "" : authzid) + "\u0000" + u + "\u0000" + p2;
                        ((OutputStream)b64os).write(ASCIIUtility.getBytes(s));
                        ((OutputStream)b64os).flush();
                        bos.write(CRLF);
                        os.write(bos.toByteArray());
                        os.flush();
                        bos.reset();
                        continue;
                    }
                    if (r2.isTagged() && r2.getTag().equals(tag)) {
                        done = true;
                        continue;
                    }
                    if (r2.isBYE()) {
                        done = true;
                        continue;
                    }
                    v.add(r2);
                }
                catch (Exception ioex) {
                    r2 = Response.byeResponse(ioex);
                    done = true;
                }
            }
        }
        finally {
            this.resumeTracing();
        }
        Response[] responses = v.toArray(new Response[v.size()]);
        this.notifyResponseHandlers(responses);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine("AUTHENTICATE PLAIN command result: " + r2);
        }
        this.handleResult(r2);
        this.setCapabilities(r2);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void authntlm(String authzid, String u, String p2) throws ProtocolException {
        ArrayList<Response> v = new ArrayList<Response>();
        String tag = null;
        Response r2 = null;
        boolean done = false;
        Object type1Msg = null;
        int flags = PropUtil.getIntProperty(this.props, "mail." + this.name + ".auth.ntlm.flags", 0);
        String domain = this.props.getProperty("mail." + this.name + ".auth.ntlm.domain", "");
        Ntlm ntlm = new Ntlm(domain, this.getLocalHost(), u, p2, this.logger);
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("AUTHENTICATE NTLM command trace suppressed");
                this.suspendTracing();
            }
            try {
                tag = this.writeCommand("AUTHENTICATE NTLM", null);
            }
            catch (Exception ex) {
                r2 = Response.byeResponse(ex);
                done = true;
            }
            OutputStream os = this.getOutputStream();
            boolean first = true;
            while (!done) {
                try {
                    r2 = this.readResponse();
                    if (r2.isContinuation()) {
                        String s;
                        if (first) {
                            s = ntlm.generateType1Msg(flags);
                            first = false;
                        } else {
                            s = ntlm.generateType3Msg(r2.getRest());
                        }
                        os.write(ASCIIUtility.getBytes(s));
                        os.write(CRLF);
                        os.flush();
                        continue;
                    }
                    if (r2.isTagged() && r2.getTag().equals(tag)) {
                        done = true;
                        continue;
                    }
                    if (r2.isBYE()) {
                        done = true;
                        continue;
                    }
                    v.add(r2);
                }
                catch (Exception ioex) {
                    r2 = Response.byeResponse(ioex);
                    done = true;
                }
            }
        }
        finally {
            this.resumeTracing();
        }
        Response[] responses = v.toArray(new Response[v.size()]);
        this.notifyResponseHandlers(responses);
        if (this.noauthdebug && this.isTracing()) {
            this.logger.fine("AUTHENTICATE NTLM command result: " + r2);
        }
        this.handleResult(r2);
        this.setCapabilities(r2);
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sasllogin(String[] allowed, String realm, String authzid, String u, String p2) throws ProtocolException {
        ArrayList<String> v;
        boolean useCanonicalHostName = PropUtil.getBooleanProperty(this.props, "mail." + this.name + ".sasl.usecanonicalhostname", false);
        String serviceHost = useCanonicalHostName ? this.getInetAddress().getCanonicalHostName() : this.host;
        if (this.saslAuthenticator == null) {
            try {
                Class<?> sac = Class.forName("com.sun.mail.imap.protocol.IMAPSaslAuthenticator");
                Constructor<?> c2 = sac.getConstructor(IMAPProtocol.class, String.class, Properties.class, MailLogger.class, String.class);
                this.saslAuthenticator = (SaslAuthenticator)c2.newInstance(this, this.name, this.props, this.logger, serviceHost);
            }
            catch (Exception ex) {
                this.logger.log(Level.FINE, "Can't load SASL authenticator", ex);
                return;
            }
        }
        if (allowed != null && allowed.length > 0) {
            v = new ArrayList<String>(allowed.length);
            for (int i2 = 0; i2 < allowed.length; ++i2) {
                if (!this.authmechs.contains(allowed[i2])) continue;
                v.add(allowed[i2]);
            }
        } else {
            v = this.authmechs;
        }
        String[] mechs = v.toArray(new String[v.size()]);
        try {
            if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("SASL authentication command trace suppressed");
                this.suspendTracing();
            }
            if (this.saslAuthenticator.authenticate(mechs, realm, authzid, u, p2)) {
                if (this.noauthdebug && this.isTracing()) {
                    this.logger.fine("SASL authentication succeeded");
                }
                this.authenticated = true;
            } else if (this.noauthdebug && this.isTracing()) {
                this.logger.fine("SASL authentication failed");
            }
        }
        finally {
            this.resumeTracing();
        }
    }

    OutputStream getIMAPOutputStream() {
        return this.getOutputStream();
    }

    public void proxyauth(String u) throws ProtocolException {
        Argument args = new Argument();
        args.writeString(u);
        this.simpleCommand("PROXYAUTH", args);
        this.proxyAuthUser = u;
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void unauthenticate() throws ProtocolException {
        if (!this.hasCapability("X-UNAUTHENTICATE")) {
            throw new BadCommandException("UNAUTHENTICATE not supported");
        }
        this.simpleCommand("UNAUTHENTICATE", null);
        this.authenticated = false;
    }

    public void id(String guid) throws ProtocolException {
        HashMap<String, String> gmap = new HashMap<String, String>();
        gmap.put("GUID", guid);
        this.id(gmap);
    }

    public void startTLS() throws ProtocolException {
        try {
            super.startTLS("STARTTLS");
        }
        catch (ProtocolException pex) {
            this.logger.log(Level.FINE, "STARTTLS ProtocolException", pex);
            throw pex;
        }
        catch (Exception ex) {
            this.logger.log(Level.FINE, "STARTTLS Exception", ex);
            Response[] r2 = new Response[]{Response.byeResponse(ex)};
            this.notifyResponseHandlers(r2);
            this.disconnect();
            throw new ProtocolException("STARTTLS failure", ex);
        }
    }

    public MailboxInfo select(String mbox) throws ProtocolException {
        return this.select(mbox, null);
    }

    public MailboxInfo select(String mbox, ResyncData rd) throws ProtocolException {
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        if (rd != null) {
            if (rd == ResyncData.CONDSTORE) {
                if (!this.hasCapability("CONDSTORE")) {
                    throw new BadCommandException("CONDSTORE not supported");
                }
                args.writeArgument(new Argument().writeAtom("CONDSTORE"));
            } else {
                if (!this.hasCapability("QRESYNC")) {
                    throw new BadCommandException("QRESYNC not supported");
                }
                args.writeArgument(IMAPProtocol.resyncArgs(rd));
            }
        }
        Response[] r2 = this.command("SELECT", args);
        MailboxInfo minfo = new MailboxInfo(r2);
        this.notifyResponseHandlers(r2);
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            minfo.mode = response.toString().indexOf("READ-ONLY") != -1 ? 1 : 2;
        }
        this.handleResult(response);
        return minfo;
    }

    public MailboxInfo examine(String mbox) throws ProtocolException {
        return this.examine(mbox, null);
    }

    public MailboxInfo examine(String mbox, ResyncData rd) throws ProtocolException {
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        if (rd != null) {
            if (rd == ResyncData.CONDSTORE) {
                if (!this.hasCapability("CONDSTORE")) {
                    throw new BadCommandException("CONDSTORE not supported");
                }
                args.writeArgument(new Argument().writeAtom("CONDSTORE"));
            } else {
                if (!this.hasCapability("QRESYNC")) {
                    throw new BadCommandException("QRESYNC not supported");
                }
                args.writeArgument(IMAPProtocol.resyncArgs(rd));
            }
        }
        Response[] r2 = this.command("EXAMINE", args);
        MailboxInfo minfo = new MailboxInfo(r2);
        minfo.mode = 1;
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        return minfo;
    }

    private static Argument resyncArgs(ResyncData rd) {
        Argument cmd = new Argument();
        cmd.writeAtom("QRESYNC");
        Argument args = new Argument();
        args.writeNumber(rd.getUIDValidity());
        args.writeNumber(rd.getModSeq());
        UIDSet[] uids = Utility.getResyncUIDSet(rd);
        if (uids != null) {
            args.writeString(UIDSet.toString(uids));
        }
        cmd.writeArgument(args);
        return cmd;
    }

    public void enable(String cap) throws ProtocolException {
        if (!this.hasCapability("ENABLE")) {
            throw new BadCommandException("ENABLE not supported");
        }
        Argument args = new Argument();
        args.writeAtom(cap);
        this.simpleCommand("ENABLE", args);
        if (this.enabled == null) {
            this.enabled = new HashSet<String>();
        }
        this.enabled.add(cap.toUpperCase(Locale.ENGLISH));
    }

    public boolean isEnabled(String cap) {
        if (this.enabled == null) {
            return false;
        }
        return this.enabled.contains(cap.toUpperCase(Locale.ENGLISH));
    }

    public void unselect() throws ProtocolException {
        if (!this.hasCapability("UNSELECT")) {
            throw new BadCommandException("UNSELECT not supported");
        }
        this.simpleCommand("UNSELECT", null);
    }

    public Status status(String mbox, String[] items) throws ProtocolException {
        if (!this.isREV1() && !this.hasCapability("IMAP4SUNVERSION")) {
            throw new BadCommandException("STATUS not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        Argument itemArgs = new Argument();
        if (items == null) {
            items = Status.standardItems;
        }
        int len = items.length;
        for (int i2 = 0; i2 < len; ++i2) {
            itemArgs.writeAtom(items[i2]);
        }
        args.writeArgument(itemArgs);
        Response[] r2 = this.command("STATUS", args);
        Status status = null;
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            int len2 = r2.length;
            for (int i3 = 0; i3 < len2; ++i3) {
                IMAPResponse ir;
                if (!(r2[i3] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i3]).keyEquals("STATUS")) continue;
                if (status == null) {
                    status = new Status(ir);
                } else {
                    Status.add(status, new Status(ir));
                }
                r2[i3] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return status;
    }

    public void create(String mbox) throws ProtocolException {
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        this.simpleCommand("CREATE", args);
    }

    public void delete(String mbox) throws ProtocolException {
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        this.simpleCommand("DELETE", args);
    }

    public void rename(String o2, String n2) throws ProtocolException {
        o2 = BASE64MailboxEncoder.encode(o2);
        n2 = BASE64MailboxEncoder.encode(n2);
        Argument args = new Argument();
        args.writeString(o2);
        args.writeString(n2);
        this.simpleCommand("RENAME", args);
    }

    public void subscribe(String mbox) throws ProtocolException {
        Argument args = new Argument();
        mbox = BASE64MailboxEncoder.encode(mbox);
        args.writeString(mbox);
        this.simpleCommand("SUBSCRIBE", args);
    }

    public void unsubscribe(String mbox) throws ProtocolException {
        Argument args = new Argument();
        mbox = BASE64MailboxEncoder.encode(mbox);
        args.writeString(mbox);
        this.simpleCommand("UNSUBSCRIBE", args);
    }

    public ListInfo[] list(String ref, String pattern) throws ProtocolException {
        return this.doList("LIST", ref, pattern);
    }

    public ListInfo[] lsub(String ref, String pattern) throws ProtocolException {
        return this.doList("LSUB", ref, pattern);
    }

    protected ListInfo[] doList(String cmd, String ref, String pat) throws ProtocolException {
        ref = BASE64MailboxEncoder.encode(ref);
        pat = BASE64MailboxEncoder.encode(pat);
        Argument args = new Argument();
        args.writeString(ref);
        args.writeString(pat);
        Response[] r2 = this.command(cmd, args);
        ListInfo[] linfo = null;
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            ArrayList<ListInfo> v = new ArrayList<ListInfo>(1);
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals(cmd)) continue;
                v.add(new ListInfo(ir));
                r2[i2] = null;
            }
            if (v.size() > 0) {
                linfo = v.toArray(new ListInfo[v.size()]);
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return linfo;
    }

    public void append(String mbox, Flags f2, Date d2, Literal data) throws ProtocolException {
        this.appenduid(mbox, f2, d2, data, false);
    }

    public AppendUID appenduid(String mbox, Flags f2, Date d2, Literal data) throws ProtocolException {
        return this.appenduid(mbox, f2, d2, data, true);
    }

    public AppendUID appenduid(String mbox, Flags f2, Date d2, Literal data, boolean uid) throws ProtocolException {
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        if (f2 != null) {
            if (f2.contains(Flags.Flag.RECENT)) {
                f2 = new Flags(f2);
                f2.remove(Flags.Flag.RECENT);
            }
            args.writeAtom(this.createFlagList(f2));
        }
        if (d2 != null) {
            args.writeString(INTERNALDATE.format(d2));
        }
        args.writeBytes(data);
        Response[] r2 = this.command("APPEND", args);
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        if (uid) {
            return this.getAppendUID(r2[r2.length - 1]);
        }
        return null;
    }

    private AppendUID getAppendUID(Response r2) {
        byte b2;
        if (!r2.isOK()) {
            return null;
        }
        while ((b2 = r2.readByte()) > 0 && b2 != 91) {
        }
        if (b2 == 0) {
            return null;
        }
        String s = r2.readAtom();
        if (!s.equalsIgnoreCase("APPENDUID")) {
            return null;
        }
        long uidvalidity = r2.readLong();
        long uid = r2.readLong();
        return new AppendUID(uidvalidity, uid);
    }

    public void check() throws ProtocolException {
        this.simpleCommand("CHECK", null);
    }

    public void close() throws ProtocolException {
        this.simpleCommand("CLOSE", null);
    }

    public void expunge() throws ProtocolException {
        this.simpleCommand("EXPUNGE", null);
    }

    public void uidexpunge(UIDSet[] set) throws ProtocolException {
        if (!this.hasCapability("UIDPLUS")) {
            throw new BadCommandException("UID EXPUNGE not supported");
        }
        this.simpleCommand("UID EXPUNGE " + UIDSet.toString(set), null);
    }

    public BODYSTRUCTURE fetchBodyStructure(int msgno) throws ProtocolException {
        Response[] r2 = this.fetch(msgno, "BODYSTRUCTURE");
        this.notifyResponseHandlers(r2);
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            return FetchResponse.getItem(r2, msgno, BODYSTRUCTURE.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY peekBody(int msgno, String section) throws ProtocolException {
        return this.fetchBody(msgno, section, true);
    }

    public BODY fetchBody(int msgno, String section) throws ProtocolException {
        return this.fetchBody(msgno, section, false);
    }

    protected BODY fetchBody(int msgno, String section, boolean peek) throws ProtocolException {
        if (section == null) {
            section = "";
        }
        String body = (peek ? "BODY.PEEK[" : "BODY[") + section + "]";
        return this.fetchSectionBody(msgno, section, body);
    }

    public BODY peekBody(int msgno, String section, int start, int size) throws ProtocolException {
        return this.fetchBody(msgno, section, start, size, true, null);
    }

    public BODY fetchBody(int msgno, String section, int start, int size) throws ProtocolException {
        return this.fetchBody(msgno, section, start, size, false, null);
    }

    public BODY peekBody(int msgno, String section, int start, int size, ByteArray ba) throws ProtocolException {
        return this.fetchBody(msgno, section, start, size, true, ba);
    }

    public BODY fetchBody(int msgno, String section, int start, int size, ByteArray ba) throws ProtocolException {
        return this.fetchBody(msgno, section, start, size, false, ba);
    }

    protected BODY fetchBody(int msgno, String section, int start, int size, boolean peek, ByteArray ba) throws ProtocolException {
        this.ba = ba;
        if (section == null) {
            section = "";
        }
        String body = (peek ? "BODY.PEEK[" : "BODY[") + section + "]<" + String.valueOf(start) + "." + String.valueOf(size) + ">";
        return this.fetchSectionBody(msgno, section, body);
    }

    protected BODY fetchSectionBody(int msgno, String section, String body) throws ProtocolException {
        Response[] r2 = this.fetch(msgno, body);
        this.notifyResponseHandlers(r2);
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            List<BODY> bl = FetchResponse.getItems(r2, msgno, BODY.class);
            if (bl.size() == 1) {
                return bl.get(0);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("got " + bl.size() + " BODY responses for section " + section);
            }
            for (BODY br : bl) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("got BODY section " + br.getSection());
                }
                if (!br.getSection().equalsIgnoreCase(section)) continue;
                return br;
            }
            return null;
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    @Override
    protected ByteArray getResponseBuffer() {
        ByteArray ret = this.ba;
        this.ba = null;
        return ret;
    }

    public RFC822DATA fetchRFC822(int msgno, String what) throws ProtocolException {
        Response[] r2 = this.fetch(msgno, what == null ? "RFC822" : "RFC822." + what);
        this.notifyResponseHandlers(r2);
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            return FetchResponse.getItem(r2, msgno, RFC822DATA.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public Flags fetchFlags(int msgno) throws ProtocolException {
        Flags flags = null;
        Response[] r2 = this.fetch(msgno, "FLAGS");
        int len = r2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            FetchResponse fr;
            if (r2[i2] == null || !(r2[i2] instanceof FetchResponse) || ((FetchResponse)r2[i2]).getNumber() != msgno || (flags = (Flags)(fr = (FetchResponse)r2[i2]).getItem(FLAGS.class)) == null) continue;
            r2[i2] = null;
            break;
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        return flags;
    }

    public UID fetchUID(int msgno) throws ProtocolException {
        Response[] r2 = this.fetch(msgno, "UID");
        this.notifyResponseHandlers(r2);
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            return FetchResponse.getItem(r2, msgno, UID.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public MODSEQ fetchMODSEQ(int msgno) throws ProtocolException {
        Response[] r2 = this.fetch(msgno, "MODSEQ");
        this.notifyResponseHandlers(r2);
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            return FetchResponse.getItem(r2, msgno, MODSEQ.class);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public UID fetchSequenceNumber(long uid) throws ProtocolException {
        UID u = null;
        Response[] r2 = this.fetch(String.valueOf(uid), "UID", true);
        int len = r2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            FetchResponse fr;
            if (r2[i2] == null || !(r2[i2] instanceof FetchResponse) || (u = (fr = (FetchResponse)r2[i2]).getItem(UID.class)) == null) continue;
            if (u.uid == uid) break;
            u = null;
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        return u;
    }

    public UID[] fetchSequenceNumbers(long start, long end) throws ProtocolException {
        Response[] r2 = this.fetch(String.valueOf(start) + ":" + (end == -1L ? "*" : String.valueOf(end)), "UID", true);
        ArrayList<UID> v = new ArrayList<UID>();
        int len = r2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            FetchResponse fr;
            UID u;
            if (r2[i2] == null || !(r2[i2] instanceof FetchResponse) || (u = (fr = (FetchResponse)r2[i2]).getItem(UID.class)) == null) continue;
            v.add(u);
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        return v.toArray(new UID[v.size()]);
    }

    public UID[] fetchSequenceNumbers(long[] uids) throws ProtocolException {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < uids.length; ++i2) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(String.valueOf(uids[i2]));
        }
        Response[] r2 = this.fetch(sb.toString(), "UID", true);
        ArrayList<UID> v = new ArrayList<UID>();
        int len = r2.length;
        for (int i3 = 0; i3 < len; ++i3) {
            FetchResponse fr;
            UID u;
            if (r2[i3] == null || !(r2[i3] instanceof FetchResponse) || (u = (fr = (FetchResponse)r2[i3]).getItem(UID.class)) == null) continue;
            v.add(u);
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        return v.toArray(new UID[v.size()]);
    }

    public int[] uidfetchChangedSince(long start, long end, long modseq) throws ProtocolException {
        String msgSequence = String.valueOf(start) + ":" + (end == -1L ? "*" : String.valueOf(end));
        Response[] r2 = this.command("UID FETCH " + msgSequence + " (FLAGS) (CHANGEDSINCE " + String.valueOf(modseq) + ")", null);
        ArrayList<Integer> v = new ArrayList<Integer>();
        int len = r2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (r2[i2] == null || !(r2[i2] instanceof FetchResponse)) continue;
            FetchResponse fr = (FetchResponse)r2[i2];
            v.add(fr.getNumber());
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        int vsize = v.size();
        int[] matches = new int[vsize];
        for (int i3 = 0; i3 < vsize; ++i3) {
            matches[i3] = (Integer)v.get(i3);
        }
        return matches;
    }

    public Response[] fetch(MessageSet[] msgsets, String what) throws ProtocolException {
        return this.fetch(MessageSet.toString(msgsets), what, false);
    }

    public Response[] fetch(int start, int end, String what) throws ProtocolException {
        return this.fetch(String.valueOf(start) + ":" + String.valueOf(end), what, false);
    }

    public Response[] fetch(int msg, String what) throws ProtocolException {
        return this.fetch(String.valueOf(msg), what, false);
    }

    private Response[] fetch(String msgSequence, String what, boolean uid) throws ProtocolException {
        if (uid) {
            return this.command("UID FETCH " + msgSequence + " (" + what + ")", null);
        }
        return this.command("FETCH " + msgSequence + " (" + what + ")", null);
    }

    public void copy(MessageSet[] msgsets, String mbox) throws ProtocolException {
        this.copyuid(MessageSet.toString(msgsets), mbox, false);
    }

    public void copy(int start, int end, String mbox) throws ProtocolException {
        this.copyuid(String.valueOf(start) + ":" + String.valueOf(end), mbox, false);
    }

    public CopyUID copyuid(MessageSet[] msgsets, String mbox) throws ProtocolException {
        return this.copyuid(MessageSet.toString(msgsets), mbox, true);
    }

    public CopyUID copyuid(int start, int end, String mbox) throws ProtocolException {
        return this.copyuid(String.valueOf(start) + ":" + String.valueOf(end), mbox, true);
    }

    public CopyUID copyuid(String msgSequence, String mbox, boolean uid) throws ProtocolException {
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeAtom(msgSequence);
        args.writeString(mbox);
        Response[] r2 = this.command("COPY", args);
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
        if (uid) {
            return this.getCopyUID(r2[r2.length - 1]);
        }
        return null;
    }

    private CopyUID getCopyUID(Response r2) {
        byte b2;
        if (!r2.isOK()) {
            return null;
        }
        while ((b2 = r2.readByte()) > 0 && b2 != 91) {
        }
        if (b2 == 0) {
            return null;
        }
        String s = r2.readAtom();
        if (!s.equalsIgnoreCase("COPYUID")) {
            return null;
        }
        long uidvalidity = r2.readLong();
        String src = r2.readAtom();
        String dst = r2.readAtom();
        return new CopyUID(uidvalidity, UIDSet.parseUIDSets(src), UIDSet.parseUIDSets(dst));
    }

    public void storeFlags(MessageSet[] msgsets, Flags flags, boolean set) throws ProtocolException {
        this.storeFlags(MessageSet.toString(msgsets), flags, set);
    }

    public void storeFlags(int start, int end, Flags flags, boolean set) throws ProtocolException {
        this.storeFlags(String.valueOf(start) + ":" + String.valueOf(end), flags, set);
    }

    public void storeFlags(int msg, Flags flags, boolean set) throws ProtocolException {
        this.storeFlags(String.valueOf(msg), flags, set);
    }

    private void storeFlags(String msgset, Flags flags, boolean set) throws ProtocolException {
        Response[] r2 = set ? this.command("STORE " + msgset + " +FLAGS " + this.createFlagList(flags), null) : this.command("STORE " + msgset + " -FLAGS " + this.createFlagList(flags), null);
        this.notifyResponseHandlers(r2);
        this.handleResult(r2[r2.length - 1]);
    }

    private String createFlagList(Flags flags) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        for (int i2 = 0; i2 < sf.length; ++i2) {
            String s;
            Flags.Flag f2 = sf[i2];
            if (f2 == Flags.Flag.ANSWERED) {
                s = "\\Answered";
            } else if (f2 == Flags.Flag.DELETED) {
                s = "\\Deleted";
            } else if (f2 == Flags.Flag.DRAFT) {
                s = "\\Draft";
            } else if (f2 == Flags.Flag.FLAGGED) {
                s = "\\Flagged";
            } else if (f2 == Flags.Flag.RECENT) {
                s = "\\Recent";
            } else {
                if (f2 != Flags.Flag.SEEN) continue;
                s = "\\Seen";
            }
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        String[] uf = flags.getUserFlags();
        for (int i3 = 0; i3 < uf.length; ++i3) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i3]);
        }
        sb.append(")");
        return sb.toString();
    }

    public int[] search(MessageSet[] msgsets, SearchTerm term) throws ProtocolException, SearchException {
        return this.search(MessageSet.toString(msgsets), term);
    }

    public int[] search(SearchTerm term) throws ProtocolException, SearchException {
        return this.search("ALL", term);
    }

    private int[] search(String msgSequence, SearchTerm term) throws ProtocolException, SearchException {
        this.getSearchSequence();
        if (SearchSequence.isAscii(term)) {
            try {
                return this.issueSearch(msgSequence, term, null);
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        for (int i2 = 0; i2 < this.searchCharsets.length; ++i2) {
            if (this.searchCharsets[i2] == null) continue;
            try {
                return this.issueSearch(msgSequence, term, this.searchCharsets[i2]);
            }
            catch (CommandFailedException cfx) {
                this.searchCharsets[i2] = null;
                continue;
            }
            catch (IOException ioex) {
                continue;
            }
            catch (ProtocolException pex) {
                throw pex;
            }
            catch (SearchException sex) {
                throw sex;
            }
        }
        throw new SearchException("Search failed");
    }

    private int[] issueSearch(String msgSequence, SearchTerm term, String charset) throws ProtocolException, SearchException, IOException {
        Argument args = this.getSearchSequence().generateSequence(term, charset == null ? null : MimeUtility.javaCharset(charset));
        args.writeAtom(msgSequence);
        Response[] r2 = charset == null ? this.command("SEARCH", args) : this.command("SEARCH CHARSET " + charset, args);
        Response response = r2[r2.length - 1];
        int[] matches = null;
        if (response.isOK()) {
            ArrayList<Integer> v = new ArrayList<Integer>();
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                int num;
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("SEARCH")) continue;
                while ((num = ir.readNumber()) != -1) {
                    v.add(num);
                }
                r2[i2] = null;
            }
            int vsize = v.size();
            matches = new int[vsize];
            for (int i3 = 0; i3 < vsize; ++i3) {
                matches[i3] = (Integer)v.get(i3);
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return matches;
    }

    protected SearchSequence getSearchSequence() {
        if (this.searchSequence == null) {
            this.searchSequence = new SearchSequence();
        }
        return this.searchSequence;
    }

    public int[] sort(SortTerm[] term, SearchTerm sterm) throws ProtocolException, SearchException {
        if (!this.hasCapability("SORT*")) {
            throw new BadCommandException("SORT not supported");
        }
        if (term == null || term.length == 0) {
            throw new BadCommandException("Must have at least one sort term");
        }
        Argument args = new Argument();
        Argument sargs = new Argument();
        for (int i2 = 0; i2 < term.length; ++i2) {
            sargs.writeAtom(term[i2].toString());
        }
        args.writeArgument(sargs);
        args.writeAtom("UTF-8");
        if (sterm != null) {
            try {
                args.append(this.getSearchSequence().generateSequence(sterm, "UTF-8"));
            }
            catch (IOException ioex) {
                throw new SearchException(ioex.toString());
            }
        } else {
            args.writeAtom("ALL");
        }
        Response[] r2 = this.command("SORT", args);
        Response response = r2[r2.length - 1];
        int[] matches = null;
        if (response.isOK()) {
            ArrayList<Integer> v = new ArrayList<Integer>();
            int len = r2.length;
            for (int i3 = 0; i3 < len; ++i3) {
                int num;
                IMAPResponse ir;
                if (!(r2[i3] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i3]).keyEquals("SORT")) continue;
                while ((num = ir.readNumber()) != -1) {
                    v.add(num);
                }
                r2[i3] = null;
            }
            int vsize = v.size();
            matches = new int[vsize];
            for (int i4 = 0; i4 < vsize; ++i4) {
                matches[i4] = (Integer)v.get(i4);
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return matches;
    }

    public Namespaces namespace() throws ProtocolException {
        if (!this.hasCapability("NAMESPACE")) {
            throw new BadCommandException("NAMESPACE not supported");
        }
        Response[] r2 = this.command("NAMESPACE", null);
        Namespaces namespace = null;
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("NAMESPACE")) continue;
                if (namespace == null) {
                    namespace = new Namespaces(ir);
                }
                r2[i2] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return namespace;
    }

    public Quota[] getQuotaRoot(String mbox) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("GETQUOTAROOT not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        Response[] r2 = this.command("GETQUOTAROOT", args);
        Response response = r2[r2.length - 1];
        Hashtable<String, Quota> tab = new Hashtable<String, Quota>();
        if (response.isOK()) {
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                if (!(r2[i2] instanceof IMAPResponse)) continue;
                IMAPResponse ir = (IMAPResponse)r2[i2];
                if (ir.keyEquals("QUOTAROOT")) {
                    ir.readAtomString();
                    String root = null;
                    while ((root = ir.readAtomString()) != null && root.length() > 0) {
                        tab.put(root, new Quota(root));
                    }
                    r2[i2] = null;
                    continue;
                }
                if (!ir.keyEquals("QUOTA")) continue;
                Quota quota = this.parseQuota(ir);
                Quota q2 = (Quota)tab.get(quota.quotaRoot);
                if (q2 != null && q2.resources != null) {
                    int newl = q2.resources.length + quota.resources.length;
                    Quota.Resource[] newr = new Quota.Resource[newl];
                    System.arraycopy(q2.resources, 0, newr, 0, q2.resources.length);
                    System.arraycopy(quota.resources, 0, newr, q2.resources.length, quota.resources.length);
                    quota.resources = newr;
                }
                tab.put(quota.quotaRoot, quota);
                r2[i2] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        Quota[] qa = new Quota[tab.size()];
        Enumeration e2 = tab.elements();
        int i3 = 0;
        while (e2.hasMoreElements()) {
            qa[i3] = (Quota)e2.nextElement();
            ++i3;
        }
        return qa;
    }

    public Quota[] getQuota(String root) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument args = new Argument();
        args.writeString(root);
        Response[] r2 = this.command("GETQUOTA", args);
        Quota quota = null;
        ArrayList<Quota> v = new ArrayList<Quota>();
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("QUOTA")) continue;
                quota = this.parseQuota(ir);
                v.add(quota);
                r2[i2] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return v.toArray(new Quota[v.size()]);
    }

    public void setQuota(Quota quota) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument args = new Argument();
        args.writeString(quota.quotaRoot);
        Argument qargs = new Argument();
        if (quota.resources != null) {
            for (int i2 = 0; i2 < quota.resources.length; ++i2) {
                qargs.writeAtom(quota.resources[i2].name);
                qargs.writeNumber(quota.resources[i2].limit);
            }
        }
        args.writeArgument(qargs);
        Response[] r2 = this.command("SETQUOTA", args);
        Response response = r2[r2.length - 1];
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
    }

    private Quota parseQuota(Response r2) throws ParsingException {
        String quotaRoot = r2.readAtomString();
        Quota q2 = new Quota(quotaRoot);
        r2.skipSpaces();
        if (r2.readByte() != 40) {
            throw new ParsingException("parse error in QUOTA");
        }
        ArrayList<Quota.Resource> v = new ArrayList<Quota.Resource>();
        while (r2.peekByte() != 41) {
            String name = r2.readAtom();
            if (name == null) continue;
            long usage = r2.readLong();
            long limit = r2.readLong();
            Quota.Resource res = new Quota.Resource(name, usage, limit);
            v.add(res);
        }
        r2.readByte();
        q2.resources = v.toArray(new Quota.Resource[v.size()]);
        return q2;
    }

    public void setACL(String mbox, char modifier, ACL acl) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        args.writeString(acl.getName());
        String rights = acl.getRights().toString();
        if (modifier == '+' || modifier == '-') {
            rights = modifier + rights;
        }
        args.writeString(rights);
        Response[] r2 = this.command("SETACL", args);
        Response response = r2[r2.length - 1];
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
    }

    public void deleteACL(String mbox, String user) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        args.writeString(user);
        Response[] r2 = this.command("DELETEACL", args);
        Response response = r2[r2.length - 1];
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
    }

    public ACL[] getACL(String mbox) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        Response[] r2 = this.command("GETACL", args);
        Response response = r2[r2.length - 1];
        ArrayList<ACL> v = new ArrayList<ACL>();
        if (response.isOK()) {
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                String rights;
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("ACL")) continue;
                ir.readAtomString();
                String name = null;
                while ((name = ir.readAtomString()) != null && (rights = ir.readAtomString()) != null) {
                    ACL acl = new ACL(name, new Rights(rights));
                    v.add(acl);
                }
                r2[i2] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return v.toArray(new ACL[v.size()]);
    }

    public Rights[] listRights(String mbox, String user) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        args.writeString(user);
        Response[] r2 = this.command("LISTRIGHTS", args);
        Response response = r2[r2.length - 1];
        ArrayList<Rights> v = new ArrayList<Rights>();
        if (response.isOK()) {
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                String rights;
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("LISTRIGHTS")) continue;
                ir.readAtomString();
                ir.readAtomString();
                while ((rights = ir.readAtomString()) != null) {
                    v.add(new Rights(rights));
                }
                r2[i2] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return v.toArray(new Rights[v.size()]);
    }

    public Rights myRights(String mbox) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeString(mbox);
        Response[] r2 = this.command("MYRIGHTS", args);
        Response response = r2[r2.length - 1];
        Rights rights = null;
        if (response.isOK()) {
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("MYRIGHTS")) continue;
                ir.readAtomString();
                String rs = ir.readAtomString();
                if (rights == null) {
                    rights = new Rights(rs);
                }
                r2[i2] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return rights;
    }

    public synchronized void idleStart() throws ProtocolException {
        if (!this.hasCapability("IDLE")) {
            throw new BadCommandException("IDLE not supported");
        }
        ArrayList<Response> v = new ArrayList<Response>();
        boolean done = false;
        Response r2 = null;
        try {
            this.idleTag = this.writeCommand("IDLE", null);
        }
        catch (LiteralException lex) {
            v.add(lex.getResponse());
            done = true;
        }
        catch (Exception ex) {
            v.add(Response.byeResponse(ex));
            done = true;
        }
        while (!done) {
            try {
                r2 = this.readResponse();
            }
            catch (IOException ioex) {
                r2 = Response.byeResponse(ioex);
            }
            catch (ProtocolException pex) {
                continue;
            }
            v.add(r2);
            if (!r2.isContinuation() && !r2.isBYE()) continue;
            done = true;
        }
        Response[] responses = v.toArray(new Response[v.size()]);
        r2 = responses[responses.length - 1];
        this.notifyResponseHandlers(responses);
        if (!r2.isContinuation()) {
            this.handleResult(r2);
        }
    }

    public synchronized Response readIdleResponse() {
        if (this.idleTag == null) {
            return null;
        }
        Response r2 = null;
        while (r2 == null) {
            try {
                r2 = this.readResponse();
            }
            catch (InterruptedIOException iioex) {
                if (iioex.bytesTransferred == 0) {
                    r2 = null;
                    continue;
                }
                r2 = Response.byeResponse(iioex);
            }
            catch (IOException ioex) {
                r2 = Response.byeResponse(ioex);
            }
            catch (ProtocolException pex) {
                r2 = Response.byeResponse(pex);
            }
        }
        return r2;
    }

    public boolean processIdleResponse(Response r2) throws ProtocolException {
        Response[] responses = new Response[]{r2};
        boolean done = false;
        this.notifyResponseHandlers(responses);
        if (r2.isBYE()) {
            done = true;
        }
        if (r2.isTagged() && r2.getTag().equals(this.idleTag)) {
            done = true;
        }
        if (done) {
            this.idleTag = null;
        }
        this.handleResult(r2);
        return !done;
    }

    public void idleAbort() {
        OutputStream os = this.getOutputStream();
        try {
            os.write(DONE);
            os.flush();
        }
        catch (Exception ex) {
            this.logger.log(Level.FINEST, "Exception aborting IDLE", ex);
        }
    }

    public Map<String, String> id(Map<String, String> clientParams) throws ProtocolException {
        if (!this.hasCapability("ID")) {
            throw new BadCommandException("ID not supported");
        }
        Response[] r2 = this.command("ID", ID.getArgumentList(clientParams));
        ID id = null;
        Response response = r2[r2.length - 1];
        if (response.isOK()) {
            int len = r2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                IMAPResponse ir;
                if (!(r2[i2] instanceof IMAPResponse) || !(ir = (IMAPResponse)r2[i2]).keyEquals("ID")) continue;
                if (id == null) {
                    id = new ID(ir);
                }
                r2[i2] = null;
            }
        }
        this.notifyResponseHandlers(r2);
        this.handleResult(response);
        return id == null ? null : id.getServerParams();
    }
}

