/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPAddress;
import com.sun.mail.imap.protocol.Item;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;

public class ENVELOPE
implements Item {
    static final char[] name = new char[]{'E', 'N', 'V', 'E', 'L', 'O', 'P', 'E'};
    public int msgno;
    public Date date = null;
    public String subject;
    public InternetAddress[] from;
    public InternetAddress[] sender;
    public InternetAddress[] replyTo;
    public InternetAddress[] to;
    public InternetAddress[] cc;
    public InternetAddress[] bcc;
    public String inReplyTo;
    public String messageId;
    private static MailDateFormat mailDateFormat = new MailDateFormat();

    public ENVELOPE(FetchResponse r2) throws ParsingException {
        this.msgno = r2.getNumber();
        r2.skipSpaces();
        if (r2.readByte() != 40) {
            throw new ParsingException("ENVELOPE parse error");
        }
        String s = r2.readString();
        if (s != null) {
            try {
                this.date = mailDateFormat.parse(s);
            }
            catch (ParseException pex) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.subject = r2.readString();
        this.from = this.parseAddressList(r2);
        this.sender = this.parseAddressList(r2);
        this.replyTo = this.parseAddressList(r2);
        this.to = this.parseAddressList(r2);
        this.cc = this.parseAddressList(r2);
        this.bcc = this.parseAddressList(r2);
        this.inReplyTo = r2.readString();
        this.messageId = r2.readString();
        if (r2.readByte() != 41) {
            throw new ParsingException("ENVELOPE parse error");
        }
    }

    private InternetAddress[] parseAddressList(Response r2) throws ParsingException {
        r2.skipSpaces();
        byte b2 = r2.readByte();
        if (b2 == 40) {
            if (r2.peekByte() == 41) {
                r2.skip(1);
                return null;
            }
            ArrayList<IMAPAddress> v = new ArrayList<IMAPAddress>();
            do {
                IMAPAddress a2;
                if ((a2 = new IMAPAddress(r2)).isEndOfGroup()) continue;
                v.add(a2);
            } while (r2.peekByte() != 41);
            r2.skip(1);
            return v.toArray(new InternetAddress[v.size()]);
        }
        if (b2 == 78 || b2 == 110) {
            r2.skip(2);
            return null;
        }
        throw new ParsingException("ADDRESS parse error");
    }
}

