/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.auth;

public final class MD4 {
    private final int[] state;
    private final int[] x;
    private static final int blockSize = 64;
    private final byte[] buffer = new byte[64];
    private int bufOfs;
    private long bytesProcessed;
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;
    private static final byte[] padding = new byte[136];

    public MD4() {
        this.state = new int[4];
        this.x = new int[16];
        this.implReset();
    }

    public byte[] digest(byte[] in) {
        this.implReset();
        this.engineUpdate(in, 0, in.length);
        byte[] out = new byte[16];
        this.implDigest(out, 0);
        return out;
    }

    private void implReset() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.bufOfs = 0;
        this.bytesProcessed = 0L;
    }

    private void implDigest(byte[] out, int ofs) {
        long bitsProcessed = this.bytesProcessed << 3;
        int index = (int)this.bytesProcessed & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.engineUpdate(padding, 0, padLen);
        this.buffer[56] = (byte)bitsProcessed;
        this.buffer[57] = (byte)(bitsProcessed >> 8);
        this.buffer[58] = (byte)(bitsProcessed >> 16);
        this.buffer[59] = (byte)(bitsProcessed >> 24);
        this.buffer[60] = (byte)(bitsProcessed >> 32);
        this.buffer[61] = (byte)(bitsProcessed >> 40);
        this.buffer[62] = (byte)(bitsProcessed >> 48);
        this.buffer[63] = (byte)(bitsProcessed >> 56);
        this.implCompress(this.buffer, 0);
        for (int i2 = 0; i2 < this.state.length; ++i2) {
            int x = this.state[i2];
            out[ofs++] = (byte)x;
            out[ofs++] = (byte)(x >> 8);
            out[ofs++] = (byte)(x >> 16);
            out[ofs++] = (byte)(x >> 24);
        }
    }

    private void engineUpdate(byte[] b2, int ofs, int len) {
        if (len == 0) {
            return;
        }
        if (ofs < 0 || len < 0 || ofs > b2.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.bytesProcessed < 0L) {
            this.implReset();
        }
        this.bytesProcessed += (long)len;
        if (this.bufOfs != 0) {
            int n2 = Math.min(len, 64 - this.bufOfs);
            System.arraycopy(b2, ofs, this.buffer, this.bufOfs, n2);
            this.bufOfs += n2;
            ofs += n2;
            len -= n2;
            if (this.bufOfs >= 64) {
                this.implCompress(this.buffer, 0);
                this.bufOfs = 0;
            }
        }
        while (len >= 64) {
            this.implCompress(b2, ofs);
            len -= 64;
            ofs += 64;
        }
        if (len > 0) {
            System.arraycopy(b2, ofs, this.buffer, 0, len);
            this.bufOfs = len;
        }
    }

    private static int FF(int a2, int b2, int c2, int d2, int x, int s) {
        return (a2 += (b2 & c2 | ~b2 & d2) + x) << s | a2 >>> 32 - s;
    }

    private static int GG(int a2, int b2, int c2, int d2, int x, int s) {
        return (a2 += (b2 & c2 | b2 & d2 | c2 & d2) + x + 1518500249) << s | a2 >>> 32 - s;
    }

    private static int HH(int a2, int b2, int c2, int d2, int x, int s) {
        return (a2 += (b2 ^ c2 ^ d2) + x + 1859775393) << s | a2 >>> 32 - s;
    }

    private void implCompress(byte[] buf, int ofs) {
        for (int xfs = 0; xfs < this.x.length; ++xfs) {
            this.x[xfs] = buf[ofs] & 0xFF | (buf[ofs + 1] & 0xFF) << 8 | (buf[ofs + 2] & 0xFF) << 16 | (buf[ofs + 3] & 0xFF) << 24;
            ofs += 4;
        }
        int a2 = this.state[0];
        int b2 = this.state[1];
        int c2 = this.state[2];
        int d2 = this.state[3];
        a2 = MD4.FF(a2, b2, c2, d2, this.x[0], 3);
        d2 = MD4.FF(d2, a2, b2, c2, this.x[1], 7);
        c2 = MD4.FF(c2, d2, a2, b2, this.x[2], 11);
        b2 = MD4.FF(b2, c2, d2, a2, this.x[3], 19);
        a2 = MD4.FF(a2, b2, c2, d2, this.x[4], 3);
        d2 = MD4.FF(d2, a2, b2, c2, this.x[5], 7);
        c2 = MD4.FF(c2, d2, a2, b2, this.x[6], 11);
        b2 = MD4.FF(b2, c2, d2, a2, this.x[7], 19);
        a2 = MD4.FF(a2, b2, c2, d2, this.x[8], 3);
        d2 = MD4.FF(d2, a2, b2, c2, this.x[9], 7);
        c2 = MD4.FF(c2, d2, a2, b2, this.x[10], 11);
        b2 = MD4.FF(b2, c2, d2, a2, this.x[11], 19);
        a2 = MD4.FF(a2, b2, c2, d2, this.x[12], 3);
        d2 = MD4.FF(d2, a2, b2, c2, this.x[13], 7);
        c2 = MD4.FF(c2, d2, a2, b2, this.x[14], 11);
        b2 = MD4.FF(b2, c2, d2, a2, this.x[15], 19);
        a2 = MD4.GG(a2, b2, c2, d2, this.x[0], 3);
        d2 = MD4.GG(d2, a2, b2, c2, this.x[4], 5);
        c2 = MD4.GG(c2, d2, a2, b2, this.x[8], 9);
        b2 = MD4.GG(b2, c2, d2, a2, this.x[12], 13);
        a2 = MD4.GG(a2, b2, c2, d2, this.x[1], 3);
        d2 = MD4.GG(d2, a2, b2, c2, this.x[5], 5);
        c2 = MD4.GG(c2, d2, a2, b2, this.x[9], 9);
        b2 = MD4.GG(b2, c2, d2, a2, this.x[13], 13);
        a2 = MD4.GG(a2, b2, c2, d2, this.x[2], 3);
        d2 = MD4.GG(d2, a2, b2, c2, this.x[6], 5);
        c2 = MD4.GG(c2, d2, a2, b2, this.x[10], 9);
        b2 = MD4.GG(b2, c2, d2, a2, this.x[14], 13);
        a2 = MD4.GG(a2, b2, c2, d2, this.x[3], 3);
        d2 = MD4.GG(d2, a2, b2, c2, this.x[7], 5);
        c2 = MD4.GG(c2, d2, a2, b2, this.x[11], 9);
        b2 = MD4.GG(b2, c2, d2, a2, this.x[15], 13);
        a2 = MD4.HH(a2, b2, c2, d2, this.x[0], 3);
        d2 = MD4.HH(d2, a2, b2, c2, this.x[8], 9);
        c2 = MD4.HH(c2, d2, a2, b2, this.x[4], 11);
        b2 = MD4.HH(b2, c2, d2, a2, this.x[12], 15);
        a2 = MD4.HH(a2, b2, c2, d2, this.x[2], 3);
        d2 = MD4.HH(d2, a2, b2, c2, this.x[10], 9);
        c2 = MD4.HH(c2, d2, a2, b2, this.x[6], 11);
        b2 = MD4.HH(b2, c2, d2, a2, this.x[14], 15);
        a2 = MD4.HH(a2, b2, c2, d2, this.x[1], 3);
        d2 = MD4.HH(d2, a2, b2, c2, this.x[9], 9);
        c2 = MD4.HH(c2, d2, a2, b2, this.x[5], 11);
        b2 = MD4.HH(b2, c2, d2, a2, this.x[13], 15);
        a2 = MD4.HH(a2, b2, c2, d2, this.x[3], 3);
        d2 = MD4.HH(d2, a2, b2, c2, this.x[11], 9);
        c2 = MD4.HH(c2, d2, a2, b2, this.x[7], 11);
        b2 = MD4.HH(b2, c2, d2, a2, this.x[15], 15);
        this.state[0] = this.state[0] + a2;
        this.state[1] = this.state[1] + b2;
        this.state[2] = this.state[2] + c2;
        this.state[3] = this.state[3] + d2;
    }

    static {
        MD4.padding[0] = -128;
    }
}

