/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

import com.snmp4j.smi.CompilationMonitor;
import java.awt.Component;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class CompilerProgressMonitor
implements CompilationMonitor {
    private Component parentComponent;
    private ProgressMonitor progressMonitorLoading;
    private ProgressMonitor progressMonitorSorting;
    private ProgressMonitor progressMonitorCompilation;

    public CompilerProgressMonitor(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public boolean loadingProgress(String s, int current, int maxCount) {
        if (this.progressMonitorLoading == null) {
            if (this.progressMonitorCompilation != null) {
                this.progressMonitorCompilation.close();
            }
            this.progressMonitorLoading = new ProgressMonitor(this.parentComponent, "Loading...", s, current, maxCount);
        } else {
            SwingUtilities.invokeLater(new SwingUpdater(this.progressMonitorLoading, s, current));
        }
        return !this.progressMonitorLoading.isCanceled();
    }

    @Override
    public boolean sortingProgress(String s, int current, int maxCount) {
        if (this.progressMonitorSorting == null) {
            this.progressMonitorSorting = new ProgressMonitor(this.parentComponent, "Sorting...", s, current, maxCount);
        } else {
            SwingUtilities.invokeLater(new SwingUpdater(this.progressMonitorSorting, s, current));
        }
        return !this.progressMonitorSorting.isCanceled();
    }

    @Override
    public boolean compilationProgress(String s, int current, int maxCount) {
        if (this.progressMonitorCompilation == null) {
            if (this.progressMonitorSorting != null) {
                this.progressMonitorSorting.close();
            }
            this.progressMonitorCompilation = new ProgressMonitor(this.parentComponent, "Compiling...", s, current, maxCount);
        } else {
            SwingUtilities.invokeLater(new SwingUpdater(this.progressMonitorCompilation, s, current));
        }
        return !this.progressMonitorCompilation.isCanceled();
    }

    public void close() {
        if (this.progressMonitorLoading != null) {
            this.progressMonitorLoading.close();
            this.progressMonitorLoading = null;
        }
        if (this.progressMonitorCompilation != null) {
            this.progressMonitorCompilation.close();
            this.progressMonitorCompilation = null;
        }
        if (this.progressMonitorSorting != null) {
            this.progressMonitorSorting.close();
            this.progressMonitorSorting = null;
        }
    }

    private class SwingUpdater
    implements Runnable {
        private ProgressMonitor progressMonitor;
        private String message;
        private int current;

        private SwingUpdater(ProgressMonitor progressMonitor, String message, int current) {
            this.progressMonitor = progressMonitor;
            this.message = message;
            this.current = current;
        }

        @Override
        public void run() {
            this.progressMonitor.setProgress(this.current);
            this.progressMonitor.setNote(this.message);
        }
    }
}

