/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.os;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.PropertyUtils;
import com.sitraka.licensing.util.arch.Arch;
import com.sitraka.licensing.util.os.Environment;
import com.sitraka.licensing.util.os.OS;
import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;

class Windows
extends OS {
    public static final String OS_NAME = "windows";
    public static final String EXE_EXTENSION = ".exe";
    private static final String[] CMD_ENV_WINNT = new String[]{"cmd.exe", "/c", "set"};
    private static final String[] CMD_HOSTNAME_WINNT = new String[]{"hostname.exe"};
    private static final Logger logger = Logger.getLogger();
    private static final String WINDOWSVERSION = "WindowsVersion";
    private String fullWindowsVersion;
    private String windowsRelease;
    private String windowsServicePack;
    private String windowsBuild;
    static /* synthetic */ Class class$com$sitraka$licensing$util$os$Windows;

    public Windows() {
        super(EXE_EXTENSION);
        this.setBrowserLaunchStrategy(this.getDefaultBrowserLaunchStrategy());
        this.windowsRelease = null;
        this.windowsServicePack = null;
        this.windowsBuild = null;
    }

    public String getName() {
        return OS_NAME;
    }

    protected boolean matches(String string, String string2) {
        return string.indexOf(OS_NAME) != -1 && (string.indexOf("nt") != -1 || string.indexOf("200") != -1 || string.indexOf("xp") != -1 || string.indexOf("vista") != -1 || string.indexOf("7") != -1);
    }

    protected void parseFullWindowsVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        stringTokenizer.nextToken();
        this.windowsRelease = !stringTokenizer.hasMoreTokens() ? "Unrecognized release: '" + string + "'" : stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.windowsServicePack = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.windowsBuild = stringTokenizer.nextToken();
        }
    }

    public String getHostName() {
        block4: {
            if (hostname == null) {
                logger.debug(class$com$sitraka$licensing$util$os$Windows == null ? (class$com$sitraka$licensing$util$os$Windows = Windows.class$("com.sitraka.licensing.util.os.Windows")) : class$com$sitraka$licensing$util$os$Windows, "getHostName() called");
                try {
                    Environment environment = Environment.getInstance();
                    hostname = environment.getEnv("COMPUTERNAME");
                    if (hostname == null || hostname.length() == 0) {
                        hostname = InetAddress.getLocalHost().getHostName();
                    }
                }
                catch (Exception exception) {
                    hostname = Windows.executeCommand(CMD_HOSTNAME_WINNT).trim();
                    if (hostname.length() != 0) break block4;
                    logger.warning(this, "warn.hostname.exception", exception);
                }
            }
        }
        return hostname;
    }

    protected String[] getEnvCommand() {
        return CMD_ENV_WINNT;
    }

    private OS.BrowserLaunchStrategy getDefaultBrowserLaunchStrategy() {
        return new OS.BrowserLaunchStrategy(){

            public boolean displayURL(String string) {
                try {
                    String[] stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", string};
                    Runtime.getRuntime().exec(stringArray);
                    return true;
                }
                catch (IOException iOException) {
                    logger.error(this, "error.browser.exception", iOException);
                    return false;
                }
            }
        };
    }

    protected void getProcessorsImpl() {
        try {
            String string = this.getHostInfoData();
            this.fullWindowsVersion = PropertyUtils.readProperty(string, WINDOWSVERSION, "=");
            this.parseFullWindowsVersion(this.fullWindowsVersion);
            int[] nArray = Arch.getCurrent().parseCPUInfo(string);
            physicalCPUCount = nArray[0];
            if (physicalCPUCount <= 0) {
                logger.warning(this, "warn.physicalProcessors.notValid");
                physicalCPUCount = -2;
            }
            if ((onlineCPUCount = nArray[1]) <= 0) {
                logger.warning(this, "warn.onlineProcessors.notValid");
                onlineCPUCount = -2;
            }
            if ((totalCPUCount = nArray[2]) <= 0) {
                logger.warning(this, "warn.totalProcessors.notValid");
                totalCPUCount = -2;
            }
        }
        catch (Exception exception) {
            logger.error(this, "error.cpuinfo.exception", exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

