/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.os;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.PropertyUtils;
import com.sitraka.licensing.util.os.OS;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Environment {
    private Map env = new HashMap();
    private static Environment instance = null;
    private static final Logger logger = Logger.getLogger();

    private Environment() {
        this.loadEnvironment(this.env);
    }

    public static Environment getInstance() {
        if (instance == null) {
            instance = new Environment();
        }
        return instance;
    }

    private void loadEnvironment(Map map) {
        OS oS = OS.getCurrent();
        String string = OS.executeCommand(oS.getEnvCommand());
        if (string != null && string.length() > 0) {
            try {
                PropertyUtils.loadFromReader(map, new StringReader(string));
            }
            catch (IOException iOException) {
                logger.error(this, "error.env.parseEnv", iOException);
            }
        } else {
            logger.error(this, "error.env.executeEnvCommand");
        }
    }

    public String getEnv(String string) {
        return (String)this.env.get(string);
    }

    public boolean hasEnv(String string) {
        return this.env.containsKey(string);
    }

    public String[] getFullEnvironment() {
        String[] stringArray = new String[this.env.size()];
        Iterator iterator = this.env.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringArray[n2] = entry.getKey() + "=" + entry.getValue();
            ++n2;
        }
        return stringArray;
    }
}

