/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util.arch;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.PropertyUtils;
import com.sitraka.licensing.util.arch.Arch;

class IA64
extends Arch {
    private static final Logger logger = Logger.getLogger();
    public static final String ARCH_NAME = "ia64";

    IA64() {
    }

    public String getName() {
        return ARCH_NAME;
    }

    protected boolean matches(String string) {
        return string.indexOf(ARCH_NAME) != -1;
    }

    public int[] parseCPUInfo(String string) {
        int[] nArray = new int[]{-2, -2, -2};
        nArray[0] = PropertyUtils.readPropertyInt(string, "OnlineProcessors", "=");
        nArray[1] = PropertyUtils.readPropertyInt(string, "OnlineProcessors", "=");
        nArray[2] = PropertyUtils.readPropertyInt(string, "ConfiguredProcessors", "=");
        if (nArray[1] <= 0) {
            logger.warning(this, "warn.onlineProcessors.notValid");
            nArray[1] = -2;
        }
        if (nArray[0] <= 0) {
            logger.warning(this, "warn.physicalProcessors.notValid");
            nArray[0] = -2;
        }
        if (nArray[2] <= 0) {
            logger.warning(this, "warn.totalProcessors.notValid");
            nArray[2] = -2;
        }
        return nArray;
    }
}

