/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.util.Debug;
import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.arch.Arch;
import com.sitraka.licensing.util.os.OS;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Platform {
    private static final Logger logger = Logger.getLogger();
    private static final int UNKNOWN_PROCESSOR_COUNT = 1;
    private static int physicalProcessors = Integer.MIN_VALUE;
    private static int onlineProcessors = Integer.MIN_VALUE;
    private static int totalProcessors = Integer.MIN_VALUE;
    private static String hostName = null;
    private static boolean ascii = "A".getBytes()[0] == 65;
    static /* synthetic */ Class class$com$sitraka$licensing$util$Platform;

    private Platform() {
    }

    public static String getOSName() {
        return Platform.getOS().getName();
    }

    public static String getOSName(String string, String string2) {
        return OS.getOS(string, string2).getName();
    }

    public static String getArchName() {
        return Arch.getCurrent().getName();
    }

    public static boolean isAscii() {
        return ascii;
    }

    public static int getNumberProcessors() {
        return Platform.getOnlineProcessors();
    }

    public static int getPhysicalProcessors() {
        if (physicalProcessors <= 0) {
            physicalProcessors = Platform.getOS().getPhysicalProcessors();
            logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "getPhysicalProcessors(): determined physical processor count == " + physicalProcessors);
        }
        if (physicalProcessors <= 0) {
            logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "OS.getPhysicalProcessors() returned <= 0. Uh-Oh! Assuming 1");
            physicalProcessors = 1;
        }
        return physicalProcessors;
    }

    public static int getOnlineProcessors() {
        if (onlineProcessors <= 0) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Method method = runtime.getClass().getMethod("availableProcessors", null);
                onlineProcessors = (Integer)method.invoke((Object)runtime, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "Ignoring error, just checking for the method's existence", noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "Ignoring error, just checking for the method's existence", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "Ignoring error, just checking for the method's existence", invocationTargetException);
            }
            if (onlineProcessors <= 0) {
                logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "Could not use java.Runtime.availableProcessors() to get logical processor count");
                onlineProcessors = Platform.getOS().getOnlineProcessors();
                logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "getOnlineProcessors(): determined processor count == " + onlineProcessors);
            } else {
                logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "Java tells us that there are " + onlineProcessors + " online processors");
            }
            if (onlineProcessors <= 0) {
                logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "OS.getOnlineProcessors() returned <= 0. Uh-Oh!. Assuming 1");
                onlineProcessors = 1;
            }
        }
        return onlineProcessors;
    }

    public static int getTotalProcessors() {
        if (totalProcessors <= 0) {
            totalProcessors = Platform.getOS().getTotalProcessors();
            logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "getTotalProcessors(): determined  total processor count == " + totalProcessors);
        }
        if (totalProcessors <= 0) {
            logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "OS.getTotalProcessors() returned <= 0. Uh-Oh! Assuming 1");
            totalProcessors = 1;
        }
        return totalProcessors;
    }

    public static String getHostName() {
        if (hostName == null) {
            hostName = Platform.getOS().getHostName();
        }
        return hostName;
    }

    public static OS getOS() {
        return OS.getCurrent();
    }

    public static void main(String[] stringArray) {
        Debug.setEnabled(true);
        Platform.getPhysicalProcessors();
        Platform.getOnlineProcessors();
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "Results:");
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "--------");
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tos.name: " + System.getProperty("os.name"));
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tos.arch: " + System.getProperty("os.arch"));
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tos.version: " + System.getProperty("os.version"));
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tStandard OS name: " + Platform.getOSName());
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tStandard arch name: " + Platform.getArchName());
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tPhysical processors: " + Platform.getPhysicalProcessors());
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tLogical processors: " + Platform.getOnlineProcessors());
        logger.debug(class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform, "\tHost name: " + Platform.getOS().getHostName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

