/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.util.Logger;
import com.sitraka.licensing.util.os.OS;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public final class HostUtils {
    protected static Set addresses = null;
    protected static SortedSet hostNames = null;
    protected static SortedSet ipaddresses = null;
    protected static String bestHostName = null;
    private static final Logger logger = Logger.getLogger();
    static /* synthetic */ Class class$com$sitraka$licensing$util$HostUtils;

    private HostUtils() {
    }

    public static String getBestHostName() {
        if (bestHostName != null) {
            return bestHostName;
        }
        SortedSet sortedSet = HostUtils.getValidHostNames();
        int n2 = Integer.MIN_VALUE;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n3 = new StringTokenizer(string, ".").countTokens();
            if (bestHostName == null && HostUtils.isIPAddress(string)) {
                bestHostName = string;
                continue;
            }
            if (n3 <= n2) continue;
            bestHostName = string;
            n2 = n3;
        }
        return bestHostName;
    }

    public static SortedSet getValidHostNames() {
        String string;
        Object object;
        if (hostNames != null) {
            return hostNames;
        }
        hostNames = new TreeSet();
        Iterator iterator = null;
        try {
            iterator = HostUtils.getValidInetAddresses().iterator();
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Ignoring exception, will fall back on native host name", unknownHostException);
        }
        while (iterator != null && iterator.hasNext()) {
            object = (InetAddress)iterator.next();
            string = ((InetAddress)object).getHostName().toLowerCase();
            String string2 = HostUtils.reresolveIPAddress((InetAddress)object);
            if (!string2.startsWith(string)) {
                logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? HostUtils.class$("com.sitraka.licensing.util.HostUtils") : class$com$sitraka$licensing$util$HostUtils, "Adding original name '" + string + "'");
                hostNames.add(string);
            }
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? HostUtils.class$("com.sitraka.licensing.util.HostUtils") : class$com$sitraka$licensing$util$HostUtils, "Adding reresolved name '" + string2 + "'");
            hostNames.add(string2);
        }
        object = OS.getCurrent().getHostName();
        if (object != null) {
            string = HostUtils.reresolveIPAddress((String)(object = ((String)object).toLowerCase()));
            if (!string.startsWith((String)object)) {
                logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Adding native hostname '" + (String)object + "'");
                hostNames.add(object);
            }
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Adding native hostname (re-resolved) '" + string + "'");
            hostNames.add(string);
        } else {
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Could not determine host name using native method, Only using network information");
        }
        return hostNames;
    }

    public static SortedSet getValidIpAddresses() {
        if (ipaddresses != null) {
            return ipaddresses;
        }
        ipaddresses = new TreeSet();
        try {
            Iterator iterator = HostUtils.getValidInetAddresses().iterator();
            while (iterator.hasNext()) {
                InetAddress inetAddress = (InetAddress)iterator.next();
                String string = inetAddress.getHostAddress();
                if (string.startsWith("127.") || string.startsWith("0.")) {
                    logger.warning((Object)(class$com$sitraka$licensing$util$HostUtils == null ? HostUtils.class$("com.sitraka.licensing.util.HostUtils") : class$com$sitraka$licensing$util$HostUtils), "warn.hostname.invalidIP", null, inetAddress);
                    continue;
                }
                ipaddresses.add(string);
            }
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Ignoring exception", unknownHostException);
        }
        return ipaddresses;
    }

    public static Set getValidInetAddresses() throws UnknownHostException {
        if (addresses != null) {
            return addresses;
        }
        addresses = new HashSet();
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        if (string != null) {
            if (HostUtils.isValidIPAddress(inetAddress)) {
                addresses.add(inetAddress);
            } else {
                logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Skipping invalid localhost InetAddress: '" + inetAddress + "'");
            }
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            int n2 = inetAddressArray == null ? 0 : inetAddressArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (HostUtils.isValidIPAddress(inetAddressArray[i2])) {
                    addresses.add(inetAddressArray[i2]);
                    continue;
                }
                logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? HostUtils.class$("com.sitraka.licensing.util.HostUtils") : class$com$sitraka$licensing$util$HostUtils, "Skipping invalid InetAddress: '" + inetAddressArray[i2] + "'");
            }
        }
        return addresses;
    }

    public static boolean compareHosts(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("null hosts are not allowed");
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        boolean bl = false;
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            int n2 = inetAddressArray == null ? 0 : inetAddressArray.length;
            InetAddress[] inetAddressArray2 = InetAddress.getAllByName(string2);
            int n3 = inetAddressArray2 == null ? 0 : inetAddressArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!HostUtils.isValidIPAddress(inetAddressArray[i2])) {
                    logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? HostUtils.class$("com.sitraka.licensing.util.HostUtils") : class$com$sitraka$licensing$util$HostUtils, "A. Skipping invalid IP address '" + inetAddressArray[i2] + "' in compareHosts()");
                    continue;
                }
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (!HostUtils.isValidIPAddress(inetAddressArray2[i3])) {
                        logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? HostUtils.class$("com.sitraka.licensing.util.HostUtils") : class$com$sitraka$licensing$util$HostUtils, "B. Skipping invalid IP address '" + inetAddressArray2[i3] + "' in compareHosts()");
                        continue;
                    }
                    if (!inetAddressArray[i2].equals(inetAddressArray2[i3])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Ignoring exception assuming no match on host name comparision", unknownHostException);
            bl = false;
        }
        return bl;
    }

    private static boolean isIPAddress(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2) || c2 == '.') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIPAddress(InetAddress inetAddress) {
        boolean bl = true;
        if (inetAddress.getHostName().trim().length() == 0) {
            bl = false;
        } else if (inetAddress.getHostName().equals("0.0.0.0")) {
            bl = false;
        } else if (inetAddress.getAddress()[0] == 0) {
            bl = false;
        } else if (inetAddress.getAddress()[0] == 127) {
            bl = false;
        }
        return bl;
    }

    private static String reresolveIPAddress(String string) {
        try {
            return HostUtils.reresolveIPAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Ignoring exception, falling back to original host name", unknownHostException);
            return string;
        }
    }

    private static String reresolveIPAddress(InetAddress inetAddress) {
        String string;
        String string2 = string = inetAddress.getHostName().toLowerCase();
        try {
            InetAddress inetAddress2 = InetAddress.getByName(inetAddress.getHostAddress());
            if (!HostUtils.isValidIPAddress(inetAddress2)) {
                logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Skipping invalid reverse resolved IP address '" + inetAddress2 + "'");
            } else {
                string2 = inetAddress2.getHostName().toLowerCase();
            }
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug(class$com$sitraka$licensing$util$HostUtils == null ? (class$com$sitraka$licensing$util$HostUtils = HostUtils.class$("com.sitraka.licensing.util.HostUtils")) : class$com$sitraka$licensing$util$HostUtils, "Ignoring exception, falling back to original host name", unknownHostException);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

